/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.management;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import weblogic.ant.taskdefs.management.MBeanCommand;
import weblogic.ant.taskdefs.management.MBeanCreateCommand;
import weblogic.ant.taskdefs.management.MBeanDeleteCommand;
import weblogic.ant.taskdefs.management.MBeanGetCommand;
import weblogic.ant.taskdefs.management.MBeanInvokeCommand;
import weblogic.ant.taskdefs.management.MBeanQueryCommand;
import weblogic.ant.taskdefs.management.MBeanSetCommand;
import weblogic.management.MBeanCreationException;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commandline.tools.MBeanCommandLineInvoker;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.security.ProviderMBean;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.security.authorization.AdjudicatorMBean;
import weblogic.management.security.authorization.AuthorizerMBean;
import weblogic.management.security.authorization.RoleMapperMBean;
import weblogic.management.security.credentials.CredentialMapperMBean;
import weblogic.management.security.pk.CertPathProviderMBean;
import weblogic.management.security.pk.KeyStoreMBean;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.utils.StringUtils;
import weblogic.utils.TypeConversionUtils;

public class WLConfig
extends Task {
    private static String JNDI = "/jndi/";
    private static String RUNTIME_MBEANSERVER = "weblogic.management.mbeanservers.runtime";
    private static String EDIT_SERVICE = EditServiceMBean.OBJECT_NAME;
    private static String EDIT_MBEANSERVER = "weblogic.management.mbeanservers.edit";
    private static String[][] baseProviderTypes = new String[][]{{"AuditorTypes", "createAuditor"}, {"AuthenticationProviderTypes", "createAuthenticationProvider"}, {"RoleMapperTypes", "createRoleMapper"}, {"AuthorizerTypes", "createAuthorizer"}, {"AdjudicatorTypes", "createAdjudicator"}, {"CredentialMapperTypes", "createCredentialMapper"}, {"CertPathProviderTypes", "createCertPathProvider"}, {"KeyStoreTypes", "createKeyStore"}};
    private String adminurl;
    private String username;
    private String password;
    private String userConfigFile;
    private String userKeyFile;
    private ArrayList commands = new ArrayList();
    private boolean failOnError = true;
    private String domainName = null;

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUrl(String string) {
        this.adminurl = string;
    }

    public void addCreate(MBeanCreateCommand mBeanCreateCommand) {
        this.commands.add(mBeanCreateCommand);
    }

    public void addDelete(MBeanDeleteCommand mBeanDeleteCommand) {
        this.commands.add(mBeanDeleteCommand);
    }

    public void addSet(MBeanSetCommand mBeanSetCommand) {
        this.commands.add(mBeanSetCommand);
    }

    public void addGet(MBeanGetCommand mBeanGetCommand) {
        this.commands.add(mBeanGetCommand);
    }

    public void addQuery(MBeanQueryCommand mBeanQueryCommand) {
        this.commands.add(mBeanQueryCommand);
    }

    public void setUserConfigFile(String string) {
        this.userConfigFile = string;
    }

    public void setUserKeyFile(String string) {
        this.userKeyFile = string;
    }

    public void addInvoke(MBeanInvokeCommand mBeanInvokeCommand) {
        this.commands.add(mBeanInvokeCommand);
    }

    public void execute() throws BuildException {
        MBeanHome mBeanHome;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            InitialContext initialContext = this.getInitialContext();
            mBeanHome = (MBeanHome)initialContext.lookup("weblogic.management.adminhome");
        }
        catch (NamingException namingException) {
            try {
                InitialContext initialContext = this.getInitialContext();
                mBeanHome = (MBeanHome)initialContext.lookup("weblogic.management.home.localhome");
            }
            catch (NamingException namingException2) {
                this.handleException("Failed to connect to the server", namingException2);
                return;
            }
        }
        Iterator iterator = this.commands.iterator();
        try {
            this.executeCommands(mBeanHome, iterator, null);
        }
        catch (BuildException buildException) {
            if (this.failOnError) {
                throw buildException;
            }
            this.log(buildException.toString());
        }
    }

    public void executeCommands(MBeanHome mBeanHome, Iterator iterator, WebLogicMBean webLogicMBean) throws BuildException {
        while (iterator.hasNext()) {
            MBeanCommand mBeanCommand = (MBeanCommand)iterator.next();
            switch (mBeanCommand.getCommandType()) {
                case 1: {
                    this.invokeCreateCommand(mBeanHome, webLogicMBean, (MBeanCreateCommand)mBeanCommand);
                    break;
                }
                case 2: {
                    this.invokeDeleteCommand(mBeanHome, (MBeanDeleteCommand)mBeanCommand);
                    break;
                }
                case 3: {
                    this.invokeSetCommand(mBeanHome, (MBeanSetCommand)mBeanCommand);
                    break;
                }
                case 4: {
                    this.invokeGetCommand(mBeanHome, (MBeanGetCommand)mBeanCommand);
                    break;
                }
                case 5: {
                    this.invokeQueryCommand(mBeanHome, (MBeanQueryCommand)mBeanCommand);
                    break;
                }
                case 7: {
                    this.invokeInvokeCommand(mBeanHome, (MBeanInvokeCommand)mBeanCommand);
                }
            }
        }
    }

    private void invokeCreateCommand(MBeanHome mBeanHome, WebLogicMBean webLogicMBean, MBeanCreateCommand mBeanCreateCommand) {
        Object object;
        Object object2;
        WebLogicMBean webLogicMBean2 = null;
        String string = null;
        if (mBeanCreateCommand.getType() == null) {
            this.handleException("Type not specified for create command");
            return;
        }
        try {
            if (mBeanCreateCommand.getDomain() == null) {
                mBeanCreateCommand.setDomain(this.getDomainName(mBeanHome));
            }
            webLogicMBean2 = webLogicMBean != null && webLogicMBean instanceof ConfigurationMBean ? mBeanHome.createAdminMBean(mBeanCreateCommand.getName(), mBeanCreateCommand.getType(), mBeanCreateCommand.getDomain(), (ConfigurationMBean)webLogicMBean) : mBeanHome.createAdminMBean(mBeanCreateCommand.getName(), mBeanCreateCommand.getType(), mBeanCreateCommand.getDomain());
            string = webLogicMBean2.getObjectName().toString();
            this.log("Created MBEAN: " + string, 3);
        }
        catch (MBeanCreationException mBeanCreationException) {
            this.invokeCreateSecurityBean(mBeanCreateCommand, (Exception)((Object)mBeanCreationException));
            return;
        }
        if (mBeanCreateCommand.getProperty() != null) {
            this.getProject().setProperty(mBeanCreateCommand.getProperty(), string);
        }
        Iterator iterator = mBeanCreateCommand.getSetCommands();
        while (iterator.hasNext()) {
            object2 = (MBeanSetCommand)iterator.next();
            ((MBeanSetCommand)object2).setMBean(string);
            this.invokeSetCommand(mBeanHome, (MBeanSetCommand)object2);
        }
        object2 = mBeanCreateCommand.getInvokeCommands();
        while (object2.hasNext()) {
            object = (MBeanInvokeCommand)object2.next();
            ((MBeanInvokeCommand)object).setMBean(string);
            this.invokeInvokeCommand(mBeanHome, (MBeanInvokeCommand)object);
        }
        object = mBeanCreateCommand.getCreateCommands();
        this.executeCommands(mBeanHome, (Iterator)object, webLogicMBean2);
    }

    private ObjectName invokeCreateCommand(MBeanServerConnection mBeanServerConnection, ObjectName objectName, MBeanCreateCommand mBeanCreateCommand) {
        ObjectName objectName2;
        if (mBeanCreateCommand.getType() == null) {
            throw new BuildException("Type not specified for create command");
        }
        String string = mBeanCreateCommand.getName();
        String string2 = mBeanCreateCommand.getType();
        try {
            Object[] objectArray = new Object[]{string};
            String[] stringArray = new String[]{"java.lang.String"};
            objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, "create" + string2, objectArray, stringArray);
        }
        catch (Throwable throwable) {
            throw new BuildException("Error creating Bean " + string, throwable);
        }
        return objectName2;
    }

    private void invokeCreateSecurityBean(MBeanCreateCommand mBeanCreateCommand, Exception exception) {
        String string = null;
        try {
            MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
            this.startEdit(mBeanServerConnection);
            try {
                Object object;
                Object object2;
                ObjectName objectName = this.createSecurityBean(mBeanServerConnection, mBeanCreateCommand.getName(), mBeanCreateCommand.getType(), mBeanCreateCommand.getRealm());
                string = objectName.toString();
                this.log("[CREATE] Created a new provider " + string, 3);
                Iterator iterator = mBeanCreateCommand.getSetCommands();
                while (iterator.hasNext()) {
                    object2 = (MBeanSetCommand)iterator.next();
                    ((MBeanSetCommand)object2).setMBean(string);
                    this.invokeSetCommand(mBeanServerConnection, (MBeanSetCommand)object2);
                }
                object2 = mBeanCreateCommand.getInvokeCommands();
                while (object2.hasNext()) {
                    object = (MBeanInvokeCommand)object2.next();
                    ((MBeanInvokeCommand)object).setMBean(string);
                    this.invokeInvokeCommand(mBeanServerConnection, (MBeanInvokeCommand)object);
                }
                object = mBeanCreateCommand.getCreateCommands();
                while (object.hasNext()) {
                    MBeanCreateCommand mBeanCreateCommand2 = (MBeanCreateCommand)object.next();
                    this.invokeCreateCommand(mBeanServerConnection, objectName, mBeanCreateCommand2);
                }
                this.activate(mBeanServerConnection);
            }
            catch (Exception exception2) {
                this.rollback(mBeanServerConnection);
                throw exception2;
            }
        }
        catch (Exception exception3) {
            throw new BuildException("Unable to create mbean: " + exception3, (Throwable)exception);
        }
        if (mBeanCreateCommand.getProperty() != null) {
            this.getProject().setProperty(mBeanCreateCommand.getProperty(), string);
        }
    }

    private void invokeInvokeCommand(MBeanHome mBeanHome, MBeanInvokeCommand mBeanInvokeCommand) throws BuildException {
        if (this.isProperty(mBeanInvokeCommand.getMBean())) {
            mBeanInvokeCommand.setMBean(this.getRequiredProperty(mBeanInvokeCommand.getMBean()));
        }
        if (mBeanInvokeCommand.getType() == null && mBeanInvokeCommand.getMBean() == null) {
            this.handleException("MBean name or type not specified for invoke command");
            return;
        }
        if (mBeanInvokeCommand.getMethodName() == null) {
            this.handleException("Method name not specified for invoke command");
            return;
        }
        if (mBeanInvokeCommand.getArguments() == null) {
            mBeanInvokeCommand.setArguments("");
        }
        String[] stringArray = this.getConnectParams();
        String string = StringUtils.join((String[])stringArray, (String)" ");
        string = string + " invoke ";
        string = mBeanInvokeCommand.getMBean() != null ? string + "-mbean " + mBeanInvokeCommand.getMBean() + " " : string + "-type " + mBeanInvokeCommand.getType() + " ";
        string = string + "-method " + mBeanInvokeCommand.getMethodName() + " ";
        String[] stringArray2 = StringUtils.splitCompletely((String)mBeanInvokeCommand.getArguments(), (String)" ");
        for (int i = 0; i < stringArray2.length; ++i) {
            string = string + stringArray2[i] + " ";
        }
        String[] stringArray3 = StringUtils.splitCompletely((String)string, (String)" ");
        this.invokeCommand(stringArray3);
    }

    private void invokeInvokeCommand(MBeanServerConnection mBeanServerConnection, MBeanInvokeCommand mBeanInvokeCommand) throws BuildException {
        if (this.isProperty(mBeanInvokeCommand.getMBean())) {
            mBeanInvokeCommand.setMBean(this.getRequiredProperty(mBeanInvokeCommand.getMBean()));
        }
        if (mBeanInvokeCommand.getType() == null && mBeanInvokeCommand.getMBean() == null) {
            this.handleException("MBean name or type not specified for invoke command");
            return;
        }
        if (mBeanInvokeCommand.getMethodName() == null) {
            this.handleException("Method name not specified for invoke command");
            return;
        }
        if (mBeanInvokeCommand.getArguments() == null) {
            mBeanInvokeCommand.setArguments("");
        }
        throw new BuildException("Nested invokes not supported in this context");
    }

    private void invokeSetCommand(MBeanHome mBeanHome, MBeanSetCommand mBeanSetCommand) throws BuildException {
        if (this.isProperty(mBeanSetCommand.getValue())) {
            mBeanSetCommand.setValue(this.getRequiredProperty(mBeanSetCommand.getValue()));
        }
        if (this.isProperty(mBeanSetCommand.getMBean())) {
            mBeanSetCommand.setMBean(this.getRequiredProperty(mBeanSetCommand.getMBean()));
        }
        if (mBeanSetCommand.getMBean() == null) {
            this.handleException("MBean not specified for set command");
            return;
        }
        if (mBeanSetCommand.getAttribute() == null) {
            this.handleException("Attribute not specified for set command");
            return;
        }
        if (mBeanSetCommand.getValue() == null) {
            this.handleException("Value not specified for set command");
            return;
        }
        Object object = null;
        try {
            object = this.getMBean(mBeanHome, mBeanSetCommand.getMBean());
        }
        catch (BuildException buildException) {
            MBeanServerConnection mBeanServerConnection = null;
            try {
                mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
                this.startEdit(mBeanServerConnection);
                this.invokeSetCommand(mBeanServerConnection, mBeanSetCommand);
                this.log("[Set] New values have been set, not comitted yet");
                this.activate(mBeanServerConnection);
                this.log("[Set] Changed values have been committed");
            }
            catch (Exception exception) {
                this.handleException(exception);
                this.rollback(mBeanServerConnection);
                this.log("[Set] Changed values have been rolled back");
            }
            return;
        }
        if (object instanceof ProviderMBean) {
            this.setOnProvider((ProviderMBean)object, mBeanSetCommand);
        } else if (object instanceof RealmMBean) {
            this.setOnRealm((RealmMBean)object, mBeanSetCommand);
        } else if (mBeanSetCommand.getAttribute().equalsIgnoreCase("parent")) {
            try {
                WebLogicObjectName webLogicObjectName = new WebLogicObjectName(mBeanSetCommand.getMBean());
                WebLogicMBean webLogicMBean = (WebLogicMBean)mBeanHome.getProxy((ObjectName)webLogicObjectName);
                WebLogicObjectName webLogicObjectName2 = new WebLogicObjectName(mBeanSetCommand.getValue());
                WebLogicMBean webLogicMBean2 = (WebLogicMBean)mBeanHome.getProxy((ObjectName)webLogicObjectName2);
                this.log("SET " + mBeanSetCommand.getMBean() + " parent=" + mBeanSetCommand.getValue(), 3);
                webLogicMBean.setParent(webLogicMBean2);
            }
            catch (JMException jMException) {
                this.handleException("Error setting parent", jMException);
                return;
            }
            catch (ConfigurationException configurationException) {
                this.handleException("Error setting parent", configurationException);
                return;
            }
        } else {
            String[] stringArray = this.getConnectParams();
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 6];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n++] = "SET";
            if (mBeanSetCommand.getMBean() != null) {
                stringArray2[n++] = "-mbean";
                stringArray2[n++] = mBeanSetCommand.getMBean();
            }
            stringArray2[n++] = "-property";
            stringArray2[n++] = mBeanSetCommand.getAttribute();
            stringArray2[n++] = mBeanSetCommand.getValue();
            this.invokeCommand(stringArray2);
        }
    }

    private void invokeSetCommand(MBeanServerConnection mBeanServerConnection, MBeanSetCommand mBeanSetCommand) throws BuildException {
        if (this.isProperty(mBeanSetCommand.getValue())) {
            mBeanSetCommand.setValue(this.getRequiredProperty(mBeanSetCommand.getValue()));
        }
        if (this.isProperty(mBeanSetCommand.getMBean())) {
            mBeanSetCommand.setMBean(this.getRequiredProperty(mBeanSetCommand.getMBean()));
        }
        if (mBeanSetCommand.getMBean() == null) {
            this.handleException("MBean not specified for set command");
            return;
        }
        if (mBeanSetCommand.getAttribute() == null) {
            this.handleException("Attribute not specified for set command");
            return;
        }
        if (mBeanSetCommand.getValue() == null) {
            this.handleException("Value not specified for set command");
            return;
        }
        this.setOnBean(mBeanServerConnection, mBeanSetCommand.getMBean(), mBeanSetCommand.getAttribute(), mBeanSetCommand.getValue());
    }

    private void setOnProvider(ProviderMBean providerMBean, MBeanSetCommand mBeanSetCommand) {
        String string = providerMBean.getName();
        try {
            MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
            String string2 = providerMBean.getRealm().getName();
            ObjectName objectName = this.getRealm(mBeanServerConnection, string2);
            this.startEdit(mBeanServerConnection);
            try {
                String[] stringArray;
                Object[] objectArray;
                ObjectName objectName2;
                String string3 = this.getProviderMethod(providerMBean, "lookup");
                if (string3.startsWith("get")) {
                    objectName2 = (ObjectName)mBeanServerConnection.getAttribute(objectName, string3.substring(3));
                    if (objectName2 == null) {
                        throw new BuildException("Could not find " + string);
                    }
                } else {
                    objectArray = new Object[]{string};
                    stringArray = new String[]{"java.lang.String"};
                    objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, string3, objectArray, stringArray);
                    if (objectName2 == null) {
                        throw new BuildException("Could not find " + string);
                    }
                }
                objectArray = mBeanSetCommand.getAttribute();
                stringArray = mBeanSetCommand.getValue();
                this.setOnBean(mBeanServerConnection, objectName2, (String)objectArray, (String)stringArray);
                this.activate(mBeanServerConnection);
            }
            catch (Exception exception) {
                this.rollback(mBeanServerConnection);
                throw exception;
            }
        }
        catch (Exception exception) {
            this.handleException("Unable to modify mbean: " + exception, exception);
            return;
        }
    }

    private void setOnBean(MBeanServerConnection mBeanServerConnection, String string, String string2, String string3) throws BuildException {
        try {
            ObjectName objectName = new ObjectName(string);
            this.setOnBean(mBeanServerConnection, objectName, string2, string3);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new BuildException((Throwable)malformedObjectNameException);
        }
    }

    private void setOnBean(MBeanServerConnection mBeanServerConnection, ObjectName objectName, String string, String string2) throws BuildException {
        try {
            MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            MBeanAttributeInfo mBeanAttributeInfo = null;
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
                mBeanAttributeInfo = mBeanAttributeInfoArray[i];
                break;
            }
            if (mBeanAttributeInfo == null) {
                throw new BuildException("No such attribute: " + string);
            }
            String string3 = mBeanAttributeInfo.getType();
            Attribute attribute = new Attribute(string, this.convertObject(string2, string3));
            mBeanServerConnection.setAttribute(objectName, attribute);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void setOnRealm(RealmMBean realmMBean, MBeanSetCommand mBeanSetCommand) {
        try {
            MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
            String string = mBeanSetCommand.getAttribute();
            String string2 = mBeanSetCommand.getValue();
            String string3 = realmMBean.getName();
            ObjectName objectName = this.getRealm(mBeanServerConnection, string3);
            this.startEdit(mBeanServerConnection);
            try {
                MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                MBeanAttributeInfo mBeanAttributeInfo = null;
                for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                    if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
                    mBeanAttributeInfo = mBeanAttributeInfoArray[i];
                    break;
                }
                if (mBeanAttributeInfo == null) {
                    throw new BuildException("No such attribute: " + string);
                }
                String string4 = mBeanAttributeInfo.getType();
                Attribute attribute = new Attribute(string, this.convertObject(string2, string4));
                mBeanServerConnection.setAttribute(objectName, attribute);
                this.activate(mBeanServerConnection);
            }
            catch (Exception exception) {
                this.rollback(mBeanServerConnection);
                throw exception;
            }
        }
        catch (Exception exception) {
            this.handleException("Unable to modify mbean: " + exception, exception);
            return;
        }
    }

    private void invokeGetCommand(MBeanHome mBeanHome, MBeanGetCommand mBeanGetCommand) throws BuildException {
        if (mBeanGetCommand.getAttribute() == null) {
            this.handleException("Attribute not specified in get command");
            return;
        }
        if (mBeanGetCommand.getProperty() == null) {
            this.handleException("Property not specified in get command");
            return;
        }
        if (this.isProperty(mBeanGetCommand.getMBean())) {
            mBeanGetCommand.setMBean(this.getRequiredProperty(mBeanGetCommand.getMBean()));
        }
        try {
            WebLogicObjectName[] webLogicObjectNameArray;
            Object object;
            Object object2 = this.getMBean(mBeanHome, mBeanGetCommand.getMBean());
            Object object3 = null;
            if (object2 instanceof WebLogicMBean) {
                object = (WebLogicMBean)object2;
                object3 = object.getAttribute(mBeanGetCommand.getAttribute());
            } else if (object2 instanceof ObjectInstance) {
                object = (ObjectInstance)object2;
                webLogicObjectNameArray = mBeanHome.getMBeanServer();
                object3 = webLogicObjectNameArray.getAttribute(((ObjectInstance)object).getObjectName(), mBeanGetCommand.getAttribute());
            } else {
                object = mBeanHome.getMBeanServer();
                object3 = object.getAttribute(this.getObjectName(object2), mBeanGetCommand.getAttribute());
            }
            if (object3 != null) {
                object = "";
                if (object3 instanceof WebLogicObjectName[]) {
                    webLogicObjectNameArray = (WebLogicObjectName[])object3;
                    for (int i = 0; i < webLogicObjectNameArray.length; ++i) {
                        object = (String)object + webLogicObjectNameArray[i];
                        if (i + 1 >= webLogicObjectNameArray.length) continue;
                        object = (String)object + ";";
                    }
                } else {
                    object = object3.toString();
                }
                this.getProject().setProperty(mBeanGetCommand.getProperty(), (String)object);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            this.handleException("No Such MBean", instanceNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            this.handleException("No Such Attribute: " + mBeanGetCommand.getAttribute(), attributeNotFoundException);
        }
        catch (MBeanException mBeanException) {
            this.handleException("Error retrieving attribute: " + mBeanGetCommand.getAttribute(), mBeanException);
        }
        catch (ReflectionException reflectionException) {
            this.handleException("Error retrieving attribute: " + mBeanGetCommand.getAttribute(), reflectionException);
        }
        catch (BuildException buildException) {
            this.handleException(buildException);
        }
    }

    private ObjectName getObjectName(Object object) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof MBeanServerInvocationHandler) {
            return MBeanServerInvocationHandler.getObjectName((Object)object);
        }
        if (object instanceof WebLogicMBean) {
            return ((WebLogicMBean)object).getObjectName();
        }
        if (object instanceof StandardInterface) {
            return ((StandardInterface)object).wls_getObjectName();
        }
        return null;
    }

    private void invokeDeleteCommand(MBeanHome mBeanHome, MBeanDeleteCommand mBeanDeleteCommand) throws BuildException {
        if (this.isProperty(mBeanDeleteCommand.getMBean())) {
            mBeanDeleteCommand.setMBean(this.getRequiredProperty(mBeanDeleteCommand.getMBean()));
        }
        try {
            block18: {
                Object object = null;
                try {
                    object = this.getMBean(mBeanHome, mBeanDeleteCommand.getMBean());
                }
                catch (BuildException buildException) {
                    MBeanServerConnection mBeanServerConnection = null;
                    try {
                        mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
                        this.startEdit(mBeanServerConnection);
                        mBeanServerConnection.unregisterMBean(new ObjectName(mBeanDeleteCommand.getMBean()));
                        this.log("[Delete] MBean has been unregistered, uncomitted yet");
                        this.activate(mBeanServerConnection);
                        this.log("[Delete] Changes have been committed");
                    }
                    catch (Exception exception) {
                        this.handleException(exception);
                        this.rollback(mBeanServerConnection);
                        this.log("[Delete] Delete has been rolled back");
                    }
                    return;
                }
                if (object instanceof WebLogicMBean) {
                    mBeanHome.deleteMBean((WebLogicMBean)object);
                } else {
                    if (object instanceof RealmMBean || object instanceof ProviderMBean) {
                        try {
                            MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection(EDIT_MBEANSERVER);
                            this.startEdit(mBeanServerConnection);
                            try {
                                if (object instanceof ProviderMBean) {
                                    ProviderMBean providerMBean = (ProviderMBean)object;
                                    this.destroySecurityBean(mBeanServerConnection, providerMBean);
                                } else {
                                    RealmMBean realmMBean = (RealmMBean)object;
                                    this.destroyRealmBean(mBeanServerConnection, realmMBean);
                                }
                                this.activate(mBeanServerConnection);
                                break block18;
                            }
                            catch (Exception exception) {
                                this.rollback(mBeanServerConnection);
                                throw exception;
                            }
                        }
                        catch (Exception exception) {
                            throw new BuildException("Could not delete bean", (Throwable)exception);
                        }
                    }
                    RemoteMBeanServer remoteMBeanServer = mBeanHome.getMBeanServer();
                    remoteMBeanServer.unregisterMBean(this.getObjectName(object));
                }
            }
            this.log("Deleted MBEAN: " + mBeanDeleteCommand.getMBean(), 3);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
        }
        catch (BuildException buildException) {
            this.handleException(buildException);
        }
    }

    private void invokeQueryCommand(MBeanHome mBeanHome, MBeanQueryCommand mBeanQueryCommand) throws BuildException {
        ObjectName objectName = null;
        this.log("QUERY -pattern " + mBeanQueryCommand.getPattern(), 3);
        try {
            objectName = new ObjectName(mBeanQueryCommand.getPattern());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.handleException("Error in query pattern", malformedObjectNameException);
            return;
        }
        Set<ObjectName> set = mBeanHome.getMBeanServer().queryNames(objectName, null);
        this.log("Set size is " + set.size(), 3);
        StringBuffer stringBuffer = new StringBuffer();
        this.processNestedCommands(mBeanHome, set, mBeanQueryCommand, stringBuffer);
        if (mBeanQueryCommand.getProperty() != null && !stringBuffer.toString().equals("")) {
            this.getProject().setProperty(mBeanQueryCommand.getProperty(), stringBuffer.toString());
        }
    }

    private void processNestedCommands(MBeanHome mBeanHome, Set set, MBeanQueryCommand mBeanQueryCommand, StringBuffer stringBuffer) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MBeanInvokeCommand mBeanInvokeCommand;
            MBeanDeleteCommand mBeanDeleteCommand;
            Object object;
            Object object2;
            Object e = iterator.next();
            stringBuffer.append(e.toString());
            if (iterator.hasNext()) {
                stringBuffer.append(";");
            }
            Iterator iterator2 = mBeanQueryCommand.getGetCommands();
            while (iterator2.hasNext()) {
                object2 = (MBeanGetCommand)iterator2.next();
                ((MBeanGetCommand)object2).setMBean(e.toString());
                this.invokeGetCommand(mBeanHome, (MBeanGetCommand)object2);
            }
            object2 = mBeanQueryCommand.getSetCommands();
            while (object2.hasNext()) {
                object = (MBeanSetCommand)object2.next();
                ((MBeanSetCommand)object).setMBean(e.toString());
                this.invokeSetCommand(mBeanHome, (MBeanSetCommand)object);
            }
            object = mBeanQueryCommand.getCreateCommands();
            Object object3 = this.getMBean(mBeanHome, e.toString());
            if (object3 instanceof WebLogicMBean) {
                this.executeCommands(mBeanHome, (Iterator)object, (WebLogicMBean)object3);
            }
            if ((mBeanDeleteCommand = mBeanQueryCommand.getDeleteCommand()) != null) {
                mBeanDeleteCommand.setMBean(e.toString());
                this.invokeDeleteCommand(mBeanHome, mBeanDeleteCommand);
            }
            if ((mBeanInvokeCommand = mBeanQueryCommand.getInvokeCommand()) == null) continue;
            mBeanInvokeCommand.setMBean(e.toString());
            this.invokeInvokeCommand(mBeanHome, mBeanInvokeCommand);
        }
    }

    private String[] getConnectParams() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-url";
        stringArray[n++] = this.adminurl;
        if (this.username != null) {
            stringArray[n++] = "-username";
            stringArray[n++] = this.username;
            stringArray[n++] = "-password";
            stringArray[n++] = this.password;
        } else {
            if (this.userConfigFile != null) {
                stringArray[n++] = "-userconfigfile";
                stringArray[n++] = this.userConfigFile;
            }
            if (this.userKeyFile != null) {
                stringArray[n++] = "-userkeyfile";
                stringArray[n++] = this.userKeyFile;
            }
        }
        return stringArray;
    }

    private void invokeCommand(String[] stringArray) throws BuildException {
        this.printCommand(stringArray);
        try {
            new MBeanCommandLineInvoker(stringArray, System.out);
        }
        catch (Exception exception) {
            this.handleException("Error invoking MBean command", exception);
            return;
        }
    }

    private void printCommand(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 6; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        this.log(stringBuffer.toString(), 3);
    }

    private InitialContext getInitialContext() throws NamingException, BuildException {
        if (this.adminurl == null || this.adminurl.trim().length() == 0) {
            throw new BuildException("No URL specified. Please specify valid URL");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("java.naming.provider.url", this.adminurl);
        if (this.username == null && this.password == null) {
            UsernameAndPassword usernameAndPassword = null;
            usernameAndPassword = this.userConfigFile != null || this.userKeyFile != null ? UserConfigFileManager.getUsernameAndPassword(this.userConfigFile, this.userKeyFile, "weblogic.management") : UserConfigFileManager.getUsernameAndPassword("weblogic.management");
            if (usernameAndPassword != null) {
                this.username = usernameAndPassword.getUsername();
                this.password = new String(usernameAndPassword.getPassword());
            }
        }
        if (this.username != null) {
            hashtable.put("java.naming.security.principal", this.username);
        }
        if (this.password != null) {
            hashtable.put("java.naming.security.credentials", this.password);
        }
        return new InitialContext(hashtable);
    }

    private MBeanServerConnection getMBeanServerConnection(String string) throws NamingException, BuildException {
        if (this.adminurl == null || this.adminurl.trim().length() == 0) {
            throw new BuildException("No URL specified. Please specify valid URL");
        }
        String[] stringArray = StringUtils.splitCompletely((String)this.adminurl, (String)":");
        if (stringArray.length != 3) {
            throw new BuildException("Invalid URL specified: " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3.startsWith("//")) {
            string3 = string3.substring(2);
        }
        int n = 7001;
        try {
            n = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            throw new BuildException("Invalid port  specified: " + string4);
        }
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string2, string3, n, JNDI + string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.principal", this.username);
            hashtable.put("java.naming.security.credentials", this.password);
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            JMXConnector jMXConnector = null;
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
            MBeanServerConnection mBeanServerConnection = null;
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            return mBeanServerConnection;
        }
        catch (IOException iOException) {
            this.handleException("Failed to connect", iOException);
            return null;
        }
    }

    private String getDomainName(MBeanHome mBeanHome) {
        ServerRuntimeMBean serverRuntimeMBean = null;
        if (this.domainName == null) {
            this.domainName = "mydomain";
            Set set = mBeanHome.getMBeansByType("ServerRuntime");
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
                this.domainName = serverRuntimeMBean.getObjectName().getDomain();
            }
        }
        return this.domainName;
    }

    private Object getMBean(MBeanHome mBeanHome, String string) throws BuildException {
        if (string == null) {
            throw new BuildException("MBean not specified in get command");
        }
        String string2 = string;
        if (this.isProperty(string) && (string2 = this.getRequiredProperty(string)).indexOf(";") != -1) {
            throw new BuildException("Malformed Object Name: " + string2);
        }
        try {
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string2);
            return mBeanHome.getProxy((ObjectName)webLogicObjectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new BuildException("Malformed Object Name: " + string, (Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return this.getCommoMBean(mBeanHome, string2);
        }
    }

    private ObjectInstance getCommoMBean(MBeanHome mBeanHome, String string) throws BuildException {
        try {
            Set<ObjectInstance> set;
            Iterator<ObjectInstance> iterator;
            ObjectName objectName = new ObjectName(string);
            RemoteMBeanServer remoteMBeanServer = mBeanHome.getMBeanServer();
            if (remoteMBeanServer.isRegistered(objectName) && remoteMBeanServer.isInstanceOf(objectName, "weblogic.management.jmx.modelmbean.WLSModelMBean") && (iterator = (set = remoteMBeanServer.queryMBeans(objectName, null)).iterator()).hasNext()) {
                return iterator.next();
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new BuildException("Malformed Object Name: " + string, (Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new BuildException("No Such Object: " + string, (Throwable)instanceNotFoundException);
        }
        throw new BuildException("Could not find provider: " + string);
    }

    private boolean isProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("${");
    }

    private String getProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.substring(2, string.length() - 1);
        return this.getProject().getProperty(string2);
    }

    private String getRequiredProperty(String string) throws BuildException {
        if (string.indexOf(";") != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(this.getSingularRequiredProperty(stringTokenizer.nextToken()));
                if (++n2 == n) continue;
                stringBuffer.append(";");
            }
            return stringBuffer.toString();
        }
        return this.getSingularRequiredProperty(string);
    }

    private String getSingularRequiredProperty(String string) throws BuildException {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        throw new BuildException("Property not set: " + string);
    }

    private void handleException(String string) {
        this.handleException(string, null);
    }

    private void handleException(Throwable throwable) {
        this.handleException(throwable.toString(), null);
    }

    private void handleException(String string, Throwable throwable) {
        String string2;
        String string3 = string2 = throwable == null ? string : string + ": " + throwable;
        if (this.failOnError) {
            throw new BuildException(string2, throwable);
        }
        this.log(string2, 0);
    }

    private ObjectName getDomain(MBeanServerConnection mBeanServerConnection) throws BuildException {
        try {
            ObjectName objectName = new ObjectName("com.bea:Type=Domain,*");
            return this.getSingletonObject(mBeanServerConnection, objectName);
        }
        catch (Exception exception) {
            this.handleException("Error getting Domain", exception);
            return null;
        }
    }

    private ObjectName createSecurityBean(MBeanServerConnection mBeanServerConnection, String string, String string2, String string3) {
        if ("weblogic.management.security.Realm".equals(string2)) {
            ObjectName objectName = this.createRealm(mBeanServerConnection, string);
            return objectName;
        }
        return this.createProvider(mBeanServerConnection, string, string2, string3);
    }

    private ObjectName createProvider(MBeanServerConnection mBeanServerConnection, String string, String string2, String string3) {
        ObjectName objectName = this.getRealm(mBeanServerConnection, string3);
        for (int i = 0; i < baseProviderTypes.length; ++i) {
            String[] stringArray;
            try {
                stringArray = (String[])mBeanServerConnection.getAttribute(objectName, baseProviderTypes[i][0]);
            }
            catch (Exception exception) {
                throw new BuildException("Error determining provider types.", (Throwable)exception);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string2)) continue;
                String string4 = baseProviderTypes[i][1];
                Object[] objectArray = new Object[]{string, string2};
                String[] stringArray2 = new String[]{"java.lang.String", "java.lang.String"};
                try {
                    return (ObjectName)mBeanServerConnection.invoke(objectName, string4, objectArray, stringArray2);
                }
                catch (Throwable throwable) {
                    throw new BuildException("Error creating MBean " + string, throwable);
                }
            }
        }
        throw new BuildException("Could not create provider " + string2);
    }

    private ObjectName createRealm(MBeanServerConnection mBeanServerConnection, String string) {
        try {
            ObjectName objectName = this.getDomain(mBeanServerConnection);
            objectName = (ObjectName)mBeanServerConnection.getAttribute(objectName, "SecurityConfiguration");
            Object[] objectArray = new Object[]{string};
            String[] stringArray = new String[]{"java.lang.String"};
            return (ObjectName)mBeanServerConnection.invoke(objectName, "createRealm", objectArray, stringArray);
        }
        catch (Throwable throwable) {
            throw new BuildException("Error creating Realm " + string, throwable);
        }
    }

    private void destroySecurityBean(MBeanServerConnection mBeanServerConnection, ProviderMBean providerMBean) {
        ObjectName objectName = this.getRealm(mBeanServerConnection, providerMBean.getRealm().getName());
        String string = this.getProviderMethod(providerMBean, "lookup");
        String string2 = this.getProviderMethod(providerMBean, "destroy");
        try {
            Object[] objectArray = new Object[]{providerMBean.getName()};
            String[] stringArray = new String[]{"java.lang.String"};
            ObjectName objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, string, objectArray, stringArray);
            if (objectName2 == null) {
                throw new BuildException("Could not find " + providerMBean.getName());
            }
            objectArray = new Object[]{objectName2};
            stringArray = new String[]{"javax.management.ObjectName"};
            mBeanServerConnection.invoke(objectName, string2, objectArray, stringArray);
        }
        catch (Exception exception) {
            throw new BuildException("Error deleting MBean " + providerMBean.getName(), (Throwable)exception);
        }
    }

    private void destroyRealmBean(MBeanServerConnection mBeanServerConnection, RealmMBean realmMBean) {
        ObjectName objectName = this.getDomain(mBeanServerConnection);
        try {
            objectName = (ObjectName)mBeanServerConnection.getAttribute(objectName, "SecurityConfiguration");
            Object[] objectArray = new Object[]{realmMBean.getName()};
            String[] stringArray = new String[]{"java.lang.String"};
            ObjectName objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, "lookupRealm", objectArray, stringArray);
            if (objectName2 == null) {
                throw new BuildException("Could not find " + realmMBean.getName());
            }
            objectArray = new Object[]{objectName2};
            stringArray = new String[]{"javax.management.ObjectName"};
            mBeanServerConnection.invoke(objectName, "destroyRealm", objectArray, stringArray);
        }
        catch (Exception exception) {
            throw new BuildException("Error deleting MBean " + realmMBean.getName(), (Throwable)exception);
        }
    }

    private ObjectName getRealm(MBeanServerConnection mBeanServerConnection, String string) throws BuildException {
        try {
            ObjectName objectName = this.getDomain(mBeanServerConnection);
            objectName = (ObjectName)mBeanServerConnection.getAttribute(objectName, "SecurityConfiguration");
            if (string == null) {
                objectName = (ObjectName)mBeanServerConnection.getAttribute(objectName, "DefaultRealm");
            } else {
                Object[] objectArray = new Object[]{string};
                String[] stringArray = new String[]{"java.lang.String"};
                if ((objectName = (ObjectName)mBeanServerConnection.invoke(objectName, "lookupRealm", objectArray, stringArray)) == null) {
                    throw new BuildException("No such Realm: " + string);
                }
            }
            return objectName;
        }
        catch (Exception exception) {
            throw new BuildException("Error getting Realm", (Throwable)exception);
        }
    }

    protected ObjectName getSingletonObject(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws BuildException {
        ObjectName objectName2 = null;
        try {
            Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            if (iterator.hasNext()) {
                objectName2 = iterator.next();
            }
            return objectName2;
        }
        catch (Exception exception) {
            this.handleException("Error getting object", exception);
            return null;
        }
    }

    private void startEdit(MBeanServerConnection mBeanServerConnection) throws BuildException {
        try {
            this.getConfigurationManagerMBean(mBeanServerConnection).startEdit(0, 3600000);
        }
        catch (Exception exception) {
            throw new BuildException("Failed to start edit: " + exception, (Throwable)exception);
        }
    }

    private void activate(MBeanServerConnection mBeanServerConnection) throws BuildException {
        try {
            this.getConfigurationManagerMBean(mBeanServerConnection).save();
            this.getConfigurationManagerMBean(mBeanServerConnection).activate(-1L);
        }
        catch (Exception exception) {
            throw new BuildException("Failed to start edit: " + exception, (Throwable)exception);
        }
    }

    private void rollback(MBeanServerConnection mBeanServerConnection) throws BuildException {
        try {
            this.getConfigurationManagerMBean(mBeanServerConnection).undo();
            this.getConfigurationManagerMBean(mBeanServerConnection).stopEdit();
        }
        catch (Exception exception) {
            throw new BuildException("Failed to start edit: " + exception, (Throwable)exception);
        }
    }

    private ConfigurationManagerMBean getConfigurationManagerMBean(MBeanServerConnection mBeanServerConnection) throws BuildException {
        return this.getEditServiceMBean(mBeanServerConnection).getConfigurationManager();
    }

    private EditServiceMBean getEditServiceMBean(MBeanServerConnection mBeanServerConnection) throws BuildException {
        ObjectName objectName = this.getEditService(mBeanServerConnection);
        return (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName);
    }

    private ObjectName getEditService(MBeanServerConnection mBeanServerConnection) throws BuildException {
        try {
            ObjectName objectName = new ObjectName(EDIT_SERVICE);
            return this.getSingletonObject(mBeanServerConnection, objectName);
        }
        catch (Exception exception) {
            this.handleException("Error getting EditService: ", exception);
            return null;
        }
    }

    private String getProviderMethod(ProviderMBean providerMBean, String string) {
        if (providerMBean instanceof AuthenticationProviderMBean) {
            return string + "AuthenticationProvider";
        }
        if (providerMBean instanceof AdjudicatorMBean) {
            if ("lookup".equals(string)) {
                string = "get";
            }
            return string + "Adjudicator";
        }
        if (providerMBean instanceof AuthorizerMBean) {
            return string + "Authorizer";
        }
        if (providerMBean instanceof RoleMapperMBean) {
            return string + "RoleMapper";
        }
        if (providerMBean instanceof CredentialMapperMBean) {
            return string + "CredentialMapper";
        }
        if (providerMBean instanceof CertPathProviderMBean) {
            return string + "CertPathProvider";
        }
        if (providerMBean instanceof KeyStoreMBean) {
            return string + "KeyStore";
        }
        throw new BuildException("Unknown provider type: " + providerMBean);
    }

    private Object convertObject(String string, String string2) throws BuildException {
        boolean bl;
        StringTokenizer stringTokenizer = null;
        String string3 = null;
        Object[] objectArray = null;
        Object object = null;
        if (string2.startsWith("[L") && string2.endsWith(";")) {
            bl = true;
            string3 = string2.substring("[L".length(), string2.lastIndexOf(";"));
            stringTokenizer = new StringTokenizer(string, ";");
            if (string3.startsWith("weblogic.management") && string3.endsWith("MBean")) {
                objectArray = new WebLogicObjectName[stringTokenizer.countTokens()];
            } else {
                try {
                    Class<?> clazz = Class.forName(string3);
                    objectArray = (Object[])Array.newInstance(clazz, stringTokenizer.countTokens());
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new BuildException((Throwable)classNotFoundException);
                }
            }
        } else {
            bl = false;
            string3 = string2;
            stringTokenizer = new StringTokenizer(string, "");
        }
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = this.getSingleObjectFromString(string3, (String)stringTokenizer.nextElement());
            if (bl) {
                objectArray[n++] = object;
                continue;
            }
            return object;
        }
        return objectArray;
    }

    private Object getSingleObjectFromString(String string, String string2) throws IllegalArgumentException {
        if (string.equals("int")) {
            Integer n = new Integer(string2);
            return n;
        }
        if (string.equals("java.util.Properties") || string.equals("java.util.Map")) {
            Properties properties = new Properties();
            TypeConversionUtils.stringToDictionary((String)string2, (Dictionary)properties, (String)";");
            return properties;
        }
        if (string.equals("boolean")) {
            Boolean bl = new Boolean(string2);
            return bl;
        }
        if (string.equals("long")) {
            Long l = new Long(string2);
            return l;
        }
        if (string.startsWith("weblogic.management") && string.endsWith("MBean")) {
            try {
                WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string2);
                return webLogicObjectName;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(malformedObjectNameException.toString());
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new String[]{string2};
            Object obj = constructor.newInstance(objectArray);
            return obj;
        }
        catch (Exception exception) {
            throw new BuildException("Unable to convert the argument value " + string2 + " to class " + string + ". " + exception);
        }
    }
}

