/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.management;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import weblogic.Home;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;

public class WLServer
extends Java
implements Runnable,
BuildListener {
    private static final String DEFAULT_POLICY_FILE = "weblogic.policy";
    private static final String WEBLOGIC_MAIN_CLASS = "weblogic.Server";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PROTOCOL = "t3";
    private static final int DEFAULT_PORT = 7001;
    private static final String LICENSE_FILE = "license.bea";
    private File beaHome;
    private File weblogicHome;
    private File configDir;
    private File outFile = null;
    private String configFile;
    private String serverName = "myserver";
    private String domainName;
    private boolean useBootProperties = false;
    private String managementUserName;
    private String managementPassword;
    private String pkPassword;
    private File securityPolicyFile;
    private String serverHost = "localhost";
    private String serverProtocol = "t3";
    private int serverPort = 7001;
    private boolean generateConfig = false;
    private boolean forceImplicitUpgrade = false;
    private String adminServerURL = null;
    private String action = "start";
    private long timeout = 0L;
    private double timeoutSecs = 0.0;
    private boolean productionModeEnabled = false;
    private boolean verbose = false;
    private boolean failOnError = false;
    private boolean execFailed = false;
    private boolean forceShutdown = false;
    private InitialContext ctx;
    private MBeanServerConnection connection;
    private ObjectName serverRuntimeObjectName;
    private String errorProperty;
    private boolean noExit = false;

    public void setNoExit(boolean bl) {
        this.noExit = bl;
    }

    public void setErrorProperty(String string) {
        this.errorProperty = string;
    }

    public void setPolicy(File file) {
        this.securityPolicyFile = file;
    }

    public void setDir(File file) {
        this.configDir = file;
        super.setDir(file);
    }

    public void setOutput(File file) {
        this.outFile = file;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setBEAHome(File file) {
        this.beaHome = file;
    }

    public void setWebLogicHome(File file) {
        this.weblogicHome = file;
        if (this.beaHome == null) {
            File file2;
            for (file2 = file; file2 != null && !new File(file2, LICENSE_FILE).exists(); file2 = file2.getParentFile()) {
            }
            if (file2 != null) {
                this.beaHome = file2;
            }
        }
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setAdminServerURL(String string) {
        this.adminServerURL = string;
    }

    public void setUseBootProperties(boolean bl) {
        this.useBootProperties = bl;
    }

    public void setUserName(String string) {
        this.managementUserName = string;
    }

    public void setPassword(String string) {
        this.managementPassword = string;
    }

    public void setPKPassword(String string) {
        this.pkPassword = string;
    }

    public void setTimeout(Long l) {
        this.timeout = l;
        this.timeoutSecs = l.doubleValue();
        this.timeoutSecs /= 1000.0;
    }

    public void setTimeoutSeconds(Long l) {
        this.timeout = l * 1000L;
        this.timeoutSecs = l.doubleValue();
    }

    public void setProductionModeEnabled(boolean bl) {
        this.productionModeEnabled = bl;
    }

    public void setHost(String string) {
        this.serverHost = string;
    }

    public void setProtocol(String string) {
        this.serverProtocol = string;
    }

    public void setPort(int n) throws BuildException {
        this.serverPort = n;
    }

    public void setGenerateConfig(boolean bl) {
        this.generateConfig = bl;
    }

    public void setForceImplicitUpgrade(boolean bl) {
        this.forceImplicitUpgrade = bl;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        super.setFailonerror(bl);
    }

    public void setForceShutdown(boolean bl) {
        this.forceShutdown = bl;
    }

    public void execute() throws BuildException {
        Object object;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        if (!(this.action.equals("reboot") || this.action.equals("shutdown") || this.action.equals("connect") || this.action.equals("start"))) {
            object = "Invalid action specified: " + this.action;
            if (this.failOnError) {
                throw new BuildException((String)object);
            }
            this.log((String)object, 0);
        }
        if ((this.action.equals("reboot") || this.action.equals("shutdown")) && this.getInitialContext(1L) != null) {
            this.killServer();
        }
        if (this.action.equals("connect")) {
            if (this.getInitialContext(1L) != null) {
                return;
            }
            object = "Unable to connect to " + this.serverProtocol + "://" + this.serverHost + ":" + this.serverPort;
            if (this.failOnError) {
                throw new BuildException((String)object);
            }
            if (this.errorProperty != null) {
                this.getProject().setProperty(this.errorProperty, (String)object);
            }
        }
        if (this.action.equals("start") || this.action.equals("reboot")) {
            Object object2;
            if (this.noExit) {
                this.setSpawn(true);
            }
            if (this.weblogicHome == null) {
                this.setWebLogicHome(Home.getFile());
            }
            if (this.weblogicHome == null) {
                throw new BuildException("weblogichome not set");
            }
            if (this.beaHome != null && !this.beaHome.isDirectory()) {
                throw new BuildException("BEA home " + this.beaHome.getPath() + " not valid");
            }
            if (!this.generateConfig && this.adminServerURL == null) {
                object = this.configFile == null ? "config.xml" : this.configFile;
                object2 = new File(this.configDir, (String)object);
                if (!((File)object2).exists() && !((File)(object2 = new File(this.configDir, "config/" + (String)object))).exists()) {
                    throw new BuildException("Server config file not found.");
                }
            }
            if (this.securityPolicyFile == null) {
                this.securityPolicyFile = this.getSecurityPolicyFile();
            }
            object = new Thread((Runnable)this, "Execute-WLS");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            if (this.getInitialContext(this.timeout) != null) {
                this.getProject().addBuildListener((BuildListener)this);
                object2 = new ArrayList();
                object2.add("RUNNING");
                if (!this.waitForServerState((List)object2, this.timeout)) {
                    String string;
                    String string2 = string = this.execFailed ? "Error in server execution (" + this.serverName + ")" : "Server " + this.serverName + " not did not reach RUNNING state after " + this.timeoutSecs + " seconds";
                    if (this.failOnError) {
                        throw new BuildException(string);
                    }
                    this.log(string, 0);
                }
            } else {
                Object object3 = object2 = this.execFailed ? "Error in server execution (" + this.serverName + ")" : "Server " + this.serverName + " not listening after " + this.timeoutSecs + " seconds";
                if (this.failOnError) {
                    throw new BuildException((String)object2);
                }
                this.log((String)object2, 0);
            }
        }
    }

    private InitialContext getInitialContext(long l) {
        if (this.ctx != null) {
            return this.ctx;
        }
        String string = this.serverProtocol + "://" + this.serverHost + ":" + this.serverPort;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("java.naming.provider.url", string);
        if (this.managementUserName != null) {
            hashtable.put("java.naming.security.principal", this.managementUserName);
        }
        if (this.managementPassword != null) {
            hashtable.put("java.naming.security.credentials", this.managementPassword);
        }
        long l2 = System.currentTimeMillis() + l;
        while (true) {
            try {
                this.ctx = new InitialContext(hashtable);
                return this.ctx;
            }
            catch (Exception exception) {
                if (!(exception instanceof CommunicationException)) {
                    System.out.println("Unexpected Exception, retrying in 2 seconds");
                    exception.printStackTrace();
                }
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((l == 0L || l2 > System.currentTimeMillis()) && !this.execFailed) continue;
                return null;
            }
            break;
        }
    }

    private void executeServer() {
        if (this.serverName != null) {
            String string = this.getClass().getName();
            String string2 = this.getClass().getPackage().getName();
            string = string.substring(string2.length() + 1, string.length());
            this.setTaskName(string + " " + this.serverName);
        }
        this.setFork(true);
        this.setClassname(WEBLOGIC_MAIN_CLASS);
        this.setProperty("weblogic.Domain", this.domainName);
        if (this.configFile != null) {
            this.setProperty("weblogic.ConfigFile", this.configFile);
        }
        this.setProperty("weblogic.Name", this.serverName);
        if (this.beaHome != null) {
            this.setProperty("bea.home", this.beaHome);
        }
        this.setProperty("java.security.policy=", this.securityPolicyFile);
        if (!this.useBootProperties) {
            this.setProperty("weblogic.management.username", this.managementUserName);
            this.setProperty("weblogic.management.password", this.managementPassword);
        }
        this.setProperty("weblogic.pkpassword", this.pkPassword);
        if (this.generateConfig) {
            this.setProperty("weblogic.management.GenerateDefaultConfig", Boolean.toString(this.generateConfig));
        }
        this.setProperty("weblogic.management.server", this.adminServerURL);
        if (this.productionModeEnabled) {
            this.setProperty("weblogic.ProductionModeEnabled", Boolean.toString(this.productionModeEnabled));
        }
        if (this.forceImplicitUpgrade) {
            this.setProperty("weblogic.ForceImplicitUpgradeIfNeeded", Boolean.toString(this.forceImplicitUpgrade));
        }
        if (this.serverHost != DEFAULT_HOST) {
            this.setProperty("weblogic.ListenAddress", this.serverHost);
        }
        if (this.serverPort != 7001) {
            this.setProperty("weblogic.ListenPort", this.serverPort + "");
        }
        if (this.outFile != null) {
            if (this.noExit) {
                this.getProject().log("Ignoring output redirection as it is incompatibile with noExit");
            } else {
                super.setOutput(this.outFile);
            }
        }
        if (this.executeJava() != 0) {
            this.execFailed = true;
        }
    }

    private void setProperty(String string, Object object) {
        if (object != null) {
            this.createJvmarg().setValue("-D" + string + "=" + object.toString());
        }
    }

    private void setProperty(String string, boolean bl) {
        if (bl) {
            this.createJvmarg().setValue("-D" + string);
        }
    }

    private File getSecurityPolicyFile() {
        File file = new File(this.weblogicHome, "lib/weblogic.policy");
        if (!file.exists() && this.configDir != null) {
            file = new File(this.configDir, DEFAULT_POLICY_FILE);
        }
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private void killServer() {
        if (this.getServerRuntimeName() != null) {
            block8: {
                try {
                    if (this.forceShutdown) {
                        this.connection.invoke(this.serverRuntimeObjectName, "forceShutdown", null, null);
                    } else {
                        this.connection.invoke(this.serverRuntimeObjectName, "shutdown", null, null);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("SHUTDOWN");
                    arrayList.add("UNKNOWN");
                    if (!this.waitForServerState(arrayList, this.timeout)) {
                        String string;
                        String string2 = string = this.execFailed ? "Error in server execution (" + this.serverName + ")" : "Server " + this.serverName + " not complete force shutdown after " + this.timeoutSecs + " seconds.";
                        if (this.failOnError) {
                            throw new BuildException(string);
                        }
                        this.log(string, 0);
                    }
                }
                catch (SecurityException securityException) {
                    throw new BuildException((Throwable)securityException);
                }
                catch (Exception exception) {
                    if (exception instanceof CommunicationException || exception instanceof ConnectException || exception instanceof RemoteRuntimeException || exception instanceof PeerGoneException || exception instanceof SocketException) break block8;
                    exception.printStackTrace();
                }
            }
            this.ctx = null;
        }
    }

    MBeanServerConnection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.getInitialContext(1L) == null) {
            return null;
        }
        try {
            this.connection = (MBeanServerConnection)this.ctx.lookup("weblogic.management.server");
        }
        catch (NamingException namingException) {
            return null;
        }
        return this.connection;
    }

    ObjectName getServerRuntimeName() {
        if (this.serverRuntimeObjectName != null) {
            return this.serverRuntimeObjectName;
        }
        if (this.getConnection() == null) {
            return null;
        }
        try {
            ObjectName objectName = new ObjectName("*:Type=ServerRuntime,Name=" + this.serverName + ",*");
            if (this.verbose) {
                System.err.println("querying ");
            }
            Set<ObjectName> set = this.connection.queryNames(objectName, null);
            if (this.verbose) {
                System.err.println("got a response of " + set.size());
            }
            if (set.size() != 1) {
                return null;
            }
            this.serverRuntimeObjectName = set.iterator().next();
            if (this.verbose) {
                System.err.println("got a response of " + this.serverRuntimeObjectName);
            }
        }
        catch (IOException iOException) {
            this.connection = null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new BuildException((Throwable)malformedObjectNameException);
        }
        return this.serverRuntimeObjectName;
    }

    private String getServerState() {
        if (this.getServerRuntimeName() == null) {
            return "unknown";
        }
        if (this.getConnection() == null) {
            return "unknown";
        }
        try {
            return (String)this.connection.getAttribute(this.serverRuntimeObjectName, "State");
        }
        catch (MBeanException mBeanException) {
            throw new BuildException((Throwable)mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new BuildException((Throwable)attributeNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new BuildException((Throwable)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new BuildException((Throwable)reflectionException);
        }
        catch (IOException iOException) {
            return "unknown";
        }
    }

    private boolean waitForServerState(List list, long l) {
        if (this.verbose) {
            System.err.println("waiting for " + this.serverName + "to transition to " + list + ", within " + l + " ms");
        }
        try {
            long l2 = 0L;
            String string = "<not-initialized>";
            String string2 = "";
            if (this.verbose) {
                System.err.println("querying " + this.serverName + " for state every 500ms, timeout " + l + " ms");
            }
            while (!(l2 >= l && l != 0L || list.contains(string2 = this.getServerState()))) {
                try {
                    Thread.sleep(500L);
                    l2 += 500L;
                    if (string.equals(string2)) continue;
                    if (this.verbose) {
                        System.err.println("update: " + this.serverName + " state transition from " + string + " to " + string2 + ", after " + l2 + " ms");
                    }
                    string = string2;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (l > 0L && l2 > l) {
                if (this.verbose) {
                    System.err.println("timeout: " + this.serverName + " failed to transition to state " + list + ", after " + l2 + " ms");
                }
                return false;
            }
            if (this.verbose) {
                System.err.println("ok: " + this.serverName + " transitioned to state " + list + ", after " + l2 + " ms");
            }
            return true;
        }
        catch (Exception exception) {
            if (!(exception instanceof CommunicationException || exception instanceof ConnectException || exception instanceof RemoteRuntimeException || exception instanceof SocketException || exception instanceof PeerGoneException)) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
    }

    public void run() {
        this.executeServer();
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (this.noExit) {
            this.log("Server will not be killed due to noExit flag" + this.serverName);
            return;
        }
        try {
            this.log("Killing WLS Server Instance " + this.serverName);
            this.killServer();
        }
        catch (Exception exception) {
            this.log("Exception occurred while shutting down the server.");
            exception.printStackTrace();
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }
}

