/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.path;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class PathModTask
extends Task {
    private String m_oldPathPrefix;
    private String m_newPathPrefix;
    private String m_propertyName;
    private String m_inputPath;

    public void setOldPathPrefix(String string) {
        this.m_oldPathPrefix = string;
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            this.m_oldPathPrefix = this.m_oldPathPrefix.replace('/', File.separatorChar);
        }
    }

    public void setNewPathPrefix(String string) {
        this.m_newPathPrefix = string;
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            this.m_newPathPrefix = this.m_newPathPrefix.replace('/', File.separatorChar);
        }
    }

    public void setPropertyName(String string) {
        this.m_propertyName = string;
    }

    public void setInputPath(String string) {
        this.m_inputPath = string;
    }

    public void execute() throws BuildException {
        Project project = this.getProject();
        String string = "";
        System.out.println("input source path - " + this.m_inputPath);
        boolean bl = this.m_inputPath.regionMatches(true, 0, this.m_oldPathPrefix, 0, this.m_oldPathPrefix.length());
        if (!bl) {
            throw new BuildException("Unable to match old path prefix: " + this.m_oldPathPrefix + " to input path: " + this.m_inputPath);
        }
        String string2 = this.m_inputPath.substring(this.m_oldPathPrefix.length());
        string = this.m_newPathPrefix + string2;
        string = string.replace(File.separatorChar, '/');
        project.setUserProperty(this.m_propertyName, string);
        System.out.println("output build path - " + string);
    }
}

