/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.pointbase;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;

public class PointBase
extends Java
implements Runnable {
    private static final String POINTBASE_MAIN_CLASS = "com.pointbase.net.netServer";
    private static final int DEFAULT_PORT = 9092;
    private boolean win = false;
    private int displayLevel = -1;
    private String database = null;
    private int port = 9092;
    private File logFile = null;
    private File pointbaseini = null;
    private boolean noconsole = true;
    private long timeout = 0L;
    private String home = null;
    private boolean execFailed = false;

    public void setWin(boolean bl) {
        this.win = bl;
    }

    public void setDisplayLevel(int n) {
        this.displayLevel = n;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setFile(File file) {
        this.logFile = file;
    }

    public void setPointBaseIni(File file) {
        this.pointbaseini = file;
    }

    public void setNoConsole(boolean bl) {
        this.noconsole = bl;
    }

    public void setTimeout(long l) {
        this.timeout = l * 1000L;
    }

    public void setHome(String string) {
        this.home = string;
    }

    public void execute() throws BuildException {
        new Thread((Runnable)this, "Execute-PointBase").start();
    }

    private void executePointBase() {
        this.setFork(true);
        this.setClassname(POINTBASE_MAIN_CLASS);
        this.setProperty("database.home", this.home);
        if (this.win) {
            this.createArg().setValue("/win");
        }
        if (this.displayLevel >= 0) {
            this.createArg().setValue("/d:" + this.displayLevel);
        }
        if (this.database != null) {
            this.createArg().setValue("/database:" + this.database);
        }
        this.createArg().setValue("/port:" + this.port);
        if (this.logFile != null) {
            this.createArg().setValue("/file=" + this.logFile.toString());
        }
        if (this.pointbaseini != null) {
            this.createArg().setValue("/pointbase.ini=" + this.pointbaseini.toString());
        }
        if (this.noconsole) {
            this.createArg().setValue("/noconsole");
        }
        if (this.executeJava() != 0) {
            this.execFailed = true;
        }
    }

    private void setProperty(String string, Object object) {
        if (object != null) {
            this.createJvmarg().setValue("-D" + string + "=" + object.toString());
        }
    }

    private void setProperty(String string, boolean bl) {
        if (bl) {
            this.createJvmarg().setValue("-D" + string);
        }
    }

    public void run() {
        this.executePointBase();
    }
}

