/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import weblogic.ant.taskdefs.utils.LibraryElement;
import weblogic.application.library.LibraryInitializer;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;

public final class AntLibraryUtils {
    private AntLibraryUtils() {
    }

    public static void validateLibraries(File file, Collection collection) {
        ArrayList<File> arrayList = null;
        if (file != null) {
            arrayList = new ArrayList<File>(1);
            arrayList.add(file);
        }
        AntLibraryUtils.validateLibraries(arrayList, collection);
    }

    public static void validateLibraries(Collection collection, Collection collection2) {
        if (collection != null) {
            for (Object object : collection) {
                if (!((File)object).exists()) {
                    throw new BuildException("librarydir: " + ((File)object).getAbsolutePath() + " does not exist or cannot be read.");
                }
                if (((File)object).isDirectory()) continue;
                throw new BuildException("librarydir: " + ((File)object).getAbsolutePath() + " is not a directory.");
            }
        }
        for (Object object : collection2) {
            if (((LibraryElement)object).getFile() == null) {
                throw new BuildException("Library's file attr must be set.");
            }
            if (((LibraryElement)object).getFile().exists()) continue;
            throw new BuildException("Library " + ((LibraryElement)object).getFile().getAbsolutePath() + " does not exist or cannot be read.");
        }
    }

    public static void registerLibraries(LibraryInitializer libraryInitializer, File[] fileArray, LibraryElement[] libraryElementArray, boolean bl) {
        AntLibraryUtils.registerLibdirs(libraryInitializer, fileArray);
        AntLibraryUtils.registerLibraries(libraryInitializer, libraryElementArray, bl);
    }

    private static void registerLibdirs(LibraryInitializer libraryInitializer, File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                libraryInitializer.registerLibdir(fileArray[i].getAbsolutePath());
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                throw new BuildException(loggableLibraryProcessingException.getLoggable().getMessage());
            }
        }
    }

    private static void registerLibraries(LibraryInitializer libraryInitializer, LibraryElement[] libraryElementArray, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < libraryElementArray.length; ++i) {
            try {
                libraryInitializer.registerLibrary(libraryElementArray[i].getFile(), libraryElementArray[i].getLibraryData());
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                if (!bl) {
                    loggableLibraryProcessingException.getLoggable().log();
                }
                bl2 = false;
            }
        }
        if (!bl2) {
            throw new BuildException(J2EELogger.logAppcLibraryRegistrationFailedLoggable().getMessage());
        }
    }

    public static void logRegistryContent(Project project, int n) {
        project.log(LibraryLoggingUtils.registryToString(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassPath(File[] fileArray, ClassFinder classFinder) {
        String string = "";
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isFile() && !fileArray[i].getName().toLowerCase().endsWith(".jar")) continue;
                multiClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(fileArray[i].getAbsolutePath()));
            }
            multiClassFinder.addFinder(classFinder);
            string = multiClassFinder.getClassPath();
        }
        finally {
            multiClassFinder.close();
        }
        return string;
    }

    public static List getLibraryFlags(File file, Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file != null) {
            arrayList.add("-librarydir");
            arrayList.add(file.getAbsolutePath());
        }
        if (collection.isEmpty()) {
            return arrayList;
        }
        arrayList.add("-library");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LibraryElement libraryElement = (LibraryElement)iterator.next();
            stringBuffer.append(libraryElement.getFile().getAbsolutePath());
            if (libraryElement.getName() != null) {
                stringBuffer.append("@").append("name").append("=").append(libraryElement.getName());
            }
            if (libraryElement.getSpecificationVersion() != null) {
                stringBuffer.append("@").append("libspecver").append("=").append(libraryElement.getSpecificationVersion());
            }
            if (libraryElement.getImplementationVersion() != null) {
                stringBuffer.append("@").append("libimplver").append("=").append(libraryElement.getImplementationVersion());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }
}

