/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.utils;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class FindTask
extends MatchingTask {
    private File targetFile;
    private File sourceDirectory;
    private String propertyName;
    private boolean matchAll = false;

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    public void setSourceDirectory(File file) {
        this.sourceDirectory = file;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setMatchAll(boolean bl) {
        this.matchAll = bl;
    }

    public void execute() throws BuildException {
        Project project = this.getProject();
        try {
            StringBuffer stringBuffer = new StringBuffer(128);
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.sourceDirectory);
            directoryScanner.scan();
            long l = this.targetFile.lastModified();
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this.sourceDirectory, stringArray[i]);
                project.log("Testing " + file.getAbsolutePath(), 3);
                if (!this.matchAll && (file.lastModified() <= l || file.getCanonicalPath().equals(this.targetFile.getCanonicalPath()))) continue;
                project.log("Matched " + file.getAbsolutePath(), 2);
                stringBuffer.append(" " + file.getAbsolutePath());
            }
            this.getProject().setProperty(this.propertyName, stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException("Build generation failure", (Throwable)exception);
        }
    }
}

