/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.utils;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class OpenBrowser
extends Task {
    private String url = "";
    private String unixBrowser = "";
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_DEFAULT_BROWSER = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUnixBrowser(String string) {
        this.unixBrowser = string;
    }

    public void execute() throws BuildException {
        block6: {
            boolean bl = OpenBrowser.isWindowsPlatform();
            String string = null;
            try {
                if (bl) {
                    string = "rundll32 url.dll,FileProtocolHandler " + this.url;
                    Process process = Runtime.getRuntime().exec(string);
                    break block6;
                }
                String string2 = this.unixBrowser != null && !this.unixBrowser.equals("") ? this.unixBrowser : UNIX_DEFAULT_BROWSER;
                string = string2 + " " + UNIX_FLAG + "(" + this.url + ")";
                Process process = Runtime.getRuntime().exec(string);
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        string = string2 + " " + this.url;
                        process = Runtime.getRuntime().exec(string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new BuildException("Error bringing up browser, cmd='" + string + "'.  Please make sure that 'netscape' can open (use unixBrowser attribute to change browser on Unix, ie unixBrowser=\"mozilla\").\n" + interruptedException);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Could not invoke browser, command=" + string + "'.  Windows: Please make sure that default browser can open.  Unix: Please make sure that 'netscape' can open (use unixBrowser attribute to change browser on Unix, ie unixBrowser=\"mozilla\").\n" + iOException);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

