/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.xml.binding;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class XSD2JavaTask
extends Task {
    private List mFileSets = null;
    private String mSchema = "";
    private String mPackage = null;
    private String mDestDir = null;
    private boolean mReadOnly = false;
    private boolean mNoValidation = false;
    private boolean mExtension = false;
    private String mSrc = null;
    private String mBinding = null;
    private static final String XJC_COMPILER = "com.sun.tools.xjc.Driver";
    private static final String SEP = File.separator;
    private static final String DEPOT_ENV = "depot";
    private static final String SRC_ENV = "src";
    private static final String DEV = "dev";
    private static final String[] JAXB_JARS = new String[]{"3rdparty" + SEP + "jaxb" + SEP + "jaxb-api.jar", "3rdparty" + SEP + "jaxb" + SEP + "jaxb-libs.jar", "3rdparty" + SEP + "jaxb" + SEP + "jaxb-ri.jar", "3rdparty" + SEP + "jaxb" + SEP + "jaxb-xjc.jar", "3rdparty" + SEP + "jaxb" + SEP + "sax.jar", "3rdparty" + SEP + "jaxb" + SEP + "xercesImpl.jar"};

    public void setExtension(boolean bl) {
        this.mExtension = bl;
    }

    public void setSchema(String string) {
        this.mSchema = string;
    }

    public void setPackage(String string) {
        this.mPackage = string;
    }

    public void setDestDir(String string) {
        this.mDestDir = string;
    }

    public void setNoValidation(boolean bl) {
        this.mNoValidation = bl;
    }

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }

    public void setBinding(String string) {
        this.mBinding = string;
    }

    public void addFileSet(FileSet fileSet) {
        if (this.mFileSets == null) {
            this.mFileSets = new ArrayList();
        }
        this.mFileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        String string = this.getSrcDir() + SEP;
        Java java = new Java();
        java.setTaskName("xjc");
        java.setProject(this.getProject());
        Path path = java.createClasspath();
        for (int i = 0; i < JAXB_JARS.length; ++i) {
            path.addExisting(new Path(this.getProject(), string + JAXB_JARS[i]));
        }
        path.addExisting(Path.systemClasspath);
        java.setClasspath(path);
        java.setFork(true);
        java.setClassname(XJC_COMPILER);
        if (this.mDestDir != null) {
            java.createArg().setLine("-d " + this.mDestDir);
        }
        if (this.mPackage != null) {
            java.createArg().setLine("-p " + this.mPackage);
        }
        if (this.mBinding != null) {
            java.createArg().setLine("-b " + this.mBinding);
        }
        if (this.mExtension) {
            java.createArg().setLine("-extension");
        }
        if (this.mReadOnly) {
            java.createArg().setLine("-readOnly");
        }
        if (this.mNoValidation) {
            java.createArg().setLine("-nv");
        }
        if (this.mFileSets != null) {
            for (FileSet fileSet : this.mFileSets) {
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(directoryScanner.getBasedir(), stringArray[i]);
                    this.mSchema = this.mSchema + " " + file;
                }
            }
        }
        java.createArg().setLine(this.mSchema);
        this.log("Running xjc on '" + this.mSchema + "'");
        java.execute();
    }

    private final String getSrcDir() {
        if (this.mSrc != null) {
            return this.mSrc;
        }
        Vector vector = Execute.getProcEnvironment();
        if (vector != null) {
            String string = null;
            String string2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.get(i);
                int n = string3.indexOf("=");
                if (n == -1 || n == string3.length() - 1) continue;
                String string4 = string3.substring(0, n).trim();
                if (string4.equalsIgnoreCase(DEPOT_ENV)) {
                    string = string3.substring(n + 1);
                    continue;
                }
                if (!string4.equalsIgnoreCase(SRC_ENV)) continue;
                string2 = string3.substring(n + 1);
            }
            if (string != null && string2 != null) {
                return string + SEP + DEV + SEP + string2;
            }
        }
        this.log("WARNING: could not determine src root, using '.'");
        return ".";
    }
}

