/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import weblogic.application.Deployment;
import weblogic.utils.Debug;
import weblogic.work.ShutdownCallback;

public final class AdminModeCompletionBarrier {
    private static final boolean debug = Debug.getCategory((String)"weblogic.application.AdminModeBarrier").isEnabled();
    private static final int STATE_REGISTERING = 1;
    private static final int STATE_REGISTRATION_COMPLETE = 2;
    private final Deployment.AdminModeCallback callback;
    private int state = 1;
    private int pendingCallbacks = 0;

    public AdminModeCompletionBarrier(Deployment.AdminModeCallback adminModeCallback) {
        this.callback = adminModeCallback;
    }

    private String state2String(int n) {
        switch (n) {
            case 1: {
                return "STATE_REGISTERING";
            }
            case 2: {
                return "STATE_REGISTRATION_COMPLETE";
            }
        }
        throw new AssertionError((Object)("unexpected state " + n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackCompleted() {
        boolean bl;
        AdminModeCompletionBarrier adminModeCompletionBarrier = this;
        synchronized (adminModeCompletionBarrier) {
            --this.pendingCallbacks;
            if (debug) {
                Debug.say((String)("callbackCompleted " + this + ", pendingCallbacks=" + this.pendingCallbacks));
                Debug.stackdump();
            }
            bl = this.pendingCallbacks == 0 && this.state == 2;
        }
        if (bl) {
            this.callback.completed();
        }
    }

    private synchronized void registerCallback() {
        if (this.state != 1) {
            throw new AssertionError((Object)("Unexpected state in registerCallback " + this.state2String(this.state)));
        }
        ++this.pendingCallbacks;
        if (debug) {
            Debug.say((String)("registerCallback " + this + ", pendingCallbacks=" + this.pendingCallbacks));
            Debug.stackdump();
        }
    }

    public ShutdownCallback registerWMShutdown() {
        this.registerCallback();
        return new ShutdownCallback(){

            public void completed() {
                AdminModeCompletionBarrier.this.callbackCompleted();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationComplete() {
        boolean bl;
        AdminModeCompletionBarrier adminModeCompletionBarrier = this;
        synchronized (adminModeCompletionBarrier) {
            if (this.state == 1) {
                this.state = 2;
                boolean bl2 = bl = this.pendingCallbacks == 0;
                if (debug) {
                    Debug.say((String)("registrationComplete " + this + ", pendingCallbacks=" + this.pendingCallbacks));
                }
            } else {
                throw new AssertionError((Object)("Unexpected state in registrationComplete " + this.state2String(this.state)));
            }
        }
        if (bl) {
            this.callback.completed();
        }
    }
}

