/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Deployment;
import weblogic.application.DeploymentManager;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

public final class ApplicationAccess {
    private static final char appVerSeparator = '#';

    private ApplicationAccess() {
    }

    public static ApplicationAccess getApplicationAccess() {
        return ApplicationAccessSingleton.SINGLETON;
    }

    public String getCurrentApplicationName() {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        Annotation annotation = this.getAnnotation(classLoader);
        return annotation != null ? annotation.getApplicationName() : null;
    }

    public String getApplicationName(ClassLoader classLoader) {
        int n;
        Annotation annotation = this.getAnnotation(classLoader);
        String string = null;
        if (annotation != null && (string = annotation.getApplicationName()) != null && string.length() > 0 && (n = string.indexOf(35)) > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getModuleName(ClassLoader classLoader) {
        Annotation annotation = this.getAnnotation(classLoader);
        return annotation != null ? annotation.getModuleName() : null;
    }

    public String getApplicationVersion(ClassLoader classLoader) {
        int n;
        String string;
        Annotation annotation = this.getAnnotation(classLoader);
        if (annotation != null && (string = annotation.getApplicationName()) != null && string.length() > 0 && (n = string.indexOf(35)) > -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    private Annotation getAnnotation(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader instanceof GenericClassLoader) {
                return ((GenericClassLoader)classLoader).getAnnotation();
            }
            final ClassLoader classLoader2 = classLoader;
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return classLoader2.getParent();
                }
            });
        }
        return null;
    }

    public ApplicationContextInternal getCurrentApplicationContext() {
        return this.getApplicationContext(this.getCurrentApplicationName());
    }

    public ApplicationContextInternal getApplicationContext(String string) {
        if (string == null) {
            return null;
        }
        Deployment deployment = DeploymentManager.getDeploymentManager().findDeployment(string);
        if (deployment == null) {
            return null;
        }
        return (ApplicationContextInternal)deployment.getApplicationContext();
    }

    public String getCurrentModuleName() {
        try {
            InitialContext initialContext = new InitialContext();
            return (String)initialContext.lookup("java:/bea/ModuleName");
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public GenericClassLoader findModuleLoader(String string, String string2) {
        AppClassLoaderManager appClassLoaderManager = AppClassLoaderManager.getAppClassLoaderManager();
        return appClassLoaderManager.findModuleLoader(string, string2);
    }

    private static final class ApplicationAccessSingleton {
        private static final ApplicationAccess SINGLETON = new ApplicationAccess();

        private ApplicationAccessSingleton() {
        }
    }
}

