/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.CachingDescriptorLoader2;
import weblogic.application.internal.ApplicationReader;
import weblogic.application.internal.WlsApplicationReader;
import weblogic.application.internal.WlsExtensionReader;
import weblogic.application.utils.ModuleDiscovery;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class ApplicationDescriptor {
    private final MyApplicationDescriptor appDescriptor;
    private final MyWlsApplicationDescriptor wlsAppDescriptor;
    private final MyWlsExtensionDescriptor wlsExtDescriptor;
    private VirtualJarFile vjf = null;
    private static final boolean isServer = Kernel.isServer();
    private static final AuthenticatedSubject kernelId = isServer ? (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction()) : null;
    private boolean validateSchema = true;
    ApplicationBean discoveredModuleAppBean = null;
    boolean scannedForModules = false;

    public ApplicationDescriptor(String string, boolean bl, VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string2) {
        this(virtualJarFile, file, deploymentPlanBean, string2);
        if (bl && ManagementService.getRuntimeAccess(kernelId).getDomain().isInternalAppsDeployOnDemandEnabled()) {
            this.setValidateSchema(false);
        }
    }

    public ApplicationDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appDescriptor = new MyApplicationDescriptor(virtualJarFile, file, deploymentPlanBean, string);
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(virtualJarFile, file, deploymentPlanBean, string);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(virtualJarFile, file, deploymentPlanBean, string);
        this.vjf = virtualJarFile;
    }

    public ApplicationDescriptor(InputStream inputStream, InputStream inputStream2) {
        this.appDescriptor = new MyApplicationDescriptor(inputStream);
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(inputStream2);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor((File)null);
    }

    public ApplicationDescriptor(File file, File file2, File file3, File file4, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appDescriptor = new MyApplicationDescriptor(file, file4, deploymentPlanBean, string);
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(file2, file4, deploymentPlanBean, string);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(file3);
    }

    public ApplicationDescriptor(File file, File file2, VirtualJarFile virtualJarFile, File file3, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appDescriptor = file != null ? new MyApplicationDescriptor(file, file3, deploymentPlanBean, string) : new MyApplicationDescriptor(virtualJarFile, file3, deploymentPlanBean, string);
        this.wlsAppDescriptor = file2 != null ? new MyWlsApplicationDescriptor(file2, file3, deploymentPlanBean, string) : new MyWlsApplicationDescriptor(virtualJarFile, file3, deploymentPlanBean, string);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(virtualJarFile, file3, deploymentPlanBean, string);
        this.vjf = virtualJarFile;
    }

    public ApplicationDescriptor(VirtualJarFile virtualJarFile) {
        this(virtualJarFile, null, null, null);
    }

    public ApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appDescriptor = new MyApplicationDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(descriptorManager, genericClassLoader);
    }

    public ApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this.appDescriptor = new MyApplicationDescriptor(descriptorManager, genericClassLoader);
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(descriptorManager, genericClassLoader);
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(descriptorManager, genericClassLoader);
    }

    public ApplicationDescriptor() {
        byte[] byArray = new String("<jav:application xmlns:jav=\"http://java.sun.com/xml/ns/javaee\" version=\"5\" />").getBytes();
        this.appDescriptor = new MyApplicationDescriptor(new ByteArrayInputStream(byArray));
        byte[] byArray2 = new String("<ns:weblogic-application xmlns:ns=\"http://xmlns.oracle.com/weblogic/weblogic-application\" />").getBytes();
        this.wlsAppDescriptor = new MyWlsApplicationDescriptor(new ByteArrayInputStream(byArray2));
        byte[] byArray3 = new String("<ns:weblogic-extension xmlns:ns=\"http://xmlns.oracle.com/weblogic/weblogic-extension\" />").getBytes();
        this.wlsExtDescriptor = new MyWlsExtensionDescriptor(new ByteArrayInputStream(byArray3));
    }

    public void setValidateSchema(boolean bl) {
        this.validateSchema = bl;
    }

    public void writeDescriptors(File file) throws IOException, XMLStreamException {
        DescriptorManager descriptorManager = new DescriptorManager();
        File file2 = null;
        DescriptorBean descriptorBean = (DescriptorBean)this.getApplicationDescriptor();
        if (descriptorBean != null && this.discoveredModuleAppBean == null) {
            file2 = new File(file, this.appDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file2);
        }
        if ((descriptorBean = (DescriptorBean)this.getWeblogicApplicationDescriptor()) != null) {
            file2 = new File(file, this.wlsAppDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file2);
        }
        if ((descriptorBean = (DescriptorBean)this.getWeblogicExtensionDescriptor()) != null) {
            file2 = new File(file, this.wlsExtDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file2);
        }
    }

    public void writeInferredApplicationDescriptor(File file) throws IOException, XMLStreamException {
        if (this.discoveredModuleAppBean != null) {
            DescriptorManager descriptorManager = new DescriptorManager();
            File file2 = null;
            file2 = new File(file, this.appDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, (DescriptorBean)this.getApplicationDescriptor(), file2);
        }
    }

    public void dumpMergedApplicationDescriptor(String string) {
        try {
            System.out.println("Dumping the merged application.xml descriptor for application " + string);
            DescriptorBean descriptorBean = (DescriptorBean)this.getApplicationDescriptor();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
            String string2 = byteArrayOutputStream.toString();
            System.out.println(" The merged application descriptor is ..." + string2);
            byteArrayOutputStream.close();
            System.out.println("********************************************");
            System.out.println("Dumping the weblogic-application.xml ");
            descriptorBean = (DescriptorBean)this.getWeblogicApplicationDescriptor();
            byteArrayOutputStream = new ByteArrayOutputStream();
            new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
            string2 = byteArrayOutputStream.toString();
            System.out.println(" The merged wlsapplication descriptor is ..." + string2);
            System.out.println("********************************************");
            System.out.println("Dumping the weblogic-extension descriptor");
            descriptorBean = (DescriptorBean)this.getWeblogicExtensionDescriptor();
            byteArrayOutputStream = new ByteArrayOutputStream();
            new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
            string2 = byteArrayOutputStream.toString();
            System.out.println(" The merged wlsextension descriptor is ..." + string2);
        }
        catch (Exception exception) {
            J2EELogger.logDebug((String)(" unable to dump merged descriptor for " + string));
        }
    }

    public ApplicationBean getApplicationDescriptor() throws IOException, XMLStreamException {
        ApplicationBean applicationBean;
        if (!this.validateSchema) {
            this.appDescriptor.setValidate(false);
        }
        if ((applicationBean = (ApplicationBean)this.appDescriptor.loadDescriptorBean()) == null) {
            if (!this.scannedForModules) {
                this.scannedForModules = true;
                if (this.vjf != null) {
                    this.discoveredModuleAppBean = ModuleDiscovery.discoverModules(this.vjf);
                }
            }
            if ((applicationBean = this.discoveredModuleAppBean) != null) {
                this.updateApplicationDescriptor(applicationBean);
                applicationBean = (ApplicationBean)this.appDescriptor.loadDescriptorBean();
            }
        }
        return applicationBean;
    }

    public WeblogicApplicationBean getWeblogicApplicationDescriptor() throws IOException, XMLStreamException {
        if (!this.validateSchema) {
            this.wlsAppDescriptor.setValidate(false);
        }
        return (WeblogicApplicationBean)this.wlsAppDescriptor.loadDescriptorBean();
    }

    public WeblogicExtensionBean getWeblogicExtensionDescriptor() throws IOException, XMLStreamException {
        if (!this.validateSchema) {
            this.wlsExtDescriptor.setValidate(false);
        }
        return (WeblogicExtensionBean)this.wlsExtDescriptor.loadDescriptorBean();
    }

    public void mergeDescriptors(VirtualJarFile virtualJarFile) throws IOException, XMLStreamException {
        try {
            this.appDescriptor.mergeDescriptors(new VirtualJarFile[]{virtualJarFile});
            if (virtualJarFile.getEntry("META-INF/weblogic-application.xml") != null) {
                this.wlsAppDescriptor.mergeDescriptors(new VirtualJarFile[]{virtualJarFile});
            }
            if (virtualJarFile.getEntry("META-INF/weblogic-extension.xml") != null) {
                this.wlsExtDescriptor.mergeDescriptors(new VirtualJarFile[]{virtualJarFile});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public void mergeDescriptors(ApplicationDescriptor applicationDescriptor) throws IOException, XMLStreamException {
        ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
        if (applicationBean != null && applicationBean.getModules() != null && applicationBean.getModules().length > 0) {
            this.appDescriptor.mergeDescriptorBean(applicationDescriptor.getApplicationDescriptorLoader());
        }
        this.wlsAppDescriptor.mergeDescriptorBean(applicationDescriptor.getWlsApplicationDescriptorLoader());
        this.wlsExtDescriptor.mergeDescriptorBean(applicationDescriptor.getWlsExtensionDescriptorLoader());
    }

    private ApplicationBean mergeApplicationDescriptor(File file) throws IOException, XMLStreamException {
        return (ApplicationBean)this.appDescriptor.mergeDescriptors(new File[]{file});
    }

    private WeblogicApplicationBean mergeWlsApplicationDescriptor(File file) throws IOException, XMLStreamException {
        return (WeblogicApplicationBean)this.wlsAppDescriptor.mergeDescriptors(new File[]{file});
    }

    private WeblogicExtensionBean mergeWlsExtentionDescriptor(File file) throws IOException, XMLStreamException {
        return (WeblogicExtensionBean)this.wlsExtDescriptor.mergeDescriptors(new File[]{file});
    }

    public void updateApplicationDescriptor(ApplicationBean applicationBean) throws IOException, XMLStreamException {
        this.appDescriptor.updateDescriptorWithBean((DescriptorBean)applicationBean);
    }

    public void updateWeblogicApplicationDescriptor(WeblogicApplicationBean weblogicApplicationBean) throws IOException, XMLStreamException {
        this.wlsAppDescriptor.updateDescriptorWithBean((DescriptorBean)weblogicApplicationBean);
    }

    public AbstractDescriptorLoader2 getApplicationDescriptorLoader() {
        return this.appDescriptor;
    }

    public AbstractDescriptorLoader2 getWlsApplicationDescriptorLoader() {
        return this.wlsAppDescriptor;
    }

    public AbstractDescriptorLoader2 getWlsExtensionDescriptorLoader() {
        return this.wlsExtDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length < 1) {
            ApplicationDescriptor.usage();
        }
        DescriptorManager descriptorManager = new DescriptorManager();
        if (stringArray[0].lastIndexOf("create") > -1) {
            object = descriptorManager.createDescriptorRoot(ApplicationBean.class);
            descriptorManager.writeDescriptorAsXML(object, (OutputStream)System.out);
            System.out.println("\n\n\n");
            object = descriptorManager.createDescriptorRoot(WeblogicApplicationBean.class);
            descriptorManager.writeDescriptorAsXML(object, (OutputStream)System.out);
            System.exit(0);
        }
        try {
            object = stringArray[0];
            File file = new File((String)object);
            if (file.getName().endsWith(".ear") || file.isDirectory()) {
                VirtualJarFile virtualJarFile = file.getName().endsWith(".ear") ? VirtualJarFactory.createVirtualJar((JarFile)new JarFile((String)object)) : VirtualJarFactory.createVirtualJar((File)file);
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(virtualJarFile, null, null, null);
                descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.getApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.getWeblogicApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                if (stringArray.length > 1) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        JarFile jarFile = new JarFile(stringArray[i]);
                        VirtualJarFile virtualJarFile2 = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                        System.out.println("\n\n... output lib descriptors to merge:");
                        ApplicationDescriptor applicationDescriptor2 = new ApplicationDescriptor(virtualJarFile2, null, null, null);
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor2.getApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                        applicationDescriptor.getApplicationDescriptor().setDescriptions(new String[]{"from depths so profound come enduring change..."});
                        applicationDescriptor.mergeDescriptors(virtualJarFile2);
                        System.out.println("\n\n... getting merged ApplicationBean:");
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.getApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                    }
                }
            } else if (file.getPath().endsWith("weblogic-application.xml")) {
                System.out.println("\n\n... getting WeblogicApplicationBean:");
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(null, file, (File)null, null, null, null);
                descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.getWeblogicApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                if (stringArray.length > 1) {
                    File file2 = new File(stringArray[1]);
                    if (file2.getPath().endsWith("weblogic-application.xml")) {
                        System.out.println("\n\n... merged WeblogicApplicationBean:");
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.mergeWlsApplicationDescriptor(file2)).getDescriptor(), (OutputStream)System.out);
                    }
                    if (file2.getPath().endsWith("plan.xml")) {
                        System.out.println("\n\n... plan:");
                        DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file2);
                        DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)deploymentPlanBean).getDescriptor(), (OutputStream)System.out);
                        ApplicationDescriptor applicationDescriptor3 = new ApplicationDescriptor(null, file, (File)null, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, deploymentPlanBean.getApplicationName());
                        System.out.println("\n\n... plan merged with WeblogicApplicationBean:");
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor3.getWeblogicApplicationDescriptor()).getDescriptor(), (OutputStream)System.out);
                    }
                }
            } else if (file.getPath().endsWith("application.xml")) {
                System.out.println("\n\n... getting WeblogicApplicationBean:");
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(file, null, (File)null, null, null, null);
                DescriptorBean descriptorBean = (DescriptorBean)applicationDescriptor.getApplicationDescriptor();
                descriptorManager.writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)System.out);
                if (stringArray.length > 1) {
                    File file3 = new File(stringArray[1]);
                    ApplicationDescriptor applicationDescriptor4 = new ApplicationDescriptor(file3, null, (File)null, null, null, null);
                    System.out.println("\n\n... dump 2nd bean:");
                    DescriptorBean descriptorBean2 = (DescriptorBean)applicationDescriptor4.getApplicationDescriptor();
                    descriptorManager.writeDescriptorAsXML(descriptorBean2.getDescriptor(), (OutputStream)System.out);
                    System.out.println("\n\n... compared to:");
                    descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.mergeApplicationDescriptor(file3)).getDescriptor(), (OutputStream)System.out);
                    if (stringArray.length > 2) {
                        File file4 = new File(stringArray[2]);
                        ApplicationDescriptor applicationDescriptor5 = new ApplicationDescriptor(file4, null, (File)null, null, null, null);
                        System.out.println("\n\n... dump 2nd bean:");
                        DescriptorBean descriptorBean3 = (DescriptorBean)applicationDescriptor5.getApplicationDescriptor();
                        descriptorManager.writeDescriptorAsXML(descriptorBean3.getDescriptor(), (OutputStream)System.out);
                        ApplicationDescriptor applicationDescriptor6 = new ApplicationDescriptor();
                        DescriptorBean descriptorBean4 = (DescriptorBean)applicationDescriptor6.getApplicationDescriptor();
                        System.out.println("\n\n... getting null application bean :");
                        descriptorManager.writeDescriptorAsXML(descriptorBean4.getDescriptor(), (OutputStream)System.out);
                        applicationDescriptor6.mergeApplicationDescriptor(file);
                        applicationDescriptor6.mergeApplicationDescriptor(file3);
                        applicationDescriptor6.mergeApplicationDescriptor(file4);
                        descriptorBean4 = (DescriptorBean)applicationDescriptor6.getApplicationDescriptor();
                        System.out.println("\n\n... getting null application bean after merge:");
                        descriptorManager.writeDescriptorAsXML(descriptorBean4.getDescriptor(), (OutputStream)System.out);
                        ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
                        ModuleBean moduleBean = applicationBean.createModule();
                        moduleBean.setConnector("my-made-up-connector");
                        System.out.println("\n\n... dump first bean-- should have my-made-up-connector: " + ((DescriptorBean)applicationBean).getDescriptor());
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationBean).getDescriptor(), (OutputStream)System.out);
                        System.out.println("\n\n... compared to:");
                        descriptorManager.writeDescriptorAsXML(((DescriptorBean)applicationDescriptor.mergeApplicationDescriptor(file4)).getDescriptor(), (OutputStream)System.out);
                    }
                }
            } else if (file.getPath().endsWith("weblogic-extension.xml")) {
                System.out.println("\n\n... getting WeblogicExtensionBean:");
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
                applicationDescriptor.mergeWlsExtentionDescriptor(file);
                DescriptorBean descriptorBean = (DescriptorBean)applicationDescriptor.getWeblogicExtensionDescriptor();
                descriptorManager.writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)System.out);
            } else {
                System.out.println("\n\n... neither application nor weblogic-application xml specified");
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.out.println(exception.getMessage());
            System.out.println(exception.getCause());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("usage: java weblogic.application.ApplicationDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.application.ApplicationDescriptor ear or file name ");
        System.exit(0);
    }

    public void printAppDescriptors(PrintStream printStream) {
        try {
            printStream.println("----------------------------------");
        }
        catch (Exception exception) {
            Debug.say((String)("Got this: " + exception));
        }
    }

    public static class MyWlsExtensionDescriptor
    extends CachingDescriptorLoader2 {
        private InputStream is;

        public MyWlsExtensionDescriptor(VirtualJarFile virtualJarFile) {
            super(virtualJarFile, null, null, null, "META-INF/weblogic-extension.xml");
        }

        public MyWlsExtensionDescriptor(File file) {
            super(file, null, null, null, "META-INF/weblogic-extension.xml");
        }

        public MyWlsExtensionDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            this(file, file2, deploymentPlanBean, string, null);
        }

        public MyWlsExtensionDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, "META-INF/weblogic-extension.xml");
        }

        public MyWlsExtensionDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            this(virtualJarFile, file, deploymentPlanBean, string, null);
        }

        public MyWlsExtensionDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, "META-INF/weblogic-extension.xml");
        }

        public MyWlsExtensionDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, null, null, null, "META-INF/weblogic-extension.xml");
        }

        public MyWlsExtensionDescriptor(InputStream inputStream) {
            super((VirtualJarFile)null, null, null, null, "META-INF/weblogic-extension.xml");
            this.is = inputStream;
            this.setValidateSchema(false);
        }

        public InputStream getInputStream() throws IOException {
            if (this.is == null) {
                return super.getInputStream();
            }
            return this.is;
        }

        public String getDocumentURI() {
            return "META-INF/weblogic-extension.xml";
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new WlsExtensionReader(inputStream, this);
        }

        void setValidate(boolean bl) {
            super.setValidateSchema(bl);
        }
    }

    public static class MyWlsApplicationDescriptor
    extends CachingDescriptorLoader2 {
        private InputStream is = null;

        public MyWlsApplicationDescriptor(File file) {
            super(file, null, null, null, "META-INF/weblogic-application.xml");
        }

        public MyWlsApplicationDescriptor(VirtualJarFile virtualJarFile) {
            super(virtualJarFile, null, null, null, "META-INF/weblogic-application.xml");
        }

        public MyWlsApplicationDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            this(file, file2, deploymentPlanBean, string, null);
        }

        public MyWlsApplicationDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, "META-INF/weblogic-application.xml");
        }

        public MyWlsApplicationDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            this(virtualJarFile, file, deploymentPlanBean, string, null);
        }

        public MyWlsApplicationDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, "META-INF/weblogic-application.xml");
        }

        public MyWlsApplicationDescriptor(InputStream inputStream) {
            super((VirtualJarFile)null, null, null, null, "META-INF/weblogic-application.xml");
            this.is = inputStream;
            this.setValidateSchema(false);
        }

        public MyWlsApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, "META-INF/weblogic-application.xml");
        }

        public MyWlsApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, "META-INF/weblogic-application.xml");
        }

        public InputStream getInputStream() throws IOException {
            if (this.is == null) {
                return super.getInputStream();
            }
            return this.is;
        }

        public String getDocumentURI() {
            return "META-INF/weblogic-application.xml";
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new WlsApplicationReader(inputStream, this);
        }

        void setValidate(boolean bl) {
            super.setValidateSchema(bl);
        }
    }

    public static class MyApplicationDescriptor
    extends CachingDescriptorLoader2 {
        private InputStream is = null;

        public MyApplicationDescriptor(File file) {
            super(file, null, null, null, "META-INF/application.xml");
        }

        public MyApplicationDescriptor(VirtualJarFile virtualJarFile) {
            super(virtualJarFile, null, null, null, "META-INF/application.xml");
        }

        public MyApplicationDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            this(file, file2, deploymentPlanBean, string, null);
        }

        public MyApplicationDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, "META-INF/application.xml");
        }

        public MyApplicationDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            this(virtualJarFile, file, deploymentPlanBean, string, null);
        }

        public MyApplicationDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, "META-INF/application.xml");
        }

        public MyApplicationDescriptor(InputStream inputStream) {
            super((VirtualJarFile)null, null, null, null, "META-INF/application.xml");
            this.is = inputStream;
            this.setValidateSchema(false);
        }

        public MyApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, "META-INF/application.xml");
        }

        public MyApplicationDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            this(descriptorManager, genericClassLoader, null, null, null);
        }

        public InputStream getInputStream() throws IOException {
            if (this.is == null) {
                return super.getInputStream();
            }
            return this.is;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new ApplicationReader(inputStream, this);
        }

        void setValidate(boolean bl) {
            super.setValidateSchema(bl);
        }
    }
}

