/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.application.AppDeploymentExtensionFactory;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.DeploymentFactory;
import weblogic.application.ExtensionModuleFactory;
import weblogic.application.ModuleFactory;
import weblogic.application.WebLogicApplicationModuleFactory;
import weblogic.application.WeblogicModuleFactory;
import weblogic.application.library.LibraryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationFactoryManager {
    private DeploymentFactory lastDeploymentFactory;
    private LibraryFactory defaultLibFactory;
    private List<DeploymentFactory> deploymentFactories = Collections.emptyList();
    private List<ModuleFactory> moduleFactories = Collections.emptyList();
    private List<WeblogicModuleFactory> weblogicModuleFactories = Collections.emptyList();
    private List<WebLogicApplicationModuleFactory> wlappModuleFactories = Collections.emptyList();
    private List<LibraryFactory> libraryFactories = Collections.emptyList();
    private List<ExtensionModuleFactory> wlExtensionModuleFactories = Collections.emptyList();
    private List<ComponentMBeanFactory> compFactories = null;
    private List<AppDeploymentExtensionFactory> appExtFactories = Collections.emptyList();
    private static final String[] compMBeanFactories = new String[]{"weblogic.servlet.internal.WarDeploymentFactory", "weblogic.connector.deploy.ConnectorDeploymentFactory", "weblogic.application.internal.EarDeploymentFactory", "weblogic.ejb.container.deployer.EJBDeploymentFactory"};
    private static final ApplicationFactoryManager theOne = new ApplicationFactoryManager();

    private ApplicationFactoryManager() {
    }

    public static ApplicationFactoryManager getApplicationFactoryManager() {
        return theOne;
    }

    public static ApplicationFactoryManager getEmptyApplicationFactoryManager() {
        return new ApplicationFactoryManager();
    }

    public synchronized void addLastDeploymentFactory(DeploymentFactory deploymentFactory) {
        if (this.lastDeploymentFactory != null) {
            throw new AssertionError((Object)("Attempt to add " + deploymentFactory.getClass().getName() + " as the last DeploymentFactory, " + "but " + this.lastDeploymentFactory.getClass().getName() + " has already used this hack."));
        }
        this.lastDeploymentFactory = deploymentFactory;
        ArrayList<DeploymentFactory> arrayList = new ArrayList<DeploymentFactory>(this.deploymentFactories.size() + 1);
        arrayList.addAll(this.deploymentFactories);
        arrayList.add(this.lastDeploymentFactory);
        this.deploymentFactories = arrayList;
    }

    public synchronized void addDeploymentFactory(DeploymentFactory deploymentFactory) {
        ArrayList<DeploymentFactory> arrayList = new ArrayList<DeploymentFactory>(this.deploymentFactories.size() + 1);
        arrayList.addAll(this.deploymentFactories);
        if (this.lastDeploymentFactory != null) {
            arrayList.add(this.deploymentFactories.size() - 1, deploymentFactory);
        } else {
            arrayList.add(deploymentFactory);
        }
        this.deploymentFactories = arrayList;
    }

    public synchronized void addDeploymentFactoryFirst(DeploymentFactory deploymentFactory) {
        ArrayList<DeploymentFactory> arrayList = new ArrayList<DeploymentFactory>(this.deploymentFactories.size() + 1);
        arrayList.add(deploymentFactory);
        arrayList.addAll(this.deploymentFactories);
        this.deploymentFactories = arrayList;
    }

    public Iterator<DeploymentFactory> getDeploymentFactories() {
        return this.deploymentFactories.iterator();
    }

    public synchronized void addModuleFactory(ModuleFactory moduleFactory) {
        ArrayList<ModuleFactory> arrayList = new ArrayList<ModuleFactory>(this.moduleFactories.size() + 1);
        arrayList.addAll(this.moduleFactories);
        arrayList.add(moduleFactory);
        this.moduleFactories = arrayList;
    }

    public Iterator<ModuleFactory> getModuleFactories() {
        return this.moduleFactories.iterator();
    }

    public synchronized Iterator<ComponentMBeanFactory> getComponentMBeanFactories() {
        if (this.compFactories == null) {
            this.initCompFactories();
        }
        return this.compFactories.iterator();
    }

    private synchronized void initCompFactories() {
        ComponentMBeanFactory[] componentMBeanFactoryArray = new ComponentMBeanFactory[compMBeanFactories.length];
        for (int i = 0; i < componentMBeanFactoryArray.length; ++i) {
            try {
                componentMBeanFactoryArray[i] = (ComponentMBeanFactory)Class.forName(compMBeanFactories[i]).newInstance();
                continue;
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
        this.compFactories = Arrays.asList(componentMBeanFactoryArray);
    }

    public synchronized void addWblogicModuleFactory(WeblogicModuleFactory weblogicModuleFactory) {
        ArrayList<WeblogicModuleFactory> arrayList = new ArrayList<WeblogicModuleFactory>(this.weblogicModuleFactories.size() + 1);
        arrayList.addAll(this.weblogicModuleFactories);
        arrayList.add(weblogicModuleFactory);
        this.weblogicModuleFactories = arrayList;
    }

    public Iterator<WeblogicModuleFactory> getWeblogicModuleFactories() {
        return this.weblogicModuleFactories.iterator();
    }

    public synchronized void addWLAppModuleFactory(WebLogicApplicationModuleFactory webLogicApplicationModuleFactory) {
        ArrayList<WebLogicApplicationModuleFactory> arrayList = new ArrayList<WebLogicApplicationModuleFactory>(this.wlappModuleFactories.size() + 1);
        arrayList.addAll(this.wlappModuleFactories);
        arrayList.add(webLogicApplicationModuleFactory);
        this.wlappModuleFactories = arrayList;
    }

    public Iterator<WebLogicApplicationModuleFactory> getWLAppModuleFactories() {
        return this.wlappModuleFactories.iterator();
    }

    public synchronized void addDefaultLibraryFactory(LibraryFactory libraryFactory) {
        if (this.defaultLibFactory != null) {
            throw new AssertionError((Object)("Attempt to add " + libraryFactory.getClass().getName() + " as the default " + "LibraryFactory, but " + this.defaultLibFactory.getClass().getName() + " has already used this feature."));
        }
        this.addLibraryFactory(libraryFactory);
        this.defaultLibFactory = libraryFactory;
    }

    public synchronized void addLibraryFactory(LibraryFactory libraryFactory) {
        ArrayList<LibraryFactory> arrayList = new ArrayList<LibraryFactory>(this.libraryFactories.size() + 1);
        arrayList.addAll(this.libraryFactories);
        if (this.defaultLibFactory != null) {
            arrayList.add(this.libraryFactories.size() - 1, libraryFactory);
        } else {
            arrayList.add(libraryFactory);
        }
        this.libraryFactories = arrayList;
    }

    public Iterator<LibraryFactory> getLibraryFactories() {
        return this.libraryFactories.iterator();
    }

    public synchronized void addWebLogicExtensionModuleFactory(ExtensionModuleFactory extensionModuleFactory) {
        ArrayList<ExtensionModuleFactory> arrayList = new ArrayList<ExtensionModuleFactory>(this.wlExtensionModuleFactories.size() + 1);
        arrayList.addAll(this.wlExtensionModuleFactories);
        arrayList.add(extensionModuleFactory);
        this.wlExtensionModuleFactories = arrayList;
    }

    public Iterator<ExtensionModuleFactory> getWebLogicExtenstionModuleFactories() {
        return this.wlExtensionModuleFactories.iterator();
    }

    public synchronized void addAppDeploymentExtensionFactory(AppDeploymentExtensionFactory appDeploymentExtensionFactory) {
        ArrayList<AppDeploymentExtensionFactory> arrayList = new ArrayList<AppDeploymentExtensionFactory>(this.appExtFactories.size() + 1);
        arrayList.addAll(this.appExtFactories);
        arrayList.add(appDeploymentExtensionFactory);
        this.appExtFactories = arrayList;
    }

    public Iterator<AppDeploymentExtensionFactory> getAppExtensionFactories() {
        return this.appExtFactories.iterator();
    }
}

