/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.application.ApplicationFileManager;
import weblogic.application.SplitDirectoryConstants;
import weblogic.application.SplitDirectoryInfo;
import weblogic.utils.Debug;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class ApplicationFileManagerImpl
extends ApplicationFileManager
implements SplitDirectoryConstants {
    private static final boolean debug = Debug.getCategory((String)"weblogic.application.AFM").isEnabled();
    private static final boolean verbose = Debug.getCategory((String)"weblogic.application.barf").isEnabled();
    private final File appFile;
    private final VirtualJarFactory factory = new VirtualJarFactory();
    private boolean isSplitDirectory;
    private File splitSourceDir;
    private HashMap links = new HashMap();

    protected ApplicationFileManagerImpl(String string) throws IOException {
        this(new File(string));
    }

    protected ApplicationFileManagerImpl(File file) throws IOException {
        if (debug) {
            Debug.say((String)("created with : " + file.getPath()));
            if (verbose) {
                Debug.stackdump((String)"\n");
            }
        }
        this.appFile = file;
        this.handleSplitDirectory();
    }

    protected ApplicationFileManagerImpl(SplitDirectoryInfo splitDirectoryInfo) throws IOException {
        this.appFile = splitDirectoryInfo.getDestDir();
        this.splitSourceDir = splitDirectoryInfo.getSrcDir();
        this.isSplitDirectory = this.splitSourceDir != null;
        this.registerLinks(splitDirectoryInfo);
    }

    private void handleSplitDirectory() throws IOException {
        if (!this.appFile.isDirectory()) {
            if (debug) {
                Debug.say((String)"is archive not split dir");
            }
            return;
        }
        File file = new File(this.appFile, ".beabuild.txt");
        if (!file.exists()) {
            if (debug) {
                Debug.say((String)"No split directory file so it must be a \"normal\" exploded archive");
            }
            this.isSplitDirectory = false;
            this.splitSourceDir = null;
            return;
        }
        this.isSplitDirectory = true;
        SplitDirectoryInfo splitDirectoryInfo = new SplitDirectoryInfo(this.appFile, file);
        this.splitSourceDir = splitDirectoryInfo.getSrcDir();
        if (debug) {
            Debug.say((String)("Its a split directory app and source dir is : " + this.splitSourceDir));
        }
        this.registerLinks(splitDirectoryInfo);
    }

    public boolean isSplitDirectory() {
        return this.isSplitDirectory;
    }

    private void registerLinks(SplitDirectoryInfo splitDirectoryInfo) throws IOException {
        Map map = splitDirectoryInfo.getUriLinks();
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            this.registerLink(string, list.toArray(new File[list.size()]));
        }
    }

    public void registerLink(String string, String string2) throws IOException {
        File file = new File(string2);
        if (!file.exists()) {
            throw new IOException("Cannot register link for uri '" + string + "'.  " + string2 + " does not exist.");
        }
        if (debug) {
            Debug.say((String)("About to register " + string + " for location\n" + string2));
        }
        this.registerLink(string, new File[]{file});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLink(String string, File[] fileArray) throws IOException {
        ApplicationFileManagerImpl applicationFileManagerImpl = this;
        synchronized (applicationFileManagerImpl) {
            this.links.put(string, fileArray);
        }
    }

    public VirtualJarFile getVirtualJarFile() throws IOException {
        if (this.isSplitDirectory) {
            if (debug) {
                Debug.say((String)("getVirtualJarFile isSplitDirectory src=" + this.splitSourceDir.getPath() + " appFile=" + this.appFile.getPath()));
            }
            return VirtualJarFactory.createVirtualJar((File)this.splitSourceDir, (File)this.appFile);
        }
        if (debug) {
            Debug.say((String)("getVirtualJarFile isNOTSplitDirectory src=" + this.appFile.getPath()));
        }
        return VirtualJarFactory.createVirtualJar((File)this.appFile);
    }

    public VirtualJarFile getVirtualJarFile(String string) throws IOException {
        File[] fileArray;
        if (debug) {
            Debug.say((String)("getVirtualJarFile isSplitDirectory=" + this.isSplitDirectory));
            if (verbose) {
                Debug.stackdump((String)"\n");
            }
        }
        if ((fileArray = (File[])this.links.get(string)) != null) {
            return VirtualJarFactory.createVirtualJar((File[])fileArray);
        }
        if (this.isSplitDirectory) {
            if (debug) {
                Debug.say((String)("getVirtualJarFile creating SplitExplodedJarFile \nsrcdir is : " + this.splitSourceDir + "/" + string + "\noutdir is : " + this.appFile.getPath() + "/" + string));
            }
            File file = new File(this.splitSourceDir, string);
            File file2 = new File(this.appFile, string);
            if (file.exists() && !file.isDirectory()) {
                return VirtualJarFactory.createVirtualJar((File)file);
            }
            if (file2.exists() && !file2.isDirectory()) {
                return VirtualJarFactory.createVirtualJar((File)file2);
            }
            return VirtualJarFactory.createVirtualJar((File)file, (File)file2);
        }
        if (this.appFile.isDirectory()) {
            if (debug) {
                Debug.say((String)("getVirtualJarFile creating with exploded dir \nsrcdir is : " + this.appFile.getPath() + "/" + string));
            }
            return VirtualJarFactory.createVirtualJar((File)new File(this.appFile, string));
        }
        throw new AssertionError((Object)"You cannot get a sub-vjf on an archive");
    }

    private String getFileCP(File file, String string, String string2) {
        return new File(file, string + File.separatorChar + string2).getAbsolutePath();
    }

    public String getClasspath(String string) {
        return this.getClasspath(string, "");
    }

    public String getClasspath(String string, String string2) {
        File[] fileArray = (File[])this.links.get(string);
        if (fileArray != null) {
            String string3 = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(string3);
                stringBuffer.append(fileArray[i].getAbsolutePath());
                string3 = File.pathSeparator;
            }
            return stringBuffer.toString();
        }
        if (this.isSplitDirectory) {
            return this.getFileCP(this.splitSourceDir, string, string2) + File.pathSeparator + this.getFileCP(this.appFile, string, string2);
        }
        return this.getFileCP(this.appFile, string, string2);
    }

    public File getSourcePath() {
        if (this.isSplitDirectory) {
            return this.splitSourceDir;
        }
        return this.appFile;
    }

    public File getSourcePath(String string) {
        if (debug) {
            Debug.say((String)("getSourcePath uri " + string + " isSplitDirectory : " + this.isSplitDirectory));
        }
        File file = null;
        File[] fileArray = (File[])this.links.get(string);
        if (fileArray != null) {
            return fileArray[0];
        }
        if (this.isSplitDirectory && (file = new File(this.splitSourceDir, string)).exists()) {
            return file;
        }
        return new File(this.appFile, string);
    }

    public File getOutputPath() {
        return this.appFile;
    }

    public File getOutputPath(String string) {
        File[] fileArray = (File[])this.links.get(string);
        if (fileArray != null) {
            return fileArray[0];
        }
        return new File(this.appFile, string);
    }

    public String toString() {
        return super.toString() + " isSplitDirectory : " + new Boolean(this.isSplitDirectory).toString() + (this.appFile != null ? this.appFile.getPath() : "null");
    }
}

