/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import weblogic.application.Deployment;
import weblogic.application.DeploymentManager;
import weblogic.application.DeploymentWrapper;
import weblogic.application.utils.XMLWriter;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;

public class ApplicationManagerImageSource
implements ImageSource {
    private boolean timedOut = false;

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        XMLWriter xMLWriter = null;
        try {
            xMLWriter = new XMLWriter(new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")));
            xMLWriter.addElement("application-container");
            Iterator iterator = DeploymentManager.getDeploymentManager().getDeployments();
            while (iterator.hasNext() && !this.timedOut) {
                Deployment deployment = (Deployment)iterator.next();
                xMLWriter.addElement("application");
                while (deployment instanceof DeploymentWrapper) {
                    deployment = ((DeploymentWrapper)((Object)deployment)).getDeployment();
                }
                xMLWriter.addElement("deployment-class", deployment.getClass().getName());
                deployment.getApplicationContext().writeDiagnosticImage(xMLWriter);
                xMLWriter.closeElement();
            }
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException((Throwable)iOException);
        }
        finally {
            if (xMLWriter != null) {
                xMLWriter.finish();
            }
        }
    }

    public void timeoutImageCreation() {
        this.timedOut = true;
    }
}

