/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.security.AccessController;
import java.util.List;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.ApplicationManagerImageSource;
import weblogic.application.internal.AppClientModuleFactory;
import weblogic.application.internal.CarDeploymentFactory;
import weblogic.application.internal.EarDeploymentFactory;
import weblogic.application.internal.OptionalPackageProviderImpl;
import weblogic.application.internal.library.EarLibraryFactory;
import weblogic.application.internal.library.JarLibraryFactory;
import weblogic.application.internal.library.LibraryDeploymentFactory;
import weblogic.application.library.LibraryDeploymentListener;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.diagnostics.image.ImageManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.DeploymentException;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.OptionalPackageProvider;

public final class ApplicationShutdownService
extends AbstractServerService {
    private Object syncObj = new Object();
    private boolean shutdown;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        applicationFactoryManager.addDeploymentFactory(new EarDeploymentFactory());
        applicationFactoryManager.addDeploymentFactory(new CarDeploymentFactory());
        applicationFactoryManager.addLibraryFactory(new EarLibraryFactory());
        applicationFactoryManager.addDefaultLibraryFactory(new JarLibraryFactory());
        applicationFactoryManager.addModuleFactory(new AppClientModuleFactory());
        applicationFactoryManager.addDeploymentFactoryFirst(new LibraryDeploymentFactory());
        try {
            DeploymentEventManager.addVetoableDeploymentListener(new LibraryDeploymentListener());
        }
        catch (DeploymentException deploymentException) {
            throw new ServiceFailureException((Throwable)((Object)deploymentException));
        }
        OptionalPackageProvider.set((OptionalPackageProvider)new OptionalPackageProviderImpl());
        ImageManager.getInstance().registerImageSource("APPLICATION", new ApplicationManagerImageSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceFailureException {
        while (this.checkPendingWorkInQueues()) {
            try {
                Object object = this.syncObj;
                synchronized (object) {
                    this.syncObj.wait(30000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        this.shutdown = true;
        DeploymentServerService.shutdownHelper();
    }

    private boolean checkPendingWorkInQueues() {
        List list = Kernel.getApplicationDispatchPolicies();
        boolean bl = false;
        if (list != null) {
            for (String string : list) {
                int n = Kernel.getPendingTasksCount(string);
                if (n <= 0) continue;
                T3SrvrLogger.logPendingWorkInQueues((String)string, (int)n);
                bl = true;
            }
        }
        return bl;
    }

    public void halt() throws ServiceFailureException {
        if (this.shutdown) {
            return;
        }
        DeploymentServerService.shutdownHelper();
    }
}

