/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.io.File;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.configuration.JDBCPoolComponentMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebServiceComponentMBean;

public interface ComponentMBeanFactory {
    public static final MBeanFactory EJB_COMP = new MBeanFactory(){

        public ComponentMBean newCompMBean(ApplicationMBean applicationMBean, String string) {
            return applicationMBean.createEJBComponent(string);
        }

        public Class getComponentMBeanType() {
            return EJBComponentMBean.class;
        }
    };
    public static final MBeanFactory WEB_COMP = new MBeanFactory(){

        public ComponentMBean newCompMBean(ApplicationMBean applicationMBean, String string) {
            return applicationMBean.createWebAppComponent(string);
        }

        public Class getComponentMBeanType() {
            return WebAppComponentMBean.class;
        }
    };
    public static final MBeanFactory WEB_SERVICE_COMP = new MBeanFactory(){

        public ComponentMBean newCompMBean(ApplicationMBean applicationMBean, String string) {
            return applicationMBean.createWebServiceComponent(string);
        }

        public Class getComponentMBeanType() {
            return WebServiceComponentMBean.class;
        }
    };
    public static final MBeanFactory CONNECTOR_COMP = new MBeanFactory(){

        public ComponentMBean newCompMBean(ApplicationMBean applicationMBean, String string) {
            return applicationMBean.createConnectorComponent(string);
        }

        public Class getComponentMBeanType() {
            return ConnectorComponentMBean.class;
        }
    };
    public static final MBeanFactory JDBC_COMP = new MBeanFactory(){

        public ComponentMBean newCompMBean(ApplicationMBean applicationMBean, String string) {
            return applicationMBean.createJDBCPoolComponent(string);
        }

        public Class getComponentMBeanType() {
            return JDBCPoolComponentMBean.class;
        }
    };
    public static final ComponentMBeanFactory DEFAULT_FACTORY = new ComponentMBeanFactory(){

        public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file) {
            return new ComponentMBean[0];
        }

        public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file, AppDeploymentMBean appDeploymentMBean) {
            return new ComponentMBean[0];
        }

        public boolean needsApplicationPathMunging() {
            return false;
        }
    };

    public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean var1, File var2, AppDeploymentMBean var3) throws DeploymentException;

    public boolean needsApplicationPathMunging();

    public static abstract class MBeanFactory {
        public abstract ComponentMBean newCompMBean(ApplicationMBean var1, String var2);

        public abstract Class getComponentMBeanType();
    }
}

