/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.application.Module;
import weblogic.application.ModuleLocationInfo;
import weblogic.application.ModuleWrapper;

public final class ModuleManager {
    private Module[] modules = new Module[0];
    private final Map idMap = new HashMap(0);
    private Map additionalModuleUris = Collections.EMPTY_MAP;

    public void setAdditionalModuleUris(Map map) {
        this.additionalModuleUris = map;
    }

    public synchronized void setModules(Module[] moduleArray) {
        this.idMap.clear();
        for (int i = 0; i < moduleArray.length; ++i) {
            this.idMap.put(moduleArray[i].getId(), moduleArray[i]);
        }
        this.modules = moduleArray;
    }

    public synchronized Module findModuleWithId(String string) {
        return (Module)this.idMap.get(string);
    }

    public synchronized List findModulesWithIds(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.idMap.containsKey(stringArray[i])) continue;
            arrayList.add(this.idMap.get(stringArray[i]));
        }
        return arrayList;
    }

    public synchronized Module[] getModules() {
        return this.modules;
    }

    public synchronized boolean validateModuleIds(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isValidModuleId(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized String[] getValidModuleIds(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isValidModuleId(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public synchronized String[] getInvalidModuleIds(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isValidModuleId(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public synchronized Map getModuleIdToUriMapping(String[] stringArray) {
        HashMap hashMap = new HashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Module module = this.findModuleWithId(stringArray[i]);
            if (module == null) {
                hashMap.put(stringArray[i], this.additionalModuleUris.get(stringArray[i]));
                continue;
            }
            if (module instanceof ModuleWrapper) {
                module = ((ModuleWrapper)module).unwrap();
            }
            if (module instanceof ModuleLocationInfo) {
                hashMap.put(stringArray[i], ((ModuleLocationInfo)module).getModuleURI());
                continue;
            }
            hashMap.put(stringArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public boolean areNewUris(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.idMap.containsKey(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isValidModuleId(String string) {
        return this.idMap.containsKey(string) || this.additionalModuleUris.containsKey(string);
    }

    public boolean isNewUri(String string) {
        return !this.idMap.containsKey(string);
    }
}

