/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class SplitDirectoryInfo {
    private final SplitDirParser parser;

    public SplitDirectoryInfo(File file, File file2) throws IOException {
        this.parser = new SplitDirParser(file, file2);
        this.parser.load();
    }

    public File[] getRootDirectories() {
        if (this.getSrcDir() != null && this.getSrcDir().equals(this.getDestDir())) {
            return new File[]{this.getSrcDir()};
        }
        return new File[]{this.getSrcDir(), this.getDestDir()};
    }

    public File getSrcDir() {
        return this.parser.srcDir;
    }

    public File getDestDir() {
        return this.parser.destDir;
    }

    public Map getUriLinks() {
        return this.parser.uriLinks;
    }

    public Iterator getAppClasses() {
        return this.parser.appClasses.iterator();
    }

    public String[] getWebAppClasses(String string) {
        List list = (List)this.parser.webClasses.get(string);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public String getExtraClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (String string2 : this.parser.appClasses) {
            stringBuffer.append(string);
            string = File.pathSeparator;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static class SplitDirParser
    extends Properties {
        private final File destDir;
        private final File propsFile;
        private File srcDir;
        private String srcPath;
        private final Map uriLinks = new HashMap();
        private final List appClasses = new ArrayList();
        private final Map webClasses = new HashMap();

        SplitDirParser(File file, File file2) {
            this.destDir = file;
            this.propsFile = file2;
        }

        private File resolveSrcDir() throws IOException {
            if (this.srcPath == null) {
                return this.destDir;
            }
            File file = new File(this.srcPath);
            if (!file.isAbsolute()) {
                file = new File(this.destDir, file.getPath());
            }
            if (!file.exists()) {
                throw new IOException("Unable to find the source directory: " + file.getAbsolutePath() + ".  This directory is referenced in the file: " + this.propsFile.getAbsolutePath() + ".  A possible solution is to rebuild your application.");
            }
            if (!file.isDirectory()) {
                throw new IOException("The source directory: " + file.getAbsolutePath() + " exists, but it is not a directory.  This directory is " + "referenced in the file: " + this.propsFile.getAbsolutePath());
            }
            return file;
        }

        public Object put(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if ("bea.srcdir".equals(object)) {
                this.srcPath = string2;
            } else if (string2.startsWith("APP-INF/lib/") || "APP-INF/classes".equals(string2)) {
                this.appClasses.add(object);
            } else if (string2.indexOf("WEB-INF/classes") > -1 || string2.indexOf("WEB-INF/lib/") > -1) {
                int n = string2.replace(File.separatorChar, '/').indexOf(47);
                String string3 = n == -1 ? string2 : string2.substring(0, n);
                ArrayList<String> arrayList = (ArrayList<String>)this.webClasses.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.webClasses.put(string3, arrayList);
                }
                arrayList.add(string);
            } else {
                ArrayList<File> arrayList = (ArrayList<File>)this.uriLinks.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                arrayList.add(new File(string));
                this.uriLinks.put(object2, arrayList);
            }
            return super.put(object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() throws IOException {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.propsFile);
                this.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            this.srcDir = this.resolveSrcDir();
        }
    }
}

