/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.FlowDriver;
import weblogic.application.compiler.flow.AppMergerFlow;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.compiler.flow.InitLibrariesFlow;
import weblogic.application.compiler.flow.InitPlanFlow;
import weblogic.application.compiler.flow.PrepareInputFlow;
import weblogic.application.compiler.flow.SetupFlow;
import weblogic.application.utils.LibraryUtils;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.utils.BadOptionException;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;

public class AppMerge
extends Tool {
    private final CompilerCtx ctx = new CompilerCtx();
    private final FlowDriver.CompilerFlowDriver driver;

    public AppMerge(String[] stringArray) {
        super(stringArray);
        String string = ".appmergegen_" + System.currentTimeMillis();
        CompilerFlow[] compilerFlowArray = new CompilerFlow[]{new SetupFlow(this.ctx, string), new PrepareInputFlow(this.ctx), new InitPlanFlow(this.ctx), new InitLibrariesFlow(this.ctx, true), new AppMergerFlow(this.ctx)};
        this.driver = new FlowDriver.CompilerFlowDriver(compilerFlowArray);
    }

    public AppMerge(String[] stringArray, WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, boolean bl, boolean bl2, boolean bl3) {
        this(stringArray);
        this.ctx.setObjectFactory(webLogicDeployableObjectFactory);
        if (bl) {
            this.ctx.disableLibraryMerge();
        }
        this.ctx.setVerifyLibraryReferences(bl2);
        if (bl3) {
            this.ctx.keepLibraryRegistrationOnExit();
        }
    }

    public AppMerge(String[] stringArray, WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(stringArray, webLogicDeployableObjectFactory, bl, bl2, bl3);
        if (bl4) {
            this.ctx.setBasicView();
        }
    }

    public void prepare() {
        this.setRequireExtraArgs(true);
        this.setUsageName("weblogic.appmerge");
        this.opts.setUsageArgs("<ear, jar or war file or directory>");
        this.opts.addOption("output", "file", "Specifies an alternate output archive or directory.  If not set, output will be placed in the source archive or directory.");
        this.opts.addOption("plan", "file", "Specifies an optional deployment plan.");
        this.opts.addOption("plandir", "directory", "Specifies an optional deployment plan directory.");
        this.opts.markPrivate("plandir");
        this.opts.addFlag("verbose", "More output");
        this.opts.addFlag("nopackage", "do not create archived package");
        this.opts.addFlag("readonly", "Don't write out merged app to disk. Used with direct merge() invocation.");
        this.opts.markPrivate("readonly");
        this.opts.markPrivate("nopackage");
        this.opts.addFlag("ignoreMissingLibRefs", "Don't verify that all the libraries referred in the application are specified in command line library options. This may cause failures to load up application in case such libraries were needed");
        this.opts.markPrivate("ignoreMissingLibRefs");
        this.opts.addOption("classpath", "path", "Classpath to use.");
        this.opts.markPrivate("classpath");
        this.opts.addFlag("writeInferredDescriptors", "Write out the descriptors with inferred information including annotations.");
        this.opts.addOption("lightweight", "deployed application name", "Generate Deployment View by using lightweight flow which directly get information from the server which application already deployed on.");
        this.opts.markPrivate("lightweight");
        LibraryUtils.addLibraryUsage(this.opts);
    }

    public void runBody() throws ToolFailureException {
        try {
            this.opts.setOption("noexit", "true");
            this.ctx.setOpts(this.opts);
        }
        catch (BadOptionException badOptionException) {
            // empty catch block
        }
        try {
            this.driver.compile();
        }
        catch (ToolFailureException toolFailureException) {
            if (this.ctx.isVerbose() && toolFailureException.getCause() != null) {
                toolFailureException.getCause().printStackTrace();
            }
            throw toolFailureException;
        }
    }

    public EditableDeployableObject merge() throws ToolFailureException {
        try {
            this.run();
            return this.ctx.getDeployableApplication();
        }
        catch (Exception exception) {
            throw new ToolFailureException("Exception in AppMerge flows' progression", (Throwable)exception);
        }
    }

    public void cleanup() throws ToolFailureException {
        try {
            this.driver.cleanup();
        }
        catch (ToolFailureException toolFailureException) {
            if (this.ctx.isVerbose() && toolFailureException.getCause() != null) {
                toolFailureException.getCause().printStackTrace();
            }
            throw toolFailureException;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AppMerge appMerge = new AppMerge(stringArray);
        appMerge.run();
        appMerge.cleanup();
    }
}

