/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.util.ArrayList;
import java.util.List;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.FlowDriver;
import weblogic.application.compiler.flow.AppCompilerFlow;
import weblogic.application.compiler.flow.CheckUnusedLibrariesFlow;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.compiler.flow.InitLibrariesFlow;
import weblogic.application.compiler.flow.InitPlanFlow;
import weblogic.application.compiler.flow.OptionalPackageReferencerFlow;
import weblogic.application.compiler.flow.PrepareInputFlow;
import weblogic.application.compiler.flow.SetupFlow;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.BadOptionException;
import weblogic.utils.compiler.ArgfileParser;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appc
extends Tool {
    protected Appc(String[] stringArray) {
        super(stringArray);
    }

    public void prepare() {
        this.setRequireExtraArgs(true);
        this.setUsageName("weblogic.appc");
        this.opts.setUsageArgs("<ear, jar, war or rar file or directory>");
        this.opts.addOption("output", "file", "Specifies an alternate output archive or directory.  If not set, output will be placed in the source archive or directory.");
        this.opts.addOption("plan", "file", "Specifies an optional deployment plan.");
        this.opts.addFlag("forceGeneration", "Force generation of EJB and JSP classes.  Without this flag the classes may not be regenerated if it is determined to be unnecessary.");
        this.opts.addFlag("quiet", "Turns off output except for errors");
        this.opts.addFlag("lineNumbers", "Add JSP line numbers to generated class files to aid in debugging.");
        this.opts.addAdvancedFlag("k", "continue compiling jsp files, even when some fail");
        this.opts.addOption("moduleUri", "uri", "Specify a module in an ear file for compilation.");
        this.opts.addOption("jsps", "jsps", "Comma-separated list of jsp files, specifies jsps that need to be compiled. All jsps of the app will be compiled if the option is not passed into.");
        this.opts.addAdvancedFlag("useByteBuffer", "Generate source codes of jsp files to use NIO ByteBuffer for static contents.");
        this.opts.addFlag("compileAllTagFiles", "Compile all JSP tag files");
        LibraryUtils.addLibraryUsage(this.opts);
        this.opts.addAdvancedFlag("basicClientJar", "Do not include deployment descriptors in client jars generated for EJBs.");
        this.opts.addFlag("disableHotCodeGen", "Generate ejb stub and skel as part of ejbc. Avoid HotCodeGen to have better performance.");
        this.opts.addFlag("enableHotCodeGen", "Do not generate ejb stub and skel as part of ejbc. Stubs and skels will be dynamically generated.");
        this.opts.addFlag("writeInferredDescriptors", "Write out the descriptors with inferred information including annotations.");
        this.opts.addOption("manifest", "file", "Include manifest information from specified manifest file.");
        this.opts.addOption("clientJarOutputDir", "dir", "Specifies a directory to put generated client jars.");
        this.opts.addAdvancedFlag("idl", "Generate idl for EJB remote interfaces");
        this.opts.addAdvancedFlag("idlOverwrite", "Always overwrite existing IDL files");
        this.opts.addAdvancedFlag("idlVerbose", "Display verbose information for IDL generation");
        this.opts.addAdvancedFlag("idlNoValueTypes", "Do not generate valuetypes and methods/attributes that contain them.");
        this.opts.addAdvancedFlag("idlNoAbstractInterfaces", "Do not generate abstract interfaces and methods/attributes that contain them.");
        this.opts.addAdvancedFlag("idlFactories", "Generate factory methods for valuetypes.");
        this.opts.addAdvancedFlag("idlVisibroker", "Generate IDL somewhat compatible with Visibroker 4.5 C++.");
        this.opts.addAdvancedFlag("idlOrbix", "Generate IDL somewhat compatible with Orbix 2000 2.0 C++.");
        this.opts.addAdvancedOption("idlDirectory", "dir", "Specify the directory where IDL files will be created (default : target directory or jar)");
        this.opts.addAdvancedOption("idlMethodSignatures", "signature", "Specify the method signatures used to trigger idl code generation.");
        this.opts.addAdvancedFlag("iiop", "Generate CORBA stubs for EJBs");
        this.opts.addAdvancedFlag("ignorePlanValidation", "Ignore the plan file if it doesn't exist");
        this.opts.addAdvancedOption("iiopDirectory", "dir", "Specify the directory where IIOP stub files will be written (default : target directory or jar)");
        this.opts.addAdvancedOption("altappdd", "file", "Location of the alternate application deployment descriptor.");
        this.opts.addAdvancedOption("altwlsappdd", "file", "Location of the alternate WebLogic application deployment descriptor.");
        this.opts.addAdvancedOption("maxfiles", "int", "Maximum number of generated java files to be compiled at one time.");
        new CompilerInvoker(this.opts);
        this.opts.markAdvanced("verboseJavac");
        this.opts.markAdvanced("normi");
        this.opts.markAdvanced("nowarn");
        this.opts.markAdvanced("deprecation");
        this.opts.markAdvanced("O");
        this.opts.markAdvanced("J");
        this.opts.markAdvanced("g");
        this.opts.markAdvanced("compilerclass");
        this.opts.markAdvanced("compiler");
        this.opts.markPrivate("nowrite");
        this.opts.markPrivate("commentary");
        this.opts.markPrivate("d");
        this.opts.markPrivate("disableHotCodeGen");
        this.opts.markPrivate("enableHotCodeGen");
        this.opts.markPrivate("moduleUri");
        this.opts.markPrivate("jsps");
        this.opts.markPrivate("compileAllTagFiles");
        this.opts.markPrivate("useByteBuffer");
    }

    public void runBody() throws ToolFailureException {
        try {
            if (this.opts.hasOption("enableHotCodeGen")) {
                this.opts.setFlag("disableHotCodeGen", false);
            } else {
                this.opts.setFlag("disableHotCodeGen", true);
            }
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        this.opts.removeOption("enableHotCodeGen");
        CompilerCtx compilerCtx = new CompilerCtx();
        compilerCtx.setOpts(this.opts);
        String string = "appcgen_" + System.currentTimeMillis();
        CompilerFlow[] compilerFlowArray = new CompilerFlow[]{new SetupFlow(compilerCtx, string), new PrepareInputFlow(compilerCtx), new OptionalPackageReferencerFlow(compilerCtx), new InitPlanFlow(compilerCtx), new InitLibrariesFlow(compilerCtx, false), new AppCompilerFlow(compilerCtx), new CheckUnusedLibrariesFlow(compilerCtx)};
        try {
            new FlowDriver().run(compilerFlowArray);
        }
        catch (ToolFailureException toolFailureException) {
            if (!compilerCtx.isVerbose()) {
                J2EELogger.logAppcFailedWithError();
            }
            if (compilerCtx.isVerbose() && toolFailureException.getCause() != null) {
                toolFailureException.getCause().printStackTrace();
            }
            throw toolFailureException;
        }
    }

    private List<String> conjoinJspsOption(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (i == list.size() - 1) {
                bl = false;
            }
            if (string.startsWith("-")) {
                bl = "-jsps".equals(string);
            }
            if (bl && !string.startsWith("-")) {
                arrayList2.add(string);
                continue;
            }
            arrayList.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringBuilder.append((String)arrayList2.get(i));
            if (i >= arrayList2.size() - 1) continue;
            stringBuilder.append(",");
        }
        if (arrayList.indexOf("-jsps") >= 0) {
            arrayList.add(arrayList.indexOf("-jsps") + 1, stringBuilder.toString());
        }
        return arrayList;
    }

    protected String[] transformArgs(String[] stringArray) throws ToolFailureException {
        List<String> list = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.startsWith("@")) {
                list.addAll(new ArgfileParser(string.substring(1)).parse());
                continue;
            }
            list.add(string);
        }
        list = this.conjoinJspsOption(list);
        return list.toArray(new String[list.size()]);
    }

    public static void main(String[] stringArray) throws Exception {
        new Appc(stringArray).run();
    }
}

