/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.library.LibraryManager;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.connector.external.RAComplianceChecker;
import weblogic.connector.external.RAComplianceException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.ejb.spi.EJBC;
import weblogic.ejb.spi.EJBCFactory;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.jms.module.JMSParser;
import weblogic.logging.Loggable;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.jsp.JspcInvoker;
import weblogic.servlet.utils.WarUtils;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.BadOptionException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class AppcUtils {
    private static final boolean debug = false;
    public static final String WEBINF_CLASSES = File.separatorChar + "WEB-INF" + File.separatorChar + "classes";

    private AppcUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void expandJarFileIntoDirectory(File file, File file2) throws ToolFailureException {
        VirtualJarFile virtualJarFile = null;
        try {
            try {
                virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                AppcUtils.expandJarFileIntoDirectory(virtualJarFile, file2);
            }
            catch (IOException iOException) {
                AppcUtils.handleIOException(iOException, file2);
                Object var5_4 = null;
                IOUtils.forceClose(virtualJarFile);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.forceClose(virtualJarFile);
            throw throwable;
        }
        IOUtils.forceClose(virtualJarFile);
    }

    public static void expandJarFileIntoDirectory(VirtualJarFile virtualJarFile, File file) throws ToolFailureException {
        try {
            JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
        }
        catch (IOException iOException) {
            AppcUtils.handleIOException(iOException, file);
        }
    }

    private static void handleIOException(IOException iOException, File file) throws ToolFailureException {
        throw new ToolFailureException(J2EELogger.logAppcErrorCopyingFilesLoggable((String)file.getAbsolutePath(), (String)iOException.toString()).getMessage(), (Throwable)iOException);
    }

    public static File makeOutputDir(String string, File file, boolean bl) throws ToolFailureException {
        File file2 = null;
        file2 = file != null ? new File(file, string) : new File(string);
        if (!file2.exists()) {
            if (!file2.mkdirs()) {
                Loggable loggable = J2EELogger.logAppcCouldNotCreateDirectoryLoggable((String)file2.getAbsolutePath());
                throw new ToolFailureException(loggable.getMessage());
            }
        } else {
            if (!file2.canWrite()) {
                Loggable loggable = J2EELogger.logAppcCanNotWriteToDirectoryLoggable((String)file2.getAbsolutePath());
                throw new ToolFailureException(loggable.getMessage());
            }
            if (bl) {
                FileUtils.remove((File)file2, (FileFilter)FileUtils.STAR);
            }
        }
        return file2;
    }

    public static void setDDs(ApplicationDescriptor applicationDescriptor, CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            compilerCtx.setApplicationDescriptor(applicationDescriptor);
        }
        catch (IOException iOException) {
            EarUtils.handleParsingError(iOException, compilerCtx.getSourceName());
        }
        catch (XMLStreamException xMLStreamException) {
            EarUtils.handleParsingError(xMLStreamException, compilerCtx.getSourceName());
        }
    }

    public static void createOutputArchive(String string, File file) throws ToolFailureException {
        if (string.endsWith("xml")) {
            return;
        }
        File file2 = new File(string);
        File file3 = null;
        if (file2.exists()) {
            file3 = AppcUtils.backupJar(file2);
        }
        try {
            JarFileUtils.createJarFileFromDirectory((String)string, (File)file);
            if (file3 != null) {
                file3.delete();
            }
            FileUtils.remove((File)file);
        }
        catch (Exception exception) {
            if (file2.exists()) {
                file2.delete();
            }
            if (file3 != null && file3.exists()) {
                file3.renameTo(file2);
                Loggable loggable = J2EELogger.logAppcUnableToCreateOutputArchiveRestoreLoggable((String)file2.getAbsolutePath(), (String)exception.toString());
                throw new ToolFailureException(loggable.getMessage(), (Throwable)exception);
            }
            Loggable loggable = J2EELogger.logAppcUnableToCreateOutputArchiveLoggable((String)file2.getAbsolutePath(), (String)exception.toString());
            throw new ToolFailureException(loggable.getMessage(), (Throwable)exception);
        }
    }

    private static File backupJar(File file) throws ToolFailureException {
        File file2 = new File(file + "SAVE");
        if (file2.exists() && !file2.delete()) {
            Loggable loggable = J2EELogger.logAppcUnableToDeleteBackupArchiveLoggable((String)file2.getAbsolutePath());
            throw new ToolFailureException(loggable.getMessage());
        }
        try {
            FileUtils.copy((File)file, (File)file2);
        }
        catch (IOException iOException) {
            Loggable loggable = J2EELogger.logAppcUnableToCreateBackupArchiveLoggable((String)file2.getAbsolutePath(), (String)iOException.toString());
            throw new ToolFailureException(loggable.getMessage(), (Throwable)iOException);
        }
        if (!file.delete()) {
            Loggable loggable = J2EELogger.logAppcUnableToDeleteArchiveLoggable((String)file.getAbsolutePath());
            throw new ToolFailureException(loggable.getMessage());
        }
        return file2;
    }

    public static GenericClassLoader getClassLoaderForApplication(ClassFinder classFinder, CompilerCtx compilerCtx, String string) {
        GenericClassLoader genericClassLoader = AppcUtils.getClassLoader(classFinder, new HashSet(), compilerCtx);
        genericClassLoader.setAnnotation(new Annotation(string));
        return genericClassLoader;
    }

    public static GenericClassLoader getClassLoaderForModule(ClassFinder classFinder, CompilerCtx compilerCtx, String string, String string2) {
        GenericClassLoader genericClassLoader = AppcUtils.getClassLoader(classFinder, new HashSet(), compilerCtx);
        genericClassLoader.setAnnotation(new Annotation(string, string2));
        return genericClassLoader;
    }

    private static GenericClassLoader getClassLoader(ClassFinder classFinder, Set set, CompilerCtx compilerCtx) {
        FilteringClassLoader filteringClassLoader = null;
        String string = compilerCtx.getClasspathArg();
        filteringClassLoader = string != null ? new FilteringClassLoader((ClassLoader)new GenericClassLoader((ClassFinder)new ClasspathClassFinder2(string, set))) : new FilteringClassLoader(Thread.currentThread().getContextClassLoader());
        GenericClassLoader genericClassLoader = new GenericClassLoader(classFinder, (ClassLoader)filteringClassLoader);
        try {
            compilerCtx.getOpts().setOption("classpath", genericClassLoader.getClassPath());
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        return genericClassLoader;
    }

    static void compileEJB(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, File file3, ModuleValidationInfo moduleValidationInfo, Getopt2 getopt2) throws ErrorCollectionException {
        Getopt2 getopt22 = (Getopt2)getopt2.clone();
        try {
            getopt22.setOption("d", file3.getPath());
            if (getopt22.containsOption("k")) {
                getopt22.removeOption("k");
            }
            if (getopt22.containsOption("manifest")) {
                getopt22.removeOption("manifest");
            }
            if (getopt22.containsOption("ignorePlanValidation")) {
                getopt22.removeOption("ignorePlanValidation");
            }
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        EJBC eJBC = EJBCFactory.createEJBC(getopt22);
        eJBC.compileEJB(genericClassLoader, virtualJarFile, file, file2, deploymentPlanBean, moduleValidationInfo);
    }

    static void compileRAR(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, ModuleValidationInfo moduleValidationInfo, CompilerCtx compilerCtx) throws RAComplianceException {
        RAComplianceChecker.factory.createChecker().validate(genericClassLoader, virtualJarFile, file, file2, deploymentPlanBean);
    }

    static void compileWAR(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, File file3, ModuleValidationInfo moduleValidationInfo, CompilerCtx compilerCtx) throws ToolFailureException {
        Getopt2 getopt2 = compilerCtx.getOpts();
        LibraryManager libraryManager = WebAppLibraryUtils.getEmptyWebAppLibraryManager(virtualJarFile.getName());
        compilerCtx.getApplicationContext().getLibraryManagerAggregate().addLibraryManager(virtualJarFile.getName(), libraryManager);
        try {
            if (compilerCtx.getPartialOutputTarget() != null) {
                getopt2.setOption("d", compilerCtx.getPartialOutputTarget());
            } else {
                getopt2.setOption("d", file3.getPath() + WEBINF_CLASSES);
            }
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        JspcInvoker jspcInvoker = new JspcInvoker(getopt2);
        try {
            jspcInvoker.compile(genericClassLoader, virtualJarFile, file, file2, deploymentPlanBean, moduleValidationInfo, libraryManager);
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)virtualJarFile.getName(), (String)errorCollectionException.toString()).getMessage(), (Throwable)errorCollectionException);
        }
    }

    public static File getNamedTempDir(String string, boolean bl) {
        File file = new File(System.getProperty("java.io.tmpdir"), string);
        if (bl) {
            FileUtils.remove((File)file);
        }
        file.mkdirs();
        return file;
    }

    static void mergeWAR(VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, File file3, String string) throws ToolFailureException {
        WebAppDescriptor webAppDescriptor = WarUtils.getWebAppDescriptor(file, virtualJarFile, file2, deploymentPlanBean, string);
        WeblogicWebAppBean weblogicWebAppBean = WarUtils.getWlWebAppBean(webAppDescriptor);
        LibraryManager libraryManager = WebAppLibraryUtils.getWebAppLibraryManager(weblogicWebAppBean, string);
        if (libraryManager.hasReferencedLibraries()) {
            File file4 = AppcUtils.getNamedTempDir("warmerge", true);
            try {
                WebAppLibraryUtils.copyWebAppLibraries(libraryManager, file4, file3);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("for webapp with uri " + string + ", webapp library merge failed", (Throwable)iOException);
            }
            WebAppLibraryUtils.removeLibraryReferences(weblogicWebAppBean);
        }
        AppcUtils.writeWarDescriptors(webAppDescriptor, file3, string);
    }

    public static void writeDescriptor(File file, String string, DescriptorBean descriptorBean) throws ToolFailureException {
        if (descriptorBean != null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            File file2 = new File(file, string);
            try {
                DescriptorUtils.writeDescriptor((DescriptorManager)editableDescriptorManager, descriptorBean, file2);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to write descriptor " + string + " to " + file2.getAbsolutePath(), (Throwable)iOException);
            }
        }
    }

    static void writeWarDescriptors(WebAppDescriptor webAppDescriptor, File file, String string) throws ToolFailureException {
        try {
            webAppDescriptor.writeDescriptors(file);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Error processing web " + string + " deployment descriptors", (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Error processing web " + string + " deployment descriptors", (Throwable)xMLStreamException);
        }
    }

    static void compileJMS(File file, DeploymentPlanBean deploymentPlanBean, File file2, String string, Getopt2 getopt2) throws ToolFailureException {
        try {
            getopt2.setOption("d", file2.getPath());
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        try {
            JMSBean jMSBean = JMSParser.createJMSDescriptor(string);
        }
        catch (Exception exception) {
            String string2 = null;
            Throwable throwable = exception.getCause();
            string2 = throwable != null ? throwable.getMessage() : exception.getMessage();
            Exception exception2 = new Exception("ERROR: Failed to compile JMS module " + string + ": " + string2);
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)string, (String)exception2.toString()).getMessage(), (Throwable)exception2);
        }
    }

    static void compileJDBC(File file, DeploymentPlanBean deploymentPlanBean, File file2, String string, Getopt2 getopt2) throws ToolFailureException {
        try {
            getopt2.setOption("d", file2.getPath());
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        try {
            JDBCDeploymentHelper jDBCDeploymentHelper = new JDBCDeploymentHelper();
            JDBCDataSourceBean jDBCDataSourceBean = jDBCDeploymentHelper.createJDBCDataSourceDescriptor(string);
        }
        catch (Exception exception) {
            String string2 = null;
            Throwable throwable = exception.getCause();
            string2 = throwable != null ? throwable.getMessage() : exception.getMessage();
            Exception exception2 = new Exception("ERROR: Failed to compile JDBC module " + string + ": " + string2);
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)string, (String)exception2.toString()).getMessage(), (Throwable)exception2);
        }
    }

    static VirtualJarFile getVirtualJarFile(File file) throws ToolFailureException {
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
        }
        catch (IOException iOException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)file.getAbsolutePath(), (String)iOException.toString()).getMessage(), (Throwable)iOException);
        }
        return virtualJarFile;
    }
}

