/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.application.io.Ear;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.utils.classloaders.ClassFinder;

public class BuildtimeApplicationContext
extends ApplicationContextImpl
implements ApplicationContextInternal {
    private final CompilerCtx ctx;
    private final Map uriLinks = new HashMap();

    BuildtimeApplicationContext(CompilerCtx compilerCtx) {
        super(compilerCtx.getSourceName(), compilerCtx.getSourceFile(), Thread.currentThread().getContextClassLoader());
        this.ctx = compilerCtx;
    }

    public ApplicationBean getApplicationDD() {
        return this.ctx.getApplicationDD();
    }

    public void registerLink(File file) throws IOException {
        this.registerLink(file.getName(), file);
    }

    public void registerLink(String string, File file) throws IOException {
        EarUtils.linkURI(this.ctx.getEar(), this.getApplicationFileManager(), string, file);
        this.uriLinks.put(string, file);
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.ctx.getApplicationDescriptor();
    }

    public File getURILink(String string) {
        return (File)this.uriLinks.get(string);
    }

    public boolean isLibraryURI(String string) {
        return this.uriLinks.containsKey(string);
    }

    public ClassFinder getClassFinder() {
        return this.getAppClassLoader().getClassFinder();
    }

    public void notifyDescriptorUpdate() throws LoggableLibraryProcessingException {
        LibraryUtils.resetAppDDs(this.ctx.getApplicationDescriptor(), this.ctx);
    }

    public Ear getEar() {
        return this.ctx.getEar();
    }

    public SubDeploymentMBean[] getLibrarySubDeployments() {
        return null;
    }
}

