/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.DescriptorUpdater;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.EARModule;
import weblogic.application.internal.FlowContext;
import weblogic.application.io.Ear;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deployment.PersistenceUnitViewer;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.utils.Getopt2;
import weblogic.utils.jars.VirtualJarFile;

public final class CompilerCtx
implements DescriptorUpdater {
    private Getopt2 opts;
    private VirtualJarFile vSource;
    private File sourceFile;
    private File outputDir;
    private String classpathArg;
    private String targetArchive;
    private boolean isSplitDir = false;
    private boolean verbose;
    private EARModule[] modules = null;
    private EARModule[] customModules = null;
    private ApplicationDescriptor appDesc;
    private ApplicationBean appDD;
    private WeblogicApplicationBean wlappDD;
    private WeblogicExtensionBean wlExtDD;
    private Ear ear = null;
    private FlowContext appCtx = null;
    private String planName;
    private File planFile;
    private DeploymentPlanBean plan;
    private File configDir;
    private Map factoryMap = Collections.EMPTY_MAP;
    private boolean readOnlyInvocation = false;
    private boolean verifyLibraryReferences = true;
    private boolean mergedDisabled = false;
    private File tempDir = null;
    private boolean unregisterLibrariesOnExit = true;
    private PersistenceUnitViewer perViewer = null;
    private boolean basicView = false;
    private String partialOutputTarget = null;
    private WebLogicDeployableObjectFactory objectFactory = null;
    private EditableDeployableObject deployableApplication = null;
    private boolean writeInferredDescriptors = false;
    private File manifestFile = null;
    private String lightWeightAppName = null;

    public Getopt2 getOpts() {
        return this.opts;
    }

    public void setOpts(Getopt2 getopt2) {
        this.opts = getopt2;
    }

    public VirtualJarFile getVSource() {
        return this.vSource;
    }

    public void setVSource(VirtualJarFile virtualJarFile) {
        this.vSource = virtualJarFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public String getSourceName() {
        return this.sourceFile.getName();
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public String getClasspathArg() {
        return this.classpathArg;
    }

    public void setClasspathArg(String string) {
        this.classpathArg = string;
    }

    public String getTargetArchive() {
        return this.targetArchive;
    }

    public void setTargetArchive(String string) {
        this.targetArchive = string;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public ApplicationBean getApplicationDD() {
        return this.appDD;
    }

    public WeblogicApplicationBean getWLApplicationDD() {
        return this.wlappDD;
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.appDesc;
    }

    public void setApplicationDescriptor(ApplicationDescriptor applicationDescriptor) throws IOException, XMLStreamException {
        this.appDesc = applicationDescriptor;
        this.appDD = applicationDescriptor.getApplicationDescriptor();
        this.wlappDD = applicationDescriptor.getWeblogicApplicationDescriptor();
        this.wlExtDD = applicationDescriptor.getWeblogicExtensionDescriptor();
    }

    public WeblogicExtensionBean getWLExtensionDD() {
        return this.wlExtDD;
    }

    public void createApplicationContext() {
        if (this.appCtx == null) {
            this.appCtx = new BuildtimeApplicationContext(this);
        }
    }

    public FlowContext getApplicationContext() {
        return this.appCtx;
    }

    public void setModules(EARModule[] eARModuleArray) {
        this.modules = eARModuleArray;
    }

    public EARModule[] getModules() {
        return this.modules;
    }

    public boolean isSplitDir() {
        return this.isSplitDir;
    }

    public void setSplitDir() {
        this.isSplitDir = true;
    }

    public void setEar(Ear ear) {
        if (this.ear != null) {
            throw new AssertionError((Object)"An EAR can't be set twice on this Context");
        }
        this.ear = ear;
        this.getApplicationContext().addClassFinder(ear.getClassFinder());
    }

    public Ear getEar() {
        return this.ear;
    }

    public void setPlanFile(File file) {
        this.planFile = file;
    }

    public File getPlanFile() {
        return this.planFile;
    }

    public void setPlanName(String string) {
        this.planName = string;
    }

    public String getPlanName() {
        return this.planName;
    }

    public void setPlanBean(DeploymentPlanBean deploymentPlanBean) {
        this.plan = deploymentPlanBean;
    }

    public DeploymentPlanBean getPlanBean() {
        return this.plan;
    }

    public void setConfigDir(File file) {
        this.configDir = file;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public Map getCustomModuleFactories() {
        return this.factoryMap;
    }

    public void setCustomModuleFactories(Map map) {
        this.factoryMap = map;
    }

    public EARModule[] getCustomModules() {
        return this.customModules;
    }

    public void setCustomModules(EARModule[] eARModuleArray) {
        this.customModules = eARModuleArray;
    }

    public WebLogicDeployableObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory) {
        this.objectFactory = webLogicDeployableObjectFactory;
    }

    public boolean isReadOnlyInvocation() {
        return this.readOnlyInvocation;
    }

    public void setReadOnlyInvocation() {
        this.readOnlyInvocation = true;
    }

    public EditableDeployableObject getDeployableApplication() {
        return this.deployableApplication;
    }

    public void setDeployableApplication(EditableDeployableObject editableDeployableObject) {
        this.deployableApplication = editableDeployableObject;
    }

    public boolean verifyLibraryReferences() {
        return this.verifyLibraryReferences;
    }

    public void setVerifyLibraryReferences(boolean bl) {
        this.verifyLibraryReferences = bl;
    }

    public void disableLibraryMerge() {
        this.mergedDisabled = true;
    }

    public boolean isMergeDisabled() {
        return this.mergedDisabled;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File file) {
        this.tempDir = file;
    }

    public boolean isWriteInferredDescriptors() {
        return this.writeInferredDescriptors;
    }

    public void setWriteInferredDescriptors() {
        this.writeInferredDescriptors = true;
    }

    public void setManifestFile(File file) {
        this.manifestFile = file;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setPerViewer(PersistenceUnitViewer persistenceUnitViewer) {
        this.perViewer = persistenceUnitViewer;
    }

    public PersistenceUnitViewer getPerViewer() {
        return this.perViewer;
    }

    public void keepLibraryRegistrationOnExit() {
        this.unregisterLibrariesOnExit = false;
    }

    public boolean unregisterLibrariesOnExit() {
        return this.unregisterLibrariesOnExit;
    }

    public void setBasicView() {
        this.basicView = true;
    }

    public boolean isBasicView() {
        return this.basicView;
    }

    public void setLightWeightAppName(String string) {
        this.lightWeightAppName = string;
    }

    public String getLightWeightAppName() {
        return this.lightWeightAppName;
    }

    public String getPartialOutputTarget() {
        return this.partialOutputTarget;
    }

    public void setPartialOutputTarget(String string) {
        this.partialOutputTarget = string;
    }
}

