/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARCompiler;
import weblogic.application.compiler.EARMerger;
import weblogic.application.compiler.EarReader;
import weblogic.application.compiler.EarWithoutCMReader;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ReadOnlyEarMerger;
import weblogic.application.utils.EarUtils;

public final class EARCompilerFactory
implements CompilerFactory,
MergerFactory {
    public Compiler createCompiler(CompilerCtx compilerCtx, File file) {
        return EarUtils.isEar(file) ? new EARCompiler(compilerCtx) : null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) {
        if (EarUtils.isEar(file)) {
            if (compilerCtx.isReadOnlyInvocation()) {
                if (compilerCtx.isMergeDisabled()) {
                    if (compilerCtx.isBasicView()) {
                        return new EarWithoutCMReader(compilerCtx);
                    }
                    return new EarReader(compilerCtx);
                }
                return new ReadOnlyEarMerger(compilerCtx);
            }
            return new EARMerger(compilerCtx);
        }
        return null;
    }
}

