/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.FlowDriver;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.flow.ApplicationViewerFlow;
import weblogic.application.compiler.flow.CheckLibraryReferenceFlow;
import weblogic.application.compiler.flow.CleanupModulesFlow;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.compiler.flow.CopyLibrariesFlow;
import weblogic.application.compiler.flow.CustomModuleFlow;
import weblogic.application.compiler.flow.CustomModuleProviderFlow;
import weblogic.application.compiler.flow.DescriptorParsingFlow;
import weblogic.application.compiler.flow.EarClassLoaderFlow;
import weblogic.application.compiler.flow.ExplodeModulesFlow;
import weblogic.application.compiler.flow.ImportLibrariesFlow;
import weblogic.application.compiler.flow.InitModulesFlow;
import weblogic.application.compiler.flow.LibraryDirectoryFlow;
import weblogic.application.compiler.flow.MergeModuleFlow;
import weblogic.application.compiler.flow.ModuleClassLoaderFlow;
import weblogic.application.compiler.flow.PrepareModulesFlow;
import weblogic.application.compiler.flow.VerifyOutputDirFlow;
import weblogic.application.compiler.flow.WriteDescriptorsFlow;
import weblogic.application.compiler.flow.WriteModulesFlow;
import weblogic.utils.compiler.ToolFailureException;

class EARMerger
implements Merger {
    private final FlowDriver.CompilerFlowDriver driver;

    EARMerger(CompilerCtx compilerCtx) {
        CompilerFlow[] compilerFlowArray = new CompilerFlow[]{new EarClassLoaderFlow(compilerCtx), new VerifyOutputDirFlow(compilerCtx), new DescriptorParsingFlow(compilerCtx), new ImportLibrariesFlow(compilerCtx), new LibraryDirectoryFlow(compilerCtx), new CheckLibraryReferenceFlow(compilerCtx, compilerCtx.verifyLibraryReferences()), new CustomModuleProviderFlow(compilerCtx), new InitModulesFlow(compilerCtx), new PrepareModulesFlow(compilerCtx), new CopyLibrariesFlow(compilerCtx), new ModuleClassLoaderFlow(compilerCtx), new CustomModuleFlow(compilerCtx), new ExplodeModulesFlow(compilerCtx, true), new CleanupModulesFlow(compilerCtx), new MergeModuleFlow(compilerCtx), new WriteModulesFlow(compilerCtx), new WriteDescriptorsFlow(compilerCtx), new ApplicationViewerFlow(compilerCtx)};
        this.driver = new FlowDriver.CompilerFlowDriver(compilerFlowArray);
    }

    public void merge() throws ToolFailureException {
        this.driver.compile();
    }

    public void cleanup() throws ToolFailureException {
        this.driver.cleanup();
    }
}

