/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.utils.IOUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.module.WLDFModule;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public abstract class EARModule {
    protected static final boolean debug = false;
    private boolean isArchive;
    private boolean needsPackaging;
    private File outputDir;
    private String outputFileName;
    private final String moduleURI;
    private VirtualJarFile vjf;
    private final String altDD;
    private File altDDFile;
    private final ModuleValidationInfo mvi;
    private final Map<String, DescriptorBean> descriptors = new Hashtable<String, DescriptorBean>();
    protected GenericClassLoader moduleClassLoader = null;
    public static String ORIGINAL_DESCRIPTOR_SUFFIX = ".orig";
    public static final String WL_DIAG_URI = "META-INF/weblogic-diagnostics.xml";

    public EARModule(String string, String string2) {
        this.moduleURI = string;
        this.altDD = string2;
        this.mvi = new ModuleValidationInfo(string);
    }

    public abstract void compile(GenericClassLoader var1, CompilerCtx var2) throws ToolFailureException;

    public abstract ClassFinder getClassFinder();

    public ClassFinder getResourceFinder() {
        return null;
    }

    public void initModuleClassLoader(CompilerCtx compilerCtx, GenericClassLoader genericClassLoader) throws ToolFailureException {
        this.moduleClassLoader = genericClassLoader != null ? new GenericClassLoader(this.getClassFinder(), (ClassLoader)genericClassLoader) : new GenericClassLoader(this.getClassFinder());
        this.moduleClassLoader.setAnnotation(new Annotation(compilerCtx.getApplicationContext().getApplicationId(), this.getURI()));
    }

    public GenericClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public abstract void populateMVI(GenericClassLoader var1, CompilerCtx var2) throws ToolFailureException;

    public ModuleValidationInfo getModuleValidationInfo() {
        return this.mvi;
    }

    public boolean isLibrary() {
        return false;
    }

    public void setAltDDFile(File file) {
        this.altDDFile = file;
    }

    public File getAltDDFile() {
        return this.altDDFile;
    }

    public boolean isSplitDir(CompilerCtx compilerCtx) {
        if (compilerCtx == null || compilerCtx.getApplicationContext() == null || compilerCtx.getApplicationContext().getApplicationFileManager() == null) {
            return false;
        }
        return compilerCtx.getApplicationContext().getApplicationFileManager().isSplitDirectory();
    }

    public String getURI() {
        return this.moduleURI;
    }

    public String getAltDD() {
        return this.altDD;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public void setArchive(boolean bl) {
        this.isArchive = bl;
    }

    public boolean needsPackaging() {
        return this.needsPackaging;
    }

    public void setNeedsPackaging(boolean bl) {
        this.needsPackaging = bl;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string;
    }

    public VirtualJarFile getVirtualJarFile() {
        return this.vjf;
    }

    public void setVirtualJarFile(VirtualJarFile virtualJarFile) {
        this.vjf = virtualJarFile;
    }

    public void cleanup() {
        IOUtils.forceClose(this.vjf);
        this.vjf = null;
        if (this.moduleClassLoader != null) {
            this.moduleClassLoader.close();
        }
    }

    public void writeDescriptors(CompilerCtx compilerCtx) throws ToolFailureException {
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
    }

    public void write(CompilerCtx compilerCtx) throws ToolFailureException {
        this.writeDescriptors(compilerCtx);
    }

    public String toString() {
        return this.getURI();
    }

    protected void addRootBean(String string, DescriptorBean descriptorBean) {
        this.descriptors.put(string, descriptorBean);
    }

    public String[] getDescriptorUris() {
        return this.descriptors.keySet().toArray(new String[0]);
    }

    public DescriptorBean getRootBean(String string) {
        return this.descriptors.get(string);
    }

    public DescriptorBean getRootBean() {
        return null;
    }

    public abstract ModuleType getModuleType();

    protected void processAnnotations() throws ClassNotFoundException, ErrorCollectionException, NoSuchMethodException, NoClassDefFoundError {
    }

    protected final void processAnnotations(CompilerCtx compilerCtx) throws ToolFailureException {
        if (!compilerCtx.isBasicView() && (compilerCtx.isReadOnlyInvocation() || compilerCtx.isWriteInferredDescriptors())) {
            try {
                this.processAnnotations();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.throwAnnotationProcessingException(compilerCtx, classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.throwAnnotationProcessingException(compilerCtx, noSuchMethodException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.throwAnnotationProcessingException(compilerCtx, noClassDefFoundError);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.throwAnnotationProcessingException(compilerCtx, errorCollectionException);
            }
        }
    }

    private void throwAnnotationProcessingException(CompilerCtx compilerCtx, Throwable throwable) throws ToolFailureException {
        if (compilerCtx.verifyLibraryReferences()) {
            throwable.printStackTrace();
            throw new ToolFailureException("Unable to process annotations for module " + this.getURI(), throwable);
        }
        throwable.printStackTrace();
    }

    protected void addDiagnosticDDRootBean(CompilerCtx compilerCtx) {
        File file = this.getExternalDiagnosticDescriptorFile(compilerCtx, this);
        try {
            DescriptorBean descriptorBean;
            DescriptorBean descriptorBean2 = descriptorBean = file != null ? WLDFModule.getDescriptorBean(file, compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI(), WL_DIAG_URI) : WLDFModule.getDescriptorBean(this.getVirtualJarFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI(), WL_DIAG_URI);
            if (descriptorBean != null) {
                this.addRootBean(WL_DIAG_URI, descriptorBean);
            } else if (compilerCtx.getEar() == null) {
                this.addRootBean(WL_DIAG_URI, new DescriptorManager().createDescriptorRoot(WLDFResourceBean.class).getRootBean());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getExternalDiagnosticDescriptorFile(CompilerCtx compilerCtx, EARModule eARModule) {
        DeploymentPlanBean deploymentPlanBean = compilerCtx.getPlanBean();
        File file = compilerCtx.getConfigDir();
        if (deploymentPlanBean != null) {
            ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                if (!moduleOverrideBeanArray[i].getModuleName().equals(eARModule.getURI()) || !moduleOverrideBeanArray[i].getModuleType().equals(eARModule.getModuleType().toString())) continue;
                ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
                for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                    File file2;
                    if (!moduleDescriptorBeanArray[j].isExternal() || !moduleDescriptorBeanArray[j].getRootElement().equals("wldf-resource") || !(file2 = new File(file, moduleDescriptorBeanArray[j].getUri())).isFile() || !file2.exists()) continue;
                    return file2;
                }
            }
        }
        return null;
    }
}

