/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.EJBCompiler;
import weblogic.application.compiler.EJBMerger;
import weblogic.application.compiler.EJBModule;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ModuleFactory;
import weblogic.application.compiler.ReadOnlyEjbMerger;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.ejb.spi.EJBJarUtils;
import weblogic.j2ee.descriptor.ModuleBean;

final class EJBCompilerFactory
implements CompilerFactory,
MergerFactory,
ModuleFactory,
StandaloneModuleFactory {
    EJBCompilerFactory() {
    }

    public Compiler createCompiler(CompilerCtx compilerCtx, File file) throws IOException {
        return EJBJarUtils.isEJB(file) ? new EJBCompiler(compilerCtx) : null;
    }

    public EARModule createModule(ModuleBean moduleBean) {
        if (moduleBean.getEjb() == null) {
            return null;
        }
        return new EJBModule(moduleBean.getEjb(), moduleBean.getAltDd());
    }

    public EARModule createModule(CompilerCtx compilerCtx, File file) {
        try {
            if (EJBJarUtils.isEJB(file)) {
                return new EJBModule(compilerCtx.getSourceName(), null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) throws IOException {
        if (EJBJarUtils.isEJB(file)) {
            if (compilerCtx.isReadOnlyInvocation()) {
                return new ReadOnlyEjbMerger(compilerCtx);
            }
            return new EJBMerger(compilerCtx);
        }
        return null;
    }
}

