/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.WSEEModuleHelper;
import weblogic.application.utils.PersistenceUtils;
import weblogic.deployment.PersistenceUnitViewer;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.ejb.container.cmp.rdbms.RDBMSDescriptor;
import weblogic.ejb.container.cmp11.rdbms.Deployer;
import weblogic.ejb.container.cmp11.rdbms.RDBMSDeploymentInfo;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.spi.EJBC;
import weblogic.ejb.spi.EJBCFactory;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.kernel.Kernel;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.compiler.jdt.JDTJavaCompilerFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.deploy.WSEEDescriptor;
import weblogic.wsee.policy.deployment.WsPolicyDescriptor;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public class EJBModule
extends EARModule {
    MultiClassFinder moduleClassFinder = new MultiClassFinder();
    EjbDescriptorBean desc;
    private WSEEModuleHelper wseeHelper;
    public static final String WSEE_EJB_URI_81 = "META-INF/web-services.xml";

    public EJBModule(String string, String string2) {
        super(string, string2);
    }

    public ClassFinder getClassFinder() {
        return this.moduleClassFinder;
    }

    public void initModuleClassLoader(CompilerCtx compilerCtx, GenericClassLoader genericClassLoader) throws ToolFailureException {
        Object object;
        this.moduleClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(this.getOutputDir().getPath()));
        if (this.isSplitDir(compilerCtx)) {
            object = compilerCtx.getEar().getModuleRoots(this.getURI());
            for (int i = 0; i < ((File[])object).length; ++i) {
                this.moduleClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(object[i].getAbsolutePath()));
            }
        }
        if (genericClassLoader != null) {
            try {
                PersistenceUtils.addRootPersistenceJars(compilerCtx.getApplicationContext().getAppClassLoader(), compilerCtx.getApplicationContext().getApplicationId(), compilerCtx.getApplicationDD());
                object = new PersistenceUnitViewer.ResourceViewer(compilerCtx.getApplicationContext().getAppClassLoader(), compilerCtx.getApplicationContext().getApplicationId(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean());
                ((PersistenceUnitViewer)object).loadDescriptors();
                compilerCtx.setPerViewer((PersistenceUnitViewer)object);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to load persistence descriptors", (Throwable)iOException);
            }
            genericClassLoader.addClassFinder((ClassFinder)this.moduleClassFinder);
            this.moduleClassLoader = new GenericClassLoader((ClassLoader)genericClassLoader);
        } else {
            this.moduleClassLoader = new GenericClassLoader((ClassFinder)this.moduleClassFinder);
        }
        this.moduleClassLoader.setAnnotation(new Annotation(compilerCtx.getApplicationContext().getApplicationId(), this.getURI()));
    }

    public void compile(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        if (compilerCtx.isVerbose() && !Kernel.isServer()) {
            System.setProperty("weblogic.debug.DebugEjbCompilation", "true");
        }
        try {
            AppcUtils.compileEJB(genericClassLoader, this.getVirtualJarFile(), this.getAltDDFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getOutputDir(), this.getModuleValidationInfo(), compilerCtx.getOpts());
            if (compilerCtx.getModules().length == 1) {
                JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)genericClassLoader);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.getURI(), (String)errorCollectionException.toString()).getMessage(), (Throwable)errorCollectionException);
        }
        try {
            this.desc = EjbDescriptorFactory.createDescriptorFromJarFile(this.getVirtualJarFile(), this.getAltDDFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), null, this.getURI());
        }
        catch (XMLParsingException xMLParsingException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)((Object)xMLParsingException));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)((Object)xMLProcessingException));
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)xMLStreamException);
        }
        if (compilerCtx.isWriteInferredDescriptors() && (this.desc.getEjbJarBean() == null || !this.desc.getEjbJarBean().isMetadataComplete())) {
            this.wseeHelper = new WSEEModuleHelper(compilerCtx, this.getVirtualJarFile(), this.getURI(), false);
            this.backupDescriptors();
            this.processAnnotations(compilerCtx);
            this.writeDescriptors(compilerCtx);
        }
    }

    public void cleanup() {
        super.cleanup();
        this.moduleClassFinder.close();
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            this.desc = EjbDescriptorFactory.createDescriptorFromJarFile(this.getVirtualJarFile(), this.getAltDDFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), null, this.getURI());
            this.wseeHelper = new WSEEModuleHelper(compilerCtx, this.getVirtualJarFile(), this.getURI(), false);
            if (compilerCtx.isWriteInferredDescriptors() && (this.desc.getEjbJarBean() == null || !this.desc.getEjbJarBean().isMetadataComplete())) {
                this.backupDescriptors();
            }
            this.processAnnotations(compilerCtx);
            if (this.desc.getEjbJarBean() != null) {
                this.addRootBean("META-INF/ejb-jar.xml", (DescriptorBean)this.desc.getEjbJarBean());
            }
            if (this.desc.getWeblogicEjbJarBean() != null && !this.desc.isWeblogicEjbJarSynthetic()) {
                this.addRootBean("META-INF/weblogic-ejb-jar.xml", (DescriptorBean)this.desc.getWeblogicEjbJarBean());
            }
            PersistenceUnitViewer.EntryViewer entryViewer = new PersistenceUnitViewer.EntryViewer(this.getVirtualJarFile(), this.getURI(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean());
            ((PersistenceUnitViewer)entryViewer).loadDescriptors();
            Iterator iterator = entryViewer.getDescriptorURIs();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object3 = entryViewer.getDescriptor((String)object4);
                this.addRootBean((String)object4, object3.getRootBean());
            }
            if (this.wseeHelper.getWsBean() != null) {
                this.addRootBean("META-INF/webservices.xml", (DescriptorBean)this.wseeHelper.getWsBean());
            }
            if (this.wseeHelper.getWlWsBean() != null) {
                this.addRootBean("META-INF/weblogic-webservices.xml", (DescriptorBean)this.wseeHelper.getWlWsBean());
            }
            try {
                if (this.getVirtualJarFile().getEntry(WSEE_EJB_URI_81) != null) {
                    object4 = new WSEEDescriptor(new File(this.getOutputDir(), WSEE_EJB_URI_81), null, null, null);
                    this.addRootBean(WSEE_EJB_URI_81, (DescriptorBean)((WSEEDescriptor)object4).getWebservicesBean());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object4 = new WsPolicyDescriptor(this.getVirtualJarFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI());
            try {
                if (((WsPolicyDescriptor)object4).getWebservicesPolicyBean() != null) {
                    this.addRootBean("META-INF/weblogic-webservices-policy.xml", (DescriptorBean)((WsPolicyDescriptor)object4).getWebservicesPolicyBean());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = new HashMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Set set = EJBDescriptorMBeanUtils.getCMPEJBNames(this.desc);
            for (String string2 : set) {
                DescriptorBean descriptorBean;
                string = null;
                object2 = EJBDescriptorMBeanUtils.getPersistenceMBean(string2, this.desc);
                if (object2 != null && (object = object2.getPersistenceUse()) != null) {
                    string = object.getTypeStorage();
                }
                if (string == null) continue;
                object = this.getVirtualJarFile().getEntry(string);
                if (object != null) {
                    object3.put(string, object);
                    hashMap.put(string, string2);
                    continue;
                }
                File file = new File(new File(compilerCtx.getConfigDir(), this.getURI()), string);
                if (!file.exists() || (descriptorBean = this.parseWLSCMPDescriptor(file)) == null) continue;
                this.addRootBean(string, descriptorBean);
            }
            for (String string2 : object3.keySet()) {
                string = null;
                object2 = (ZipEntry)object3.get(string2);
                if (this.isSchemaBasedDD((ZipEntry)object2)) {
                    object = new RDBMSDescriptor(this.getVirtualJarFile(), string2, null, this.getURI(), compilerCtx.getPlanBean(), compilerCtx.getConfigDir());
                    string = ((RDBMSDescriptor)object).getDescriptorBean();
                } else {
                    string = this.xpiParseWLSCMPDescriptor((ZipEntry)object2, string2, (String)hashMap.get(string2));
                }
                if (string == null) continue;
                this.addRootBean(string2, (DescriptorBean)string);
            }
            this.addDiagnosticDDRootBean(compilerCtx);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)iOException);
        }
        catch (XMLParsingException xMLParsingException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)((Object)xMLParsingException));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)((Object)xMLProcessingException));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)xMLStreamException);
        }
        catch (ProcessorFactoryException processorFactoryException) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)((Object)processorFactoryException));
        }
        catch (Exception exception) {
            throw new ToolFailureException("Unable to parse EJB descriptor", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DescriptorBean parseWLSCMPDescriptor(File file) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            DescriptorBean descriptorBean = editableDescriptorManager.createDescriptor((InputStream)bufferedInputStream).getRootBean();
            Object var6_5 = null;
            this.closeAndIgnore(bufferedInputStream);
            return descriptorBean;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closeAndIgnore(bufferedInputStream);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DescriptorBean xpiParseWLSCMPDescriptor(ZipEntry zipEntry, String string, String string2) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.getVirtualJarFile().getInputStream(zipEntry));
            DescriptorBean descriptorBean = (DescriptorBean)weblogic.ejb.container.cmp.rdbms.Deployer.parseXMLFile(bufferedInputStream, string, this.desc, null);
            Object var10_7 = null;
            this.closeAndIgnore(bufferedInputStream);
            return descriptorBean;
        }
        catch (RDBMSException rDBMSException) {
            try {
                Deployer deployer = new Deployer();
                RDBMSDeploymentInfo rDBMSDeploymentInfo = deployer.parseXMLFile(this.getVirtualJarFile(), string, string2, new ProcessorFactory(), this.desc);
                DescriptorBean descriptorBean = (DescriptorBean)rDBMSDeploymentInfo.getWeblogicRdbmsJarBean();
                Object var10_8 = null;
                this.closeAndIgnore(bufferedInputStream);
                return descriptorBean;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.closeAndIgnore(bufferedInputStream);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSchemaBasedDD(ZipEntry zipEntry) throws IOException, ProcessorFactoryException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.getVirtualJarFile().getInputStream(zipEntry));
            boolean bl = weblogic.ejb.container.cmp.rdbms.Deployer.isSchemaBasedDD(bufferedInputStream);
            Object var5_4 = null;
            this.closeAndIgnore(bufferedInputStream);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeAndIgnore(bufferedInputStream);
            throw throwable;
        }
    }

    private void closeAndIgnore(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean wseeAnnotationsEnabled(EjbJarBean ejbJarBean) {
        String string = ((DescriptorBean)ejbJarBean).getDescriptor().getOriginalVersionInfo();
        if (string != null) {
            try {
                return ejbJarBean.getVersion() != null && (double)Float.parseFloat(string) >= 3.0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    protected void processAnnotations() throws ClassNotFoundException, ErrorCollectionException, NoSuchMethodException, NoClassDefFoundError {
        EjbJarBean ejbJarBean = this.desc.getEjbJarBean();
        if (ejbJarBean == null || this.desc.isEjb30() && !ejbJarBean.isMetadataComplete()) {
            Method method;
            Method method2;
            Object obj;
            SessionBeanBean[] sessionBeanBeanArray;
            EnterpriseBeansBean enterpriseBeansBean;
            this.desc.setEjb30(true);
            try {
                enterpriseBeansBean = Class.forName("weblogic.ejb.container.dd.xml.EjbAnnotationProcessor");
                sessionBeanBeanArray = enterpriseBeansBean.getConstructor(GenericClassLoader.class);
                obj = sessionBeanBeanArray.newInstance(this.getModuleClassLoader());
                method2 = enterpriseBeansBean.getDeclaredMethod("processAnnotations", EjbDescriptorBean.class, VirtualJarFile.class);
                method = enterpriseBeansBean.getDeclaredMethod("processWLSAnnotations", EjbDescriptorBean.class, ClassLoader.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            try {
                method2.invoke(obj, this.desc, this.getVirtualJarFile());
                method.invoke(obj, this.desc, this.getModuleClassLoader());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
            }
            catch (InvocationTargetException invocationTargetException) {
                sessionBeanBeanArray = invocationTargetException.getTargetException();
                if (sessionBeanBeanArray instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)sessionBeanBeanArray;
                }
                if (sessionBeanBeanArray instanceof ErrorCollectionException) {
                    throw (ErrorCollectionException)sessionBeanBeanArray;
                }
                if (sessionBeanBeanArray instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)sessionBeanBeanArray;
                }
                if (sessionBeanBeanArray instanceof NoClassDefFoundError) {
                    throw (NoClassDefFoundError)sessionBeanBeanArray;
                }
                invocationTargetException.printStackTrace();
                throw new AssertionError((Object)"Unable to invoke Annotation processoror");
            }
            if (this.wseeAnnotationsEnabled(this.desc.getEjbJarBean())) {
                enterpriseBeansBean = this.desc.getEjbJarBean().getEnterpriseBeans();
                if (enterpriseBeansBean == null) {
                    return;
                }
                sessionBeanBeanArray = this.desc.getEjbJarBean().getEnterpriseBeans().getSessions();
                String[][] stringArray = new String[sessionBeanBeanArray.length][2];
                for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
                    stringArray[i][0] = sessionBeanBeanArray[i].getEjbName();
                    stringArray[i][1] = sessionBeanBeanArray[i].getEjbClass();
                }
                this.wseeHelper.processAnnotations(this.getVirtualJarFile(), (ClassLoader)this.getModuleClassLoader(), stringArray);
            }
        }
    }

    public void populateMVI(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        EJBC eJBC = EJBCFactory.createEJBC(compilerCtx.getOpts());
        try {
            eJBC.populateValidationInfo(genericClassLoader, this.getVirtualJarFile(), this.getAltDDFile(), this.getModuleValidationInfo());
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new ToolFailureException(J2EELogger.logAppcUnableToContinueProcessingFileLoggable((String)compilerCtx.getSourceFile().getAbsolutePath(), (String)errorCollectionException.toString()).getMessage(), (Throwable)errorCollectionException);
        }
    }

    public void writeDescriptors(CompilerCtx compilerCtx) throws ToolFailureException {
        if (compilerCtx.isWriteInferredDescriptors()) {
            this.desc.getEjbJarBean().setMetadataComplete(true);
        }
        AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/ejb-jar.xml", (DescriptorBean)this.desc.getEjbJarBean());
        AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/weblogic-ejb-jar.xml", (DescriptorBean)this.desc.getWeblogicEjbJarBean());
        AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/webservices.xml", (DescriptorBean)this.wseeHelper.getWsBean());
        AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/weblogic-webservices.xml", (DescriptorBean)this.wseeHelper.getWlWsBean());
    }

    public DescriptorBean getRootBean() {
        return this.getRootBean("META-INF/ejb-jar.xml");
    }

    public ModuleType getModuleType() {
        return ModuleType.EJB;
    }

    private void backupDescriptors() throws ToolFailureException {
        if (this.getVirtualJarFile().getEntry("META-INF/weblogic-ejb-jar.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/weblogic-ejb-jar.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.desc.getWeblogicEjbJarBean());
        }
        if (this.getVirtualJarFile().getEntry("META-INF/ejb-jar.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/ejb-jar.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.desc.getEjbJarBean());
        }
        if (this.getVirtualJarFile().getEntry("META-INF/webservices.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/webservices.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.wseeHelper.getWsBean());
        }
        if (this.getVirtualJarFile().getEntry("META-INF/weblogic-webservices.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "META-INF/weblogic-webservices.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.wseeHelper.getWlWsBean());
        }
    }
}

