/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.application.utils.StateMachineDriver;
import weblogic.utils.compiler.ToolFailureException;

class FlowDriver {
    private static final String DEFAULT_ERROR = "weblogic.appc failed";
    private final FlowStateChange fsc = new FlowStateChange();
    private final StateMachineDriver driver = new StateMachineDriver();

    void run(CompilerFlow[] compilerFlowArray) throws ToolFailureException {
        this.nextState(compilerFlowArray);
        this.previousState(compilerFlowArray);
    }

    void nextState(CompilerFlow[] compilerFlowArray) throws ToolFailureException {
        try {
            this.driver.nextState(this.fsc, compilerFlowArray);
        }
        catch (StateChangeException stateChangeException) {
            FlowDriver.handleStateChangeException(stateChangeException);
        }
    }

    void previousState(CompilerFlow[] compilerFlowArray) throws ToolFailureException {
        try {
            this.driver.previousState(this.fsc, compilerFlowArray);
        }
        catch (StateChangeException stateChangeException) {
            FlowDriver.handleStateChangeException(stateChangeException);
        }
    }

    private static void handleStateChangeException(StateChangeException stateChangeException) throws ToolFailureException {
        Throwable throwable = FlowDriver.getCause(stateChangeException);
        if (throwable instanceof ToolFailureException) {
            throw (ToolFailureException)throwable;
        }
        throw new ToolFailureException(throwable.getMessage() == null ? DEFAULT_ERROR : throwable.getMessage(), throwable);
    }

    private static Throwable getCause(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable;
        }
        return FlowDriver.getCause(throwable.getCause());
    }

    public static class CompilerFlowDriver
    extends FlowDriver {
        CompilerFlow[] flows;

        public CompilerFlowDriver(CompilerFlow[] compilerFlowArray) {
            this.flows = compilerFlowArray;
        }

        public void compile() throws ToolFailureException {
            this.nextState(this.flows);
        }

        public void cleanup() throws ToolFailureException {
            this.previousState(this.flows);
        }
    }

    private static final class FlowStateChange
    implements StateChange {
        private FlowStateChange() {
        }

        public void next(Object object) throws Exception {
            ((CompilerFlow)object).compile();
        }

        public void previous(Object object) throws Exception {
            ((CompilerFlow)object).cleanup();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            System.err.println("Error cleaning up " + stateChangeException);
            stateChangeException.printStackTrace();
        }
    }
}

