/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.logging.Loggable;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.ToolFailureException;

final class JDBCCompiler
implements Compiler {
    private final CompilerCtx ctx;
    private BuildtimeApplicationContext libCtx = null;

    JDBCCompiler(CompilerCtx compilerCtx) {
        this.ctx = compilerCtx;
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    public void compile() throws ToolFailureException {
        File file;
        File file2 = this.ctx.getOutputDir();
        File file3 = file = this.ctx.getSourceFile();
        if (!file.equals(file2)) {
            file3 = this.getModuleFile(file.getName(), file2);
        }
        try {
            File file4 = this.ctx.getConfigDir();
            DeploymentPlanBean deploymentPlanBean = this.ctx.getPlanBean();
            FileUtils.copy((File)file, (File)file3);
            AppcUtils.compileJDBC(file4, deploymentPlanBean, file2, file3.getPath(), this.ctx.getOpts());
        }
        catch (Exception exception) {
            Loggable loggable = J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.ctx.getSourceFile().getAbsolutePath(), (String)exception.toString());
            throw new ToolFailureException(loggable.getMessage(), (Throwable)exception);
        }
    }

    private File getModuleFile(String string, File file) {
        if (this.libCtx.getURILink(string) != null) {
            return this.libCtx.getURILink(string);
        }
        return new File(file, string);
    }
}

