/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.JDBCCompiler;
import weblogic.application.compiler.JDBCMerger;
import weblogic.application.compiler.JDBCModule;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.application.compiler.WLModuleFactory;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;

final class JDBCCompilerFactory
implements CompilerFactory,
MergerFactory,
WLModuleFactory,
StandaloneModuleFactory {
    JDBCCompilerFactory() {
    }

    public Compiler createCompiler(CompilerCtx compilerCtx, File file) {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jdbc.xml")) {
            return new JDBCCompiler(compilerCtx);
        }
        return null;
    }

    public EARModule createModule(WeblogicModuleBean weblogicModuleBean) {
        if (!weblogicModuleBean.getType().equals("JDBC")) {
            return null;
        }
        String string = weblogicModuleBean.getPath();
        String string2 = null;
        JDBCModule jDBCModule = new JDBCModule(string, string2);
        jDBCModule.setModuleName(weblogicModuleBean.getName());
        return jDBCModule;
    }

    public EARModule createModule(CompilerCtx compilerCtx, File file) {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jdbc.xml")) {
            return new JDBCModule(file.getPath(), null);
        }
        return null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) throws IOException {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jdbc.xml")) {
            return new JDBCMerger(compilerCtx);
        }
        return null;
    }
}

