/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.WLSModule;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;

public class JDBCModule
extends WLSModule {
    private EditableDescriptorManager edm;

    public JDBCModule(String string, String string2) {
        super(string, string2);
        if (this.edm != null) {
            return;
        }
        this.edm = new EditableDescriptorManager();
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            JDBCDeploymentHelper jDBCDeploymentHelper = new JDBCDeploymentHelper();
            JDBCDataSourceBean jDBCDataSourceBean = null;
            jDBCDataSourceBean = compilerCtx.getEar() != null ? jDBCDeploymentHelper.createJDBCDataSourceDescriptor((DescriptorManager)this.edm, this.getCL(this.getURI()), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), compilerCtx.getEar().getURI(), this.getURI()) : jDBCDeploymentHelper.createJDBCDataSourceDescriptor((DescriptorManager)this.edm, this.getCL(this.getURI()), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI(), this.getURI());
            if (jDBCDataSourceBean != null) {
                this.addRootBean(this.getURI(), (DescriptorBean)jDBCDataSourceBean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populateMVI(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            JDBCDeploymentHelper jDBCDeploymentHelper = new JDBCDeploymentHelper();
            JDBCDataSourceBean jDBCDataSourceBean = jDBCDeploymentHelper.createJDBCDataSourceDescriptor(this.getOutputFileName());
            this.getModuleValidationInfo().setJDBCDataSourceBean(jDBCDataSourceBean);
            if (compilerCtx.isVerbose() && jDBCDataSourceBean != null) {
                JDBCDeploymentHelper.writeModuleAsXML((DescriptorBean)jDBCDataSourceBean);
            }
        }
        catch (Exception exception) {
            String string = null;
            Throwable throwable = exception.getCause();
            string = throwable != null ? throwable.getMessage() : exception.getMessage();
            Exception exception2 = new Exception("Failed to compile JDBC module " + this.getOutputFileName() + ": " + string);
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.getOutputFileName(), (String)exception2.toString()).getMessage(), (Throwable)exception2);
        }
    }

    public ModuleType getModuleType() {
        return WebLogicModuleType.JDBC;
    }
}

