/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.JMSCompiler;
import weblogic.application.compiler.JMSMerger;
import weblogic.application.compiler.JMSModule;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.application.compiler.WLModuleFactory;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;

final class JMSCompilerFactory
implements CompilerFactory,
MergerFactory,
WLModuleFactory,
StandaloneModuleFactory {
    JMSCompilerFactory() {
    }

    public Compiler createCompiler(CompilerCtx compilerCtx, File file) {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jms.xml")) {
            return new JMSCompiler(compilerCtx);
        }
        return null;
    }

    public EARModule createModule(WeblogicModuleBean weblogicModuleBean) {
        if (!weblogicModuleBean.getType().equals("JMS")) {
            return null;
        }
        String string = weblogicModuleBean.getPath();
        String string2 = null;
        JMSModule jMSModule = new JMSModule(string, string2);
        jMSModule.setModuleName(weblogicModuleBean.getName());
        return jMSModule;
    }

    public EARModule createModule(CompilerCtx compilerCtx, File file) {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jms.xml")) {
            return new JMSModule(file.getPath(), null);
        }
        return null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) throws IOException {
        if (file.isDirectory()) {
            return null;
        }
        if (file.getName().endsWith("-jms.xml")) {
            return new JMSMerger(compilerCtx);
        }
        return null;
    }
}

