/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.WLSModule;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.module.JMSParser;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;

public class JMSModule
extends WLSModule {
    private EditableDescriptorManager edm;

    public JMSModule(String string, String string2) {
        super(string, string2);
        if (this.edm != null) {
            return;
        }
        this.edm = new EditableDescriptorManager();
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            JMSBean jMSBean = null;
            jMSBean = compilerCtx.getEar() != null ? JMSParser.createJMSDescriptor((DescriptorManager)this.edm, this.getCL(this.getURI()), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), compilerCtx.getEar().getURI(), this.getURI()) : JMSParser.createJMSDescriptor((DescriptorManager)this.edm, this.getCL(this.getURI()), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI(), this.getURI());
            if (jMSBean != null) {
                this.addRootBean(this.getURI(), (DescriptorBean)jMSBean);
            }
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to parse JMS descriptor", (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Unable to parse JMS descriptor", (Throwable)xMLStreamException);
        }
    }

    public void populateMVI(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            JMSBean jMSBean = JMSParser.createJMSDescriptor(this.getOutputFileName());
            this.getModuleValidationInfo().setJMSBean(jMSBean);
            if (compilerCtx.isVerbose() && jMSBean != null) {
                DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
            }
        }
        catch (Exception exception) {
            String string = null;
            Throwable throwable = exception.getCause();
            string = throwable != null ? throwable.getMessage() : exception.getMessage();
            Exception exception2 = new Exception("Failed to compile JMS module " + this.getOutputFileName() + ": " + string);
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.getOutputFileName(), (String)exception2.toString()).getMessage(), (Throwable)exception2);
        }
    }

    public ModuleType getModuleType() {
        return WebLogicModuleType.JMS;
    }
}

