/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.utils.IOUtils;
import weblogic.connector.external.RAComplianceException;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.logging.Loggable;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

final class RARCompiler
implements Compiler {
    private final CompilerCtx ctx;
    private File outputDir = null;
    private File sourceFile = null;
    private File config = null;
    private DeploymentPlanBean plan = null;
    private VirtualJarFile vSource = null;

    RARCompiler(CompilerCtx compilerCtx) {
        this.ctx = compilerCtx;
    }

    private void setup() throws ToolFailureException {
        block4: {
            this.outputDir = this.ctx.getOutputDir();
            this.sourceFile = this.ctx.getSourceFile();
            this.config = this.ctx.getConfigDir();
            this.plan = this.ctx.getPlanBean();
            if (!this.sourceFile.equals(this.outputDir)) {
                AppcUtils.expandJarFileIntoDirectory(this.sourceFile, this.outputDir);
            }
            try {
                this.vSource = AppcUtils.getVirtualJarFile(this.ctx.getSourceFile());
            }
            catch (Exception exception) {
                IOUtils.forceClose(this.vSource);
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (!(exception instanceof ToolFailureException)) break block4;
                throw (ToolFailureException)((Object)exception);
            }
        }
    }

    public void compile() throws ToolFailureException {
        this.setup();
        String string = this.outputDir.getPath();
        File file = null;
        ModuleValidationInfo moduleValidationInfo = null;
        this.ctx.setTargetArchive(null);
        GenericClassLoader genericClassLoader = AppcUtils.getClassLoaderForApplication((ClassFinder)new ClasspathClassFinder2(string), this.ctx, this.ctx.getApplicationContext().getApplicationId());
        try {
            block5: {
                try {
                    if (this.vSource.isDirectory()) {
                        AppcUtils.compileRAR(genericClassLoader, this.vSource, file, this.config, this.plan, moduleValidationInfo, this.ctx);
                        break block5;
                    }
                    AppcUtils.expandJarFileIntoDirectory(this.vSource, this.outputDir);
                    VirtualJarFile virtualJarFile = AppcUtils.getVirtualJarFile(this.outputDir);
                    AppcUtils.compileRAR(genericClassLoader, virtualJarFile, file, this.config, this.plan, moduleValidationInfo, this.ctx);
                }
                catch (RAComplianceException rAComplianceException) {
                    Loggable loggable = J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.ctx.getSourceFile().getAbsolutePath(), (String)rAComplianceException.toString());
                    throw new ToolFailureException(loggable.getMessage(), (Throwable)rAComplianceException);
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            genericClassLoader.close();
            IOUtils.forceClose(this.vSource);
            throw throwable;
        }
        genericClassLoader.close();
        IOUtils.forceClose(this.vSource);
    }
}

