/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ModuleFactory;
import weblogic.application.compiler.RARCompiler;
import weblogic.application.compiler.RARMerger;
import weblogic.application.compiler.RARModule;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.connector.utils.RarUtils;
import weblogic.j2ee.descriptor.ModuleBean;

final class RARCompilerFactory
implements CompilerFactory,
MergerFactory,
ModuleFactory,
StandaloneModuleFactory {
    RARCompilerFactory() {
    }

    public Compiler createCompiler(CompilerCtx compilerCtx, File file) throws IOException {
        return RarUtils.isRar(file) ? new RARCompiler(compilerCtx) : null;
    }

    public EARModule createModule(ModuleBean moduleBean) {
        if (moduleBean.getConnector() == null) {
            return null;
        }
        return new RARModule(moduleBean.getConnector(), moduleBean.getAltDd());
    }

    public EARModule createModule(CompilerCtx compilerCtx, File file) {
        return RarUtils.isRar(file) ? new RARModule(compilerCtx.getSourceName(), null) : null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) throws IOException {
        return RarUtils.isRar(file) ? new RARMerger(compilerCtx) : null;
    }
}

