/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.FlowDriver;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.flow.ApplicationViewerFlow;
import weblogic.application.compiler.flow.CheckLibraryReferenceFlow;
import weblogic.application.compiler.flow.CleanupModulesFlow;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.compiler.flow.CustomModuleFlow;
import weblogic.application.compiler.flow.CustomModuleProviderFlow;
import weblogic.application.compiler.flow.DescriptorParsingFlow;
import weblogic.application.compiler.flow.EarClassLoaderFlow;
import weblogic.application.compiler.flow.ImportLibrariesFlow;
import weblogic.application.compiler.flow.InitModulesFlow;
import weblogic.application.compiler.flow.LibraryDirectoryFlow;
import weblogic.application.compiler.flow.MergeModuleFlow;
import weblogic.application.compiler.flow.ModuleClassLoaderFlow;
import weblogic.application.compiler.flow.PrepareModulesFlow;
import weblogic.utils.compiler.ToolFailureException;

public class ReadOnlyEarMerger
implements Merger {
    private final FlowDriver.CompilerFlowDriver driver;

    ReadOnlyEarMerger(CompilerCtx compilerCtx) {
        this.driver = new FlowDriver.CompilerFlowDriver(this.getFlows(compilerCtx));
    }

    protected CompilerFlow[] getFlows(CompilerCtx compilerCtx) {
        return new CompilerFlow[]{new EarClassLoaderFlow(compilerCtx), new DescriptorParsingFlow(compilerCtx), new ImportLibrariesFlow(compilerCtx), new LibraryDirectoryFlow(compilerCtx), new CheckLibraryReferenceFlow(compilerCtx, compilerCtx.verifyLibraryReferences()), new CustomModuleProviderFlow(compilerCtx), new InitModulesFlow(compilerCtx), new PrepareModulesFlow(compilerCtx), new ModuleClassLoaderFlow(compilerCtx), new CustomModuleFlow(compilerCtx), new CleanupModulesFlow(compilerCtx), new MergeModuleFlow(compilerCtx), new ApplicationViewerFlow(compilerCtx)};
    }

    public void merge() throws ToolFailureException {
        this.driver.compile();
    }

    public void cleanup() throws ToolFailureException {
        this.driver.cleanup();
    }
}

