/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EarReader;
import weblogic.application.compiler.FlowDriver;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.compiler.flow.SCACompositeViewerFlow;
import weblogic.application.utils.IOUtils;
import weblogic.application.utils.ModuleDiscovery;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

final class SCAMerger
extends EarReader {
    private final FlowDriver.CompilerFlowDriver driver;
    private final CompilerCtx ctx;

    SCAMerger(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.ctx = compilerCtx;
        CompilerFlow[] compilerFlowArray = new CompilerFlow[]{new SCACompositeViewerFlow(compilerCtx)};
        this.driver = new FlowDriver.CompilerFlowDriver(compilerFlowArray);
    }

    public void merge() throws ToolFailureException {
        if (this.containsJ2EEModules()) {
            super.merge();
        }
        this.driver.compile();
    }

    private boolean containsJ2EEModules() throws ToolFailureException {
        Getopt2 getopt2 = this.ctx.getOpts();
        String[] stringArray = getopt2.args();
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("more than one argument specified!");
        }
        try {
            File file = new File(stringArray[0]).getCanonicalFile();
            this.ctx.setSourceFile(file);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            this.ctx.setVSource(virtualJarFile);
            ApplicationBean applicationBean = ModuleDiscovery.discoverModules(this.ctx.getVSource());
            return applicationBean != null;
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Error processing source " + stringArray[0], (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ToolFailureException {
        try {
            super.cleanup();
            this.driver.cleanup();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            IOUtils.forceClose(this.ctx.getVSource());
            throw throwable;
        }
        IOUtils.forceClose(this.ctx.getVSource());
    }
}

