/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weblogic.application.compiler.CARCompilerFactory;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARCompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.EJBCompilerFactory;
import weblogic.application.compiler.JDBCCompilerFactory;
import weblogic.application.compiler.JMSCompilerFactory;
import weblogic.application.compiler.LightWeightCompilerFactory;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ModuleFactory;
import weblogic.application.compiler.RARCompilerFactory;
import weblogic.application.compiler.SCACompilerFactory;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.application.compiler.WARCompilerFactory;
import weblogic.application.compiler.WLModuleFactory;
import weblogic.j2ee.descriptor.ModuleBean;

public class ToolsFactoryManager {
    public static CompilerFactory[] compilerFactories = new CompilerFactory[]{new LightWeightCompilerFactory(), new SCACompilerFactory(), new EARCompilerFactory(), new WARCompilerFactory(), new RARCompilerFactory(), new JMSCompilerFactory(), new JDBCCompilerFactory(), new EJBCompilerFactory(), new CARCompilerFactory()};
    public static MergerFactory[] mergerFactories = new MergerFactory[]{new LightWeightCompilerFactory(), new SCACompilerFactory(), new EARCompilerFactory(), new WARCompilerFactory(), new RARCompilerFactory(), new JMSCompilerFactory(), new JDBCCompilerFactory(), new EJBCompilerFactory(), new CARCompilerFactory()};
    private static ModuleFactory[] defaultModuleFactories = new ModuleFactory[]{new WARCompilerFactory(), new RARCompilerFactory(), new EJBCompilerFactory()};
    private static final List<ModuleFactory> overridingModuleFactories = new ArrayList<ModuleFactory>();
    private static ModuleFactory[] moduleFactories;
    public static WLModuleFactory[] wlmoduleFactories;
    private static StandaloneModuleFactory[] defaultStandAloneModuleFactories;
    private static final List<StandaloneModuleFactory> overridingStandAloneModuleFactories;
    private static StandaloneModuleFactory[] standAloneModuleFactories;

    public static void addModuleFactory(ModuleFactory moduleFactory) {
        overridingModuleFactories.add(moduleFactory);
    }

    public static EARModule createModule(ModuleBean moduleBean) {
        if (moduleFactories == null) {
            ArrayList<ModuleFactory> arrayList = new ArrayList<ModuleFactory>();
            arrayList.addAll(overridingModuleFactories);
            arrayList.addAll(Arrays.asList(defaultModuleFactories));
            moduleFactories = arrayList.toArray(new ModuleFactory[0]);
        }
        for (int i = 0; i < moduleFactories.length; ++i) {
            EARModule eARModule = moduleFactories[i].createModule(moduleBean);
            if (eARModule == null) continue;
            return eARModule;
        }
        return null;
    }

    public static void addStandaloneModuleFactory(StandaloneModuleFactory standaloneModuleFactory) {
        overridingStandAloneModuleFactories.add(standaloneModuleFactory);
    }

    public static EARModule createStandaloneModule(CompilerCtx compilerCtx, File file) {
        if (standAloneModuleFactories == null) {
            ArrayList<StandaloneModuleFactory> arrayList = new ArrayList<StandaloneModuleFactory>();
            arrayList.addAll(overridingStandAloneModuleFactories);
            arrayList.addAll(Arrays.asList(defaultStandAloneModuleFactories));
            standAloneModuleFactories = arrayList.toArray(new StandaloneModuleFactory[0]);
        }
        for (int i = 0; i < standAloneModuleFactories.length; ++i) {
            EARModule eARModule = standAloneModuleFactories[i].createModule(compilerCtx, file);
            if (eARModule == null) continue;
            return eARModule;
        }
        return null;
    }

    static {
        wlmoduleFactories = new WLModuleFactory[]{new JMSCompilerFactory(), new JDBCCompilerFactory()};
        defaultStandAloneModuleFactories = new StandaloneModuleFactory[]{new WARCompilerFactory(), new RARCompilerFactory(), new JMSCompilerFactory(), new JDBCCompilerFactory(), new EJBCompilerFactory(), new CARCompilerFactory()};
        overridingStandAloneModuleFactories = new ArrayList<StandaloneModuleFactory>();
    }
}

