/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ModuleFactory;
import weblogic.application.compiler.ReadOnlyWarMerger;
import weblogic.application.compiler.StandaloneModuleFactory;
import weblogic.application.compiler.WARCompiler;
import weblogic.application.compiler.WARMerger;
import weblogic.application.compiler.WARModule;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.servlet.utils.WarUtils;

final class WARCompilerFactory
implements CompilerFactory,
MergerFactory,
ModuleFactory,
StandaloneModuleFactory {
    WARCompilerFactory() {
    }

    public Compiler createCompiler(CompilerCtx compilerCtx, File file) throws IOException {
        return WarUtils.isWar(file) ? new WARCompiler(compilerCtx) : null;
    }

    public EARModule createModule(ModuleBean moduleBean) {
        if (moduleBean.getWeb() == null) {
            return null;
        }
        return new WARModule(moduleBean.getWeb().getWebUri(), moduleBean.getAltDd(), moduleBean.getWeb().getContextRoot());
    }

    public EARModule createModule(CompilerCtx compilerCtx, File file) {
        try {
            if (WarUtils.isWar(file)) {
                return new WARModule(compilerCtx.getSourceName(), null, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Merger createMerger(CompilerCtx compilerCtx, File file) throws IOException {
        if (WarUtils.isWar(file)) {
            if (compilerCtx.isReadOnlyInvocation()) {
                return new ReadOnlyWarMerger(compilerCtx);
            }
            return new WARMerger(compilerCtx);
        }
        return null;
    }
}

