/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ParentModule;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.WSEEModuleHelper;
import weblogic.application.compiler.flow.ApplicationViewerFlow;
import weblogic.application.io.Ear;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.utils.CompositeWebAppFinder;
import weblogic.application.utils.CustomModuleManager;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.application.utils.PathUtils;
import weblogic.deployment.PersistenceUnitViewer;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.FaceConfigCacheHelper;
import weblogic.servlet.internal.TldCacheHelper;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAnnotationProcessor;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.internal.WebAppHelper;
import weblogic.servlet.jsp.JspcInvoker;
import weblogic.servlet.utils.WarUtils;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.BadOptionException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.wsee.deploy.WSEEDescriptor;
import weblogic.wsee.policy.deployment.WsPolicyDescriptor;

public class WARModule
extends EARModule
implements ParentModule {
    GenericClassLoader wcl;
    private CustomModuleManager customModuleManager = null;
    protected WebAppBean webBean;
    private WeblogicWebAppBean wlBean;
    private ExplodedJar moduleWar = null;
    private File moduleExtractDir = null;
    private War libraryWar = null;
    private CompositeWebAppFinder moduleClassFinder = new CompositeWebAppFinder();
    private CompositeWebAppFinder resourceFinder = new CompositeWebAppFinder();
    private String contextRoot;
    private PersistenceUnitViewer perViewer;
    private WSEEModuleHelper wseeHelper;
    public static final String WL_EXT_URI = "WEB-INF/weblogic-extension.xml";
    public static final String WSEE_WEB_URI_81 = "WEB-INF/web-services.xml";

    public WARModule(String string, String string2, String string3) {
        super(string, string2);
        this.contextRoot = string3;
    }

    public String getDescriptorURI() {
        return "WEB-INF";
    }

    public ClassFinder getClassFinder() {
        return this.moduleClassFinder;
    }

    public ClassFinder getResourceFinder() {
        return this.resourceFinder;
    }

    public CustomModuleManager getCustomModuleManager() {
        return this.customModuleManager;
    }

    private File getExtractDir(CompilerCtx compilerCtx) throws ToolFailureException {
        Ear ear = compilerCtx.getEar();
        String string = ear == null ? this.getURI() : ear.getURI();
        String string2 = this.getURI();
        File file = compilerCtx.getTempDir();
        File file2 = new File(file, string);
        if (file2.exists() && !file2.isDirectory()) {
            file2.delete();
        }
        File file3 = new File(file, PathUtils.generateTempPath(null, string, string2));
        boolean bl = false;
        bl = file3.exists() ? file3.canWrite() : file3.mkdirs();
        if (!bl) {
            throw new ToolFailureException("Unable to generate temporary directory for module: " + file3.getAbsolutePath());
        }
        return file3;
    }

    public void initModuleClassLoader(CompilerCtx compilerCtx, GenericClassLoader genericClassLoader) throws ToolFailureException {
        try {
            String[] stringArray;
            this.moduleExtractDir = this.getExtractDir(compilerCtx);
            this.moduleWar = this.isArchive() ? new ExplodedJar(this.getURI(), this.moduleExtractDir, this.getVirtualJarFile().getRootFiles()[0], War.WAR_CLASSPATH_INFO) : new ExplodedJar(this.getURI(), this.moduleExtractDir, this.getVirtualJarFile().getRootFiles(), War.WAR_CLASSPATH_INFO, JarCopyFilter.NOCOPY_FILTER);
            this.moduleClassFinder.addFinder(this.moduleWar.getClassFinder());
            SplitDirectoryInfo splitDirectoryInfo = compilerCtx.getApplicationContext().getSplitDirectoryInfo();
            if (splitDirectoryInfo != null && (stringArray = splitDirectoryInfo.getWebAppClasses(this.getURI())) != null && stringArray.length > 0) {
                this.moduleClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(StringUtils.join((String[])stringArray, (String)File.pathSeparator)));
            }
            this.resourceFinder.addFinder(new ApplicationViewerFlow.ApplicationResourceFinder(this.getURI(), this.moduleWar.getClassFinder()));
            super.initModuleClassLoader(compilerCtx, genericClassLoader);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to load web module at uri " + this.getURI(), (Throwable)iOException);
        }
    }

    public void populateMVI(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        JspcInvoker jspcInvoker = new JspcInvoker(compilerCtx.getOpts());
        try {
            jspcInvoker.checkCompliance(genericClassLoader, this.getVirtualJarFile(), this.getAltDDFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getModuleValidationInfo(), compilerCtx.isVerbose());
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.getVirtualJarFile().getName(), (String)errorCollectionException.toString()).getMessage(), (Throwable)errorCollectionException);
        }
    }

    public void compile(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        this.wcl = genericClassLoader;
        this.wcl.addClassFinder((ClassFinder)this.moduleClassFinder);
        try {
            compilerCtx.getOpts().setOption("classpath", this.wcl.getClassPath());
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Object)badOptionException);
        }
        if (!this.getVirtualJarFile().isDirectory()) {
            IOUtils.forceClose(this.getVirtualJarFile());
            this.setVirtualJarFile(AppcUtils.getVirtualJarFile(this.getOutputDir()));
        }
        WebAppDescriptor webAppDescriptor = WarUtils.getWebAppDescriptor(this.getAltDDFile(), this.getVirtualJarFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI());
        this.processLibraries(compilerCtx, webAppDescriptor);
        if (WarUtils.configureFCL(this.wlBean, compilerCtx.getApplicationContext().getAppClassLoader(), compilerCtx.getEar() == null)) {
            J2EELogger.logFilteringConfigurationIgnored((String)compilerCtx.getApplicationContext().getApplicationId(), (String)this.getURI());
        }
        AppcUtils.compileWAR(this.wcl, this.getVirtualJarFile(), this.getAltDDFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getOutputDir(), this.getModuleValidationInfo(), compilerCtx);
        if (compilerCtx.isWriteInferredDescriptors() && (this.webBean == null || !this.webBean.isMetadataComplete())) {
            this.wseeHelper = new WSEEModuleHelper(compilerCtx, this.getVirtualJarFile(), this.getURI(), true);
            this.backupDescriptors();
            this.processAnnotations(compilerCtx);
            this.writeDescriptors(compilerCtx);
        }
    }

    public void cleanup() {
        super.cleanup();
        if (this.wcl != null) {
            this.wcl.close();
        }
        this.moduleClassFinder.close();
        this.resourceFinder.close();
        if (this.libraryWar != null) {
            this.libraryWar.closeAllFinders();
        }
        if (this.customModuleManager != null) {
            this.customModuleManager.cleanup();
        }
        if (this.moduleWar != null) {
            this.moduleWar.remove();
        }
    }

    public void writeDescriptors(CompilerCtx compilerCtx) throws ToolFailureException {
        if (compilerCtx.isWriteInferredDescriptors()) {
            this.webBean.setMetadataComplete(true);
        }
        AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/web.xml", (DescriptorBean)this.webBean);
        AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/weblogic.xml", (DescriptorBean)this.wlBean);
        AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/webservices.xml", (DescriptorBean)this.wseeHelper.getWsBean());
        AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/weblogic-webservices.xml", (DescriptorBean)this.wseeHelper.getWlWsBean());
        AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/weblogic-webservices-policy.xml", this.getRootBean("WEB-INF/weblogic-webservices-policy.xml"));
    }

    private void processDDs(CompilerCtx compilerCtx) {
        Object object;
        if (this.webBean != null) {
            this.addRootBean("WEB-INF/web.xml", (DescriptorBean)this.webBean);
        }
        if (this.wlBean != null) {
            this.addRootBean("WEB-INF/weblogic.xml", (DescriptorBean)this.wlBean);
        }
        if (this.wseeHelper.getWsBean() != null) {
            this.addRootBean("WEB-INF/webservices.xml", (DescriptorBean)this.wseeHelper.getWsBean());
        }
        if (this.wseeHelper.getWlWsBean() != null) {
            this.addRootBean("WEB-INF/weblogic-webservices.xml", (DescriptorBean)this.wseeHelper.getWlWsBean());
        }
        try {
            if (WarUtils.isWebServices(this.moduleExtractDir)) {
                object = new WSEEDescriptor(new File(this.moduleExtractDir, WSEE_WEB_URI_81), null, null, null);
                this.addRootBean(WSEE_WEB_URI_81, (DescriptorBean)((WSEEDescriptor)object).getWebservicesBean());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new WsPolicyDescriptor(this.getVirtualJarFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI(), true);
        try {
            if (((WsPolicyDescriptor)object).getWebservicesPolicyBean() != null) {
                this.addRootBean("WEB-INF/weblogic-webservices-policy.xml", (DescriptorBean)((WsPolicyDescriptor)object).getWebservicesPolicyBean());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addDiagnosticDDRootBean(compilerCtx);
        Iterator iterator = this.perViewer.getDescriptorURIs();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Descriptor descriptor = this.perViewer.getDescriptor(string);
            this.addRootBean(string, descriptor.getRootBean());
        }
    }

    private DescriptorBean mergeDDFromLibraries(War war, WebAppDescriptor webAppDescriptor, String string) throws IOException, XMLStreamException {
        Enumeration enumeration = war.getResourceFinder("/").getSources("/" + string);
        ArrayList<Source> arrayList = Collections.list(enumeration);
        Source[] sourceArray = arrayList.toArray(new Source[0]);
        return webAppDescriptor.mergeLibaryDescriptors(sourceArray, string);
    }

    private void initWebAppLibraryManager(CompilerCtx compilerCtx, LibraryManager libraryManager, WeblogicWebAppBean weblogicWebAppBean, String string) throws ToolFailureException {
        if (weblogicWebAppBean == null) {
            return;
        }
        if (weblogicWebAppBean.getLibraryRefs() == null) {
            return;
        }
        LibraryReference[] libraryReferenceArray = WebAppLibraryUtils.getWebLibRefs(weblogicWebAppBean, string);
        libraryManager.lookup(libraryReferenceArray);
        if (libraryManager.hasUnresolvedReferences()) {
            String string2 = libraryManager.getUnresolvedReferencesError();
            if (compilerCtx.verifyLibraryReferences()) {
                throw new ToolFailureException(string2);
            }
            J2EELogger.logUnresolvedLibraryReferencesWarningLoggable((String)string2).log();
        }
    }

    private void processLibraries(CompilerCtx compilerCtx, WebAppDescriptor webAppDescriptor) throws ToolFailureException {
        this.wlBean = WarUtils.getWlWebAppBean(webAppDescriptor);
        LibraryManager libraryManager = new LibraryManager(WebAppLibraryUtils.getLibraryReferencer(this.getURI()));
        this.initWebAppLibraryManager(compilerCtx, libraryManager, this.wlBean, this.getURI());
        compilerCtx.getApplicationContext().addLibraryManager(this.getURI(), libraryManager);
        try {
            if (libraryManager.hasReferencedLibraries()) {
                this.libraryWar = new War(this.getURI());
                WebAppLibraryUtils.extractWebAppLibraries(libraryManager, this.libraryWar, this.moduleExtractDir);
                this.moduleClassFinder.addLibraryFinder(this.libraryWar.getClassFinder());
                this.resourceFinder.addLibraryFinder(this.libraryWar.getResourceFinder("/"));
                this.webBean = (WebAppBean)this.mergeDDFromLibraries(this.libraryWar, webAppDescriptor, "WEB-INF/web.xml");
                this.wlBean = (WeblogicWebAppBean)this.mergeDDFromLibraries(this.libraryWar, webAppDescriptor, "WEB-INF/weblogic.xml");
            }
            this.webBean = WarUtils.getWebAppBean(webAppDescriptor);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to parse or merge standard web module descriptors", (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Unable to parse or merge standard web module descriptors", (Throwable)xMLStreamException);
        }
    }

    protected void processAnnotations() throws ClassNotFoundException, ErrorCollectionException {
        String[][] stringArray;
        ServletBean[] servletBeanArray;
        if (!WarUtils.isAnnotationEnabled(this.webBean)) {
            return;
        }
        String string = "weblogic.servlet.internal.WebAnnotationProcessorImpl";
        try {
            servletBeanArray = (ServletBean[])Class.forName(string).newInstance();
            stringArray = new WarModuleWebAppHelper();
            servletBeanArray.processAnnotations(this.getModuleClassLoader(), this.webBean, (WebAppHelper)stringArray);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        servletBeanArray = this.webBean.getServlets();
        stringArray = new String[servletBeanArray.length][2];
        for (int i = 0; i < servletBeanArray.length; ++i) {
            stringArray[i][0] = servletBeanArray[i].getServletName();
            stringArray[i][1] = servletBeanArray[i].getServletClass();
        }
        this.wseeHelper.processAnnotations(this.getModuleClassLoader(), stringArray);
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        WebAppDescriptor webAppDescriptor = WarUtils.getWebAppDescriptor(this.getAltDDFile(), this.getVirtualJarFile(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.getURI());
        this.processLibraries(compilerCtx, webAppDescriptor);
        if (WarUtils.configureFCL(this.wlBean, compilerCtx.getApplicationContext().getAppClassLoader(), compilerCtx.getEar() == null)) {
            J2EELogger.logFilteringConfigurationIgnored((String)compilerCtx.getApplicationContext().getApplicationId(), (String)this.getURI());
        }
        EarUtils.handleUnsetContextRoot(this.getURI(), null, compilerCtx.getApplicationDD(), this.wlBean);
        if (!compilerCtx.isBasicView()) {
            this.customModuleManager = new CustomModuleManager(compilerCtx, this, WL_EXT_URI);
            this.customModuleManager.merge(compilerCtx);
        }
        this.perViewer = new PersistenceUnitViewer.ResourceViewer(this.getModuleClassLoader(), this.getURI(), compilerCtx.getConfigDir(), compilerCtx.getPlanBean());
        this.perViewer.loadDescriptors();
        this.wseeHelper = new WSEEModuleHelper(compilerCtx, this.getVirtualJarFile(), this.getURI(), true);
        if (compilerCtx.isWriteInferredDescriptors() && (this.webBean == null || !this.webBean.isMetadataComplete())) {
            this.backupDescriptors();
        }
        this.wseeHelper.mergeDescriptors(this.resourceFinder);
        this.processAnnotations(compilerCtx);
        this.processDDs(compilerCtx);
    }

    public void write(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            if (this.libraryWar != null) {
                WebAppLibraryUtils.writeWar(this.libraryWar, this.getOutputDir());
            }
            if (this.customModuleManager != null) {
                this.customModuleManager.write(compilerCtx);
            }
            this.writeDescriptors(compilerCtx);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to write out web module", (Throwable)iOException);
        }
    }

    public DescriptorBean getRootBean() {
        return this.getRootBean("WEB-INF/web.xml");
    }

    public ModuleType getModuleType() {
        return ModuleType.WAR;
    }

    private void backupDescriptors() throws ToolFailureException {
        if (this.getVirtualJarFile().getEntry("WEB-INF/weblogic.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/weblogic.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.wlBean);
        }
        if (this.getVirtualJarFile().getEntry("WEB-INF/web.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/web.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.webBean);
        }
        if (this.getVirtualJarFile().getEntry("WEB-INF/webservices.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/webservices.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.wseeHelper.getWsBean());
        }
        if (this.getVirtualJarFile().getEntry("WEB-INF/weblogic-webservices.xml") != null) {
            AppcUtils.writeDescriptor(this.getOutputDir(), "WEB-INF/weblogic-webservices.xml" + ORIGINAL_DESCRIPTOR_SUFFIX, (DescriptorBean)this.wseeHelper.getWlWsBean());
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WarModuleWebAppHelper
    implements WebAppHelper {
        private Map tldInfo = null;
        private Set managedBeans = null;
        private List annotatedClasses = null;

        @Override
        public Set getTagListeners(boolean bl) {
            return this.getTagClasses(bl, "listener-class");
        }

        @Override
        public Set getTagHandlers(boolean bl) {
            return this.getTagClasses(bl, "tag-class");
        }

        private Set getTagClasses(boolean bl, String string) {
            Set set = null;
            ClassFinder classFinder = WARModule.this.moduleClassFinder.getWebappFinder();
            Map map = this.getWebTldInfo();
            Collection collection = War.getWebTagClasses(classFinder, map, bl, string);
            set = War.addAllIfNotEmpty(set, collection);
            if (WARModule.this.libraryWar != null) {
                Set set2 = WARModule.this.libraryWar.getLibTagClasses(bl, string);
                set = War.addAllIfNotEmpty(set, (Collection)set2);
            }
            return set == null ? Collections.EMPTY_SET : set;
        }

        @Override
        public Set getManagedBeanClasses() {
            if (!WarUtils.isJsfApplication(WARModule.this.webBean, WARModule.this.wlBean)) {
                return Collections.EMPTY_SET;
            }
            if (this.managedBeans != null) {
                return this.managedBeans;
            }
            String string = WarUtils.getFacesConfigFiles(WARModule.this.webBean);
            List list = War.findFacesConfigs(string, WARModule.this.resourceFinder.getWebappFinder(), WARModule.this.moduleClassFinder.getWebappFinder());
            Set set = FaceConfigCacheHelper.parseFacesConfigs((Collection)list, WARModule.this.moduleExtractDir, WARModule.this.getURI());
            this.managedBeans = War.addAllIfNotEmpty(this.managedBeans, (Collection)set);
            if (WARModule.this.libraryWar != null) {
                Set set2 = WARModule.this.libraryWar.getLibManagedBeans();
                this.managedBeans = War.addAllIfNotEmpty(this.managedBeans, (Collection)set2);
            }
            if (this.managedBeans == null) {
                this.managedBeans = Collections.EMPTY_SET;
            }
            return this.managedBeans;
        }

        @Override
        public Set getManagedBeanClasses(Set<String> set) {
            this.managedBeans = this.getManagedBeanClasses();
            if (this.managedBeans == Collections.EMPTY_SET) {
                this.managedBeans = new HashSet();
            }
            this.managedBeans.addAll(set);
            return this.managedBeans;
        }

        @Override
        public List getAnnotatedClasses(WebAnnotationProcessor webAnnotationProcessor) {
            if (this.annotatedClasses != null) {
                return this.annotatedClasses;
            }
            List list = webAnnotationProcessor.getAnnotatedClasses(WARModule.this.moduleClassFinder.getWebappFinder());
            this.annotatedClasses = War.addAllIfNotEmpty(this.annotatedClasses, (Collection)list);
            if (WARModule.this.libraryWar != null) {
                List list2 = WARModule.this.libraryWar.getAnnotatedClasses(webAnnotationProcessor);
                this.annotatedClasses = War.addAllIfNotEmpty(this.annotatedClasses, (Collection)list2);
            }
            if (this.annotatedClasses == null) {
                this.annotatedClasses = Collections.EMPTY_LIST;
            }
            return this.annotatedClasses;
        }

        private Map getWebTldInfo() {
            if (this.tldInfo == null) {
                ArrayList arrayList = new ArrayList();
                War.findTlds(WARModule.this.resourceFinder.getWebappFinder(), arrayList, WARModule.this.moduleClassFinder.getWebappFinder());
                this.tldInfo = TldCacheHelper.parseTagLibraries(arrayList, WARModule.this.moduleExtractDir, WARModule.this.getURI());
            }
            return this.tldInfo;
        }
    }
}

