/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.descriptor.DescriptorBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.compiler.ToolFailureException;

public abstract class WLSModule
extends EARModule {
    MultiClassFinder moduleClassFinder = new MultiClassFinder();

    public WLSModule(String string, String string2) {
        super(string, string2);
    }

    public ClassFinder getClassFinder() {
        return this.moduleClassFinder;
    }

    public void initModuleClassLoader(CompilerCtx compilerCtx, GenericClassLoader genericClassLoader) throws ToolFailureException {
        this.moduleClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(this.getOutputDir().getPath()));
        if (this.isSplitDir(compilerCtx)) {
            File[] fileArray = compilerCtx.getEar().getModuleRoots(this.getURI());
            for (int i = 0; i < fileArray.length; ++i) {
                this.moduleClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(fileArray[i].getAbsolutePath()));
            }
        }
        super.initModuleClassLoader(compilerCtx, genericClassLoader);
    }

    public void compile(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
        this.populateMVI(genericClassLoader, compilerCtx);
    }

    public String getModuleName() {
        return this.getModuleValidationInfo().getModuleName();
    }

    public void setModuleName(String string) {
        this.getModuleValidationInfo().setModuleName(string);
    }

    public DescriptorBean getRootBean() {
        return this.getRootBean(this.getURI());
    }

    protected GenericClassLoader getCL(String string) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassFinder classFinder = NullClassFinder.NULL_FINDER;
        if (classLoader instanceof GenericClassLoader) {
            classFinder = ((GenericClassLoader)classLoader).getClassFinder();
        }
        return this.createClassLoader(classFinder, classLoader, string);
    }

    private GenericClassLoader createClassLoader(ClassFinder classFinder, ClassLoader classLoader, final String string) throws IOException {
        return new GenericClassLoader(classFinder, classLoader){

            public InputStream getResourceAsStream(String string2) {
                if (string2.equals(string)) {
                    try {
                        return new FileInputStream(new File(WLSModule.this.getOutputFileName()));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                return super.getResourceAsStream(string2);
            }
        };
    }
}

