/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.utils.ClassFinderMetaDataEnumaration;
import weblogic.application.utils.VirtualJarFileMetaDataIterator;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.deploy.WSEEDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEEModuleHelper {
    private static Class[] identitytAnnotationClasses;
    private static ClassAnnotationMetaDataFilter identityAnnotationFilter;
    private WSEEDescriptor wsDescriptor;
    private WebservicesBean wsBean;
    private WeblogicWebservicesBean wlWsBean;
    private boolean isWar;

    public WSEEModuleHelper(CompilerCtx compilerCtx, VirtualJarFile virtualJarFile, String string, boolean bl) {
        this.isWar = bl;
        this.wsDescriptor = new WSEEDescriptor(virtualJarFile, compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), string, bl);
        this.reloadDescriptors();
    }

    private void reloadDescriptors() {
        try {
            this.wsBean = this.wsDescriptor.getWebservicesBean();
            try {
                this.wlWsBean = this.wsDescriptor.getWeblogicWebservicesBean();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.wlWsBean = null;
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamException.printStackTrace();
                this.wlWsBean = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.wsBean = null;
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            this.wsBean = null;
        }
    }

    public WebservicesBean getWsBean() {
        return this.wsBean;
    }

    public WeblogicWebservicesBean getWlWsBean() {
        return this.wlWsBean;
    }

    public void mergeDescriptors(ClassFinder classFinder) {
        try {
            this.wsDescriptor.mergeWebServicesDescriptors(classFinder);
            this.wsDescriptor.mergeWeblogicWebServicesDescriptor(classFinder);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        this.reloadDescriptors();
    }

    private Set getAnnotatedClassnames(VirtualJarFile virtualJarFile) {
        HashSet<String> hashSet = new HashSet<String>();
        VirtualJarFileMetaDataIterator virtualJarFileMetaDataIterator = new VirtualJarFileMetaDataIterator(virtualJarFile, (MetaDataFilter)identityAnnotationFilter);
        try {
            while (virtualJarFileMetaDataIterator.hasNext()) {
                String string = (String)virtualJarFileMetaDataIterator.next();
                string = string.replace('/', '.');
                string = string.substring(0, string.length() - 6);
                hashSet.add(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashSet;
    }

    private Set getAnnotatedClassnames(GenericClassLoader genericClassLoader) {
        HashSet<String> hashSet = new HashSet<String>();
        ClassFinderMetaDataEnumaration classFinderMetaDataEnumaration = new ClassFinderMetaDataEnumaration(genericClassLoader.getClassFinder(), identityAnnotationFilter);
        while (classFinderMetaDataEnumaration.hasMoreElements()) {
            hashSet.add((String)classFinderMetaDataEnumaration.nextElement());
        }
        return hashSet;
    }

    public void processAnnotations(GenericClassLoader genericClassLoader, String[][] stringArray) throws ClassNotFoundException, ErrorCollectionException {
        Set set = this.getAnnotatedClassnames(genericClassLoader);
        this.loadAndAppendOtherLinks(set, (ClassLoader)genericClassLoader, stringArray);
        this.processAnnotationsWithServiceLinks((ClassLoader)genericClassLoader, stringArray, set);
    }

    private Set loadAndAppendOtherLinks(Set set, ClassLoader classLoader, String[][] stringArray) throws ClassNotFoundException {
        for (String[] stringArray2 : stringArray) {
            if (stringArray2[1] == null || set.contains(stringArray2[1])) continue;
            Class<?> clazz = classLoader.loadClass(stringArray2[1]);
            for (int i = 0; i < identitytAnnotationClasses.length; ++i) {
                if (clazz.getAnnotation(identitytAnnotationClasses[i]) == null) continue;
                set.add(stringArray2[1]);
            }
        }
        return set;
    }

    public void processAnnotations(VirtualJarFile virtualJarFile, ClassLoader classLoader, String[][] stringArray) throws ClassNotFoundException, ErrorCollectionException {
        Set set = this.getAnnotatedClassnames(virtualJarFile);
        this.loadAndAppendOtherLinks(set, classLoader, stringArray);
        this.processAnnotationsWithServiceLinks(classLoader, stringArray, set);
    }

    private void processAnnotationsWithServiceLinks(ClassLoader classLoader, String[][] stringArray, Set set) throws ClassNotFoundException, ErrorCollectionException {
        if (set.size() > 0) {
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            for (String[] stringArray2 : stringArray) {
                if (!set.contains(stringArray2[1])) continue;
                hashMap.put(stringArray2[0], classLoader.loadClass(stringArray2[1]));
            }
            this.processAnnotations(classLoader, hashMap);
        }
    }

    private void processAnnotations(ClassLoader classLoader, Map<String, Class> map) throws ClassNotFoundException, ErrorCollectionException {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.wsBean != null) {
                arrayList.add(this.wsBean);
            }
            if (this.wlWsBean != null) {
                arrayList.add(this.wlWsBean);
            }
            Class<?> clazz = Class.forName("weblogic.wsee.tools.jws.jaxws.JAXWSAnnotationProcessor");
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("process", Collection.class, ClassLoader.class, Map.class, Boolean.TYPE);
            method.invoke(obj, arrayList, classLoader, map, this.isWar);
            for (Object e : arrayList) {
                if (e instanceof WebservicesBean) {
                    this.wsBean = (WebservicesBean)e;
                    continue;
                }
                if (!(e instanceof WeblogicWebservicesBean)) continue;
                this.wlWsBean = (WeblogicWebservicesBean)e;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new AssertionError((Object)"Unable to instantiate Annotation processor class");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof ErrorCollectionException) {
                throw (ErrorCollectionException)throwable;
            }
            if (throwable instanceof NoClassDefFoundError) {
                throw (NoClassDefFoundError)throwable;
            }
            invocationTargetException.printStackTrace();
            throw new AssertionError((Object)"Unable to invoke Annotation processoror");
        }
    }

    static {
        try {
            identitytAnnotationClasses = new Class[]{Class.forName("javax.jws.WebService"), Class.forName("javax.xml.ws.WebServiceProvider")};
            identityAnnotationFilter = new ClassAnnotationMetaDataFilter(identitytAnnotationClasses);
        }
        catch (Throwable throwable) {
            identityAnnotationFilter = null;
        }
    }
}

