/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.XMLMetaDataParser;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import serp.bytecode.Project;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.VirtualJarFileMetaDataIterator;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;

public abstract class AbstractClassEnhanceFlow
extends CompilerFlow {
    protected static final String JPA_CONFIGURATION_NAME = "META-INF/persistence.xml";
    protected static final String OPJPA_PROVIDER = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    protected static final String KODO_PROVIDER = "kodo.persistence.PersistenceProviderImpl";
    public static final String WEBINF_CLASSES = File.separatorChar + "WEB-INF" + File.separatorChar + "classes";
    public static final String WEBINF_LIB = File.separatorChar + "WEB-INF" + File.separatorChar + "lib" + File.separatorChar;
    public static final String APP_CLASSES = File.separatorChar + "APP-INF" + File.separatorChar + "classes";
    public static final String PERSISTENCE_XML = "<?xml version=\"1.0\"?> <persistence xmlns=\"http://java.sun.com/xml/ns/persistence\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd\" version=\"1.0\"> <persistence-unit name=\"default\"> </persistence-unit> </persistence> ";
    protected Collection jarFiles = new HashSet();
    private Class[] enhanceClasses = new Class[]{Entity.class, Embeddable.class, MappedSuperclass.class};

    public AbstractClassEnhanceFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void cleanup() throws ToolFailureException {
    }

    protected File createConfigFile() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"), "persistence.xml");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(PERSISTENCE_XML);
        fileWriter.close();
        return file;
    }

    protected void processJars(Collection collection, File file, Collection collection2, ClassLoader classLoader, boolean bl) throws ToolFailureException {
        for (String string : collection) {
            this.processJar(new File(string), file, collection2, classLoader, bl);
        }
    }

    protected void processJar(File file, File file2, Collection collection, ClassLoader classLoader, boolean bl) throws ToolFailureException {
        String string = this.ctx.getOutputDir().getPath() + File.separatorChar + "tempjar" + System.currentTimeMillis();
        try {
            try {
                JarFileUtils.extract((File)file, (File)new File(string));
                this.processDir(string, file2, collection, classLoader, bl);
                JarFileUtils.createJarFileFromDirectory((File)file, (File)new File(string));
            }
            catch (IOException iOException) {
                throw new ToolFailureException(iOException.getMessage(), (Throwable)iOException);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            FileUtils.remove((File)new File(string));
            throw throwable;
        }
        FileUtils.remove((File)new File(string));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processDir(String var1_1, File var2_2, Collection var3_3, ClassLoader var4_4, boolean var5_5) throws ToolFailureException {
        block13: {
            block12: {
                var6_6 = null;
                try {
                    try {
                        var7_7 = new File(var1_1);
                        if (!var7_7.exists()) {
                            var17_10 = null;
                            if (var6_6 == null) return;
                            break block12;
                        }
                        var6_6 = VirtualJarFactory.createVirtualJar((File)var7_7);
                        var8_16 = new OpenJPAConfigurationImpl();
                        var9_17 = new Options();
                        var9_17.put((Object)"p", (Object)var2_2.getCanonicalPath());
                        Configurations.populateConfiguration((Configuration)var8_16, (Options)var9_17);
                        var10_18 = new VirtualJarFileMetaDataIterator(var6_6, (MetaDataFilter)new ClassAnnotationMetaDataFilter(this.enhanceClasses));
                        var11_19 = new Project();
                        while (var10_18.hasNext()) {
                            var13_21 = (String)var10_18.next();
                            var14_22 = var13_21.replace('/', '.');
                            if (!var3_3.contains(var14_22 = var14_22.substring(0, var14_22.length() - 6)) && var5_5) continue;
                            var15_23 = Class.forName(var14_22, false, var4_4);
                            var12_20 = new PCEnhancer((OpenJPAConfiguration)var8_16, var15_23);
                            var12_20.setDirectory(var7_7);
                            var12_20.run();
                            var12_20.record();
                            var11_19.clear();
                        }
                        break block13;
                    }
                    catch (IOException var7_8) {
                        throw new ToolFailureException(var7_8.getMessage(), (Throwable)var7_8);
                    }
                    catch (ClassNotFoundException var7_9) {
                        throw new ToolFailureException(var7_9.getMessage(), (Throwable)var7_9);
                    }
                }
                catch (Throwable var16_24) {
                    var17_12 = null;
                    if (var6_6 == null) throw var16_24;
                    try {
                        var6_6.close();
                        throw var16_24;
                    }
                    catch (IOException var18_15) {
                        // empty catch block
                    }
                    throw var16_24;
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 272->282)] { 
lbl47:
            // 1 sources

            var6_6.close();
            return;
lbl49:
            // 1 sources

            catch (IOException var18_13) {
                // empty catch block
            }
            return;
        }
        var17_11 = null;
        if (var6_6 == null) return;
        try {}
        catch (IOException var18_14) {}
        var6_6.close();
        return;
    }

    protected Collection getEntityClasses(ClassLoader classLoader) throws ToolFailureException {
        HashSet hashSet = new HashSet();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader2 = thread2.getContextClassLoader();
        thread2.setContextClassLoader(classLoader);
        try {
            try {
                HashSet<URL> hashSet2 = new HashSet<URL>(Collections.list(classLoader.getResources(JPA_CONFIGURATION_NAME)));
                ConfigurationParser configurationParser = new ConfigurationParser(null);
                for (URL uRL : hashSet2) {
                    configurationParser.parse(uRL);
                    for (PersistenceUnitInfoImpl persistenceUnitInfoImpl : configurationParser.getResults()) {
                        this.jarFiles.addAll(persistenceUnitInfoImpl.getJarFileUrls());
                        String string = persistenceUnitInfoImpl.getPersistenceProviderClassName();
                        if (string != null && !string.equals(OPJPA_PROVIDER) && !string.equals(KODO_PROVIDER)) continue;
                        hashSet.addAll(persistenceUnitInfoImpl.getManagedClassNames());
                    }
                    configurationParser.clear();
                }
                Object var13_13 = null;
                thread2.setContextClassLoader(classLoader2);
            }
            catch (IOException iOException) {
                throw new ToolFailureException(iOException.getMessage(), (Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            thread2.setContextClassLoader(classLoader2);
            throw throwable;
        }
        return hashSet;
    }

    class ConfigurationParser
    extends XMLMetaDataParser {
        private final Map _map;
        private PersistenceUnitInfoImpl _info = null;
        private URL _source = null;

        public ConfigurationParser(Map map) {
            this._map = map;
            this.setCaching(false);
            this.setValidating(true);
            this.setParseText(true);
        }

        public void parse(URL uRL) throws IOException {
            this._source = uRL;
            super.parse(uRL);
        }

        public void parse(File file) throws IOException {
            this._source = file.toURL();
            super.parse(file);
        }

        protected Object getSchemaSource() {
            return ((Object)((Object)this)).getClass().getResourceAsStream("persistence-xsd.rsrc");
        }

        protected void reset() {
            super.reset();
            this._info = null;
            this._source = null;
        }

        protected boolean startElement(String string, Attributes attributes) throws SAXException {
            if (this.currentDepth() == 1) {
                this.startPersistenceUnit(attributes);
            } else if (this.currentDepth() == 3 && "property".equals(string)) {
                this._info.setProperty(attributes.getValue("name"), attributes.getValue("value"));
            }
            return true;
        }

        protected void endElement(String string) throws SAXException {
            if (this.currentDepth() == 1) {
                this._info.fromUserProperties(this._map);
                this.addResult(this._info);
            }
            if (this.currentDepth() != 2) {
                return;
            }
            switch (string.charAt(0)) {
                case 'c': {
                    this._info.addManagedClassName(this.currentText());
                }
                case 'e': {
                    this._info.setExcludeUnlistedClasses("true".equalsIgnoreCase(this.currentText()));
                    break;
                }
                case 'j': {
                    if ("jta-data-source".equals(string)) {
                        this._info.setJtaDataSourceName(this.currentText());
                        break;
                    }
                    try {
                        this._info.addJarFileName(AbstractClassEnhanceFlow.this.ctx.getEar().getURI() + "#" + this.currentText());
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw this.getException(illegalArgumentException.getMessage());
                    }
                }
                case 'm': {
                    this._info.addMappingFileName(this.currentText());
                    break;
                }
                case 'n': {
                    this._info.setNonJtaDataSourceName(this.currentText());
                    break;
                }
                case 'p': {
                    if (!"provider".equals(string)) break;
                    this._info.setPersistenceProviderClassName(this.currentText());
                }
            }
        }

        private void startPersistenceUnit(Attributes attributes) throws SAXException {
            this._info = new PersistenceUnitInfoImpl();
            this._info.setPersistenceUnitName(attributes.getValue("name"));
            String string = attributes.getValue("transaction-type");
            if (this._source != null) {
                this._info.setPersistenceXmlFileUrl(this._source);
            }
        }
    }
}

