/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.Compiler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.CompilerFactory;
import weblogic.application.compiler.ToolsFactoryManager;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.compiler.ToolFailureException;

public final class AppCompilerFlow
extends CompilerFlow {
    private File sourceFile;

    public AppCompilerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.sourceFile = this.ctx.getSourceFile();
        this.compileInput(this.ctx);
        if (this.ctx.getTargetArchive() != null) {
            AppcUtils.createOutputArchive(this.ctx.getTargetArchive(), this.ctx.getOutputDir());
        }
        if (this.ctx.isVerbose()) {
            J2EELogger.logCompilationComplete();
        }
    }

    public void cleanup() {
    }

    private Compiler createCompiler(CompilerCtx compilerCtx) throws ToolFailureException {
        Compiler compiler;
        CompilerFactory[] compilerFactoryArray = ToolsFactoryManager.compilerFactories;
        for (int i = 0; i < compilerFactoryArray.length; ++i) {
            try {
                compiler = compilerFactoryArray[i].createCompiler(compilerCtx, this.sourceFile);
                if (compiler == null) continue;
                return compiler;
            }
            catch (IOException iOException) {
                throw new ToolFailureException(StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
        }
        if (this.sourceFile.isDirectory()) {
            Loggable loggable = J2EELogger.logAppcNoValidModuleFoundInDirectoryLoggable((String)this.sourceFile.getAbsolutePath());
            throw new ToolFailureException(loggable.getMessage());
        }
        String string = this.sourceFile.getName().toLowerCase();
        if (string.endsWith(".jar")) {
            compiler = J2EELogger.logAppcJarNotValidLoggable((String)this.sourceFile.getAbsolutePath());
            throw new ToolFailureException(compiler.getMessage());
        }
        if (WarDetector.instance.suffixed(string)) {
            compiler = J2EELogger.logAppcWarNotValidLoggable((String)this.sourceFile.getAbsolutePath());
            throw new ToolFailureException(compiler.getMessage());
        }
        if (string.endsWith(".rar")) {
            compiler = J2EELogger.logAppcRarNotValidLoggable((String)this.sourceFile.getAbsolutePath());
            throw new ToolFailureException(compiler.getMessage());
        }
        compiler = J2EELogger.logAppcEarNotValidLoggable((String)this.sourceFile.getAbsolutePath());
        throw new ToolFailureException(compiler.getMessage());
    }

    private void compileInput(CompilerCtx compilerCtx) throws ToolFailureException {
        Compiler compiler = this.createCompiler(compilerCtx);
        try {
            compiler.compile();
        }
        catch (ToolFailureException toolFailureException) {
            throw toolFailureException;
        }
        catch (Throwable throwable) {
            Loggable loggable = J2EELogger.logAppcErrorProcessingFileLoggable((String)this.sourceFile.getAbsolutePath(), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new ToolFailureException(loggable.getMessage(), throwable);
        }
    }
}

