/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.Merger;
import weblogic.application.compiler.MergerFactory;
import weblogic.application.compiler.ToolsFactoryManager;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.compiler.ToolFailureException;

public final class AppMergerFlow
extends CompilerFlow {
    private File sourceFile;
    private Merger merger;

    public AppMergerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.sourceFile = this.ctx.getSourceFile();
        this.mergeInput(this.ctx);
    }

    public void cleanup() throws ToolFailureException {
        this.merger.cleanup();
        if (!this.ctx.isReadOnlyInvocation() && this.ctx.getTargetArchive() != null) {
            AppcUtils.createOutputArchive(this.ctx.getTargetArchive(), this.ctx.getOutputDir());
        }
    }

    private Merger createMerger(CompilerCtx compilerCtx) throws ToolFailureException {
        File file = compilerCtx.getSourceFile();
        MergerFactory[] mergerFactoryArray = ToolsFactoryManager.mergerFactories;
        for (int i = 0; i < mergerFactoryArray.length; ++i) {
            if (!(mergerFactoryArray[i] instanceof MergerFactory)) continue;
            Merger merger = null;
            try {
                merger = mergerFactoryArray[i].createMerger(compilerCtx, file);
            }
            catch (IOException iOException) {
                throw new ToolFailureException(StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
            if (merger == null) continue;
            return merger;
        }
        Loggable loggable = J2EELogger.logAppcNoValidModuleFoundInDirectoryLoggable((String)this.sourceFile.getAbsolutePath());
        throw new ToolFailureException(loggable.getMessage());
    }

    private void mergeInput(CompilerCtx compilerCtx) throws ToolFailureException {
        this.merger = this.createMerger(compilerCtx);
        try {
            this.merger.merge();
        }
        catch (ToolFailureException toolFailureException) {
            throw toolFailureException;
        }
        catch (Throwable throwable) {
            Loggable loggable = J2EELogger.logAppcErrorProcessingFileLoggable((String)this.sourceFile.getAbsolutePath(), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new ToolFailureException(loggable.getMessage(), throwable);
        }
    }
}

