/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.WLSModule;
import weblogic.application.compiler.flow.ModuleViewerFlow;
import weblogic.application.utils.PersistenceUtils;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.EditableJ2eeApplicationObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deployment.PersistenceUnitViewer;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.module.WLDFModule;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.ToolFailureException;

public class ApplicationViewerFlow
extends ModuleViewerFlow {
    private static Map supportedURIs = new HashMap();

    public ApplicationViewerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        WebLogicDeployableObjectFactory webLogicDeployableObjectFactory = this.ctx.getObjectFactory();
        EARModule[] eARModuleArray = this.ctx.getModules();
        if (debug) {
            this.say("No. of regular modules found " + eARModuleArray.length);
        }
        if (webLogicDeployableObjectFactory != null) {
            EditableJ2eeApplicationObject editableJ2eeApplicationObject;
            ArrayList<EditableDeployableObject> arrayList = new ArrayList<EditableDeployableObject>();
            try {
                editableJ2eeApplicationObject = webLogicDeployableObjectFactory.createApplicationObject();
                editableJ2eeApplicationObject.setVirtualJarFile(this.ctx.getVSource());
                editableJ2eeApplicationObject.setRootBean((DescriptorBean)this.ctx.getApplicationDescriptor().getApplicationDescriptor());
                editableJ2eeApplicationObject.addRootBean("META-INF/application.xml", (DescriptorBean)this.ctx.getApplicationDescriptor().getApplicationDescriptor(), null);
                editableJ2eeApplicationObject.addRootBean("META-INF/weblogic-application.xml", (DescriptorBean)this.ctx.getApplicationDescriptor().getWeblogicApplicationDescriptor(), null);
                editableJ2eeApplicationObject.addRootBean("META-INF/weblogic-extension.xml", (DescriptorBean)this.ctx.getApplicationDescriptor().getWeblogicExtensionDescriptor(), null);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ToolFailureException("Unable to create Application Object", (Throwable)xMLStreamException);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to create Application Object", (Throwable)iOException);
            }
            try {
                for (int i = 0; i < eARModuleArray.length; ++i) {
                    if (eARModuleArray[i] instanceof WLSModule) {
                        this.addWLSModuleDescriptor(editableJ2eeApplicationObject, (WLSModule)eARModuleArray[i]);
                        continue;
                    }
                    arrayList.add(this.createDeployableObject(webLogicDeployableObjectFactory, eARModuleArray[i]));
                }
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to create deployable object", (Throwable)iOException);
            }
            try {
                this.addCustomeModuleDescriptors(editableJ2eeApplicationObject);
                this.addPersistenceDescriptors(editableJ2eeApplicationObject);
                editableJ2eeApplicationObject.setClassLoader(this.ctx.getApplicationContext().getAppClassLoader());
                editableJ2eeApplicationObject.setResourceFinder(new ApplicationResourceFinder(this.ctx.getEar().getURI(), this.ctx.getApplicationContext().getAppClassLoader().getClassFinder()));
                this.ctx.setDeployableApplication(editableJ2eeApplicationObject);
                for (EditableDeployableObject editableDeployableObject : arrayList) {
                    editableJ2eeApplicationObject.addDeployableObject(editableDeployableObject);
                }
                this.addDiagnosticDescriptor(editableJ2eeApplicationObject);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to create Application Object", (Throwable)iOException);
            }
        }
    }

    public void cleanup() {
    }

    private void addCustomeModuleDescriptors(EditableJ2eeApplicationObject editableJ2eeApplicationObject) {
        EARModule[] eARModuleArray = this.ctx.getCustomModules();
        if (eARModuleArray == null) {
            return;
        }
        if (debug) {
            this.say("No. of custom modules found " + eARModuleArray.length);
        }
        for (int i = 0; i < eARModuleArray.length; ++i) {
            if (debug) {
                this.say("Adding descriptor for CustomModule " + eARModuleArray[i].getURI());
            }
            this.addModuleDescriptor(editableJ2eeApplicationObject, eARModuleArray[i]);
        }
    }

    private void addWLSModuleDescriptor(EditableJ2eeApplicationObject editableJ2eeApplicationObject, WLSModule wLSModule) {
        if (debug) {
            this.say("Adding descriptor for WLSModule " + wLSModule.getURI());
        }
        this.addModuleDescriptor(editableJ2eeApplicationObject, wLSModule);
    }

    private void addModuleDescriptor(EditableJ2eeApplicationObject editableJ2eeApplicationObject, EARModule eARModule) {
        String[] stringArray = eARModule.getDescriptorUris();
        for (int i = 0; i < stringArray.length; ++i) {
            DescriptorBean descriptorBean = eARModule.getRootBean(stringArray[i]);
            if (descriptorBean == null) continue;
            if (debug) {
                this.say("Adding descriptor " + stringArray[i]);
            }
            editableJ2eeApplicationObject.addRootBean(stringArray[i], descriptorBean, eARModule.getModuleType());
        }
    }

    private void addPersistenceDescriptors(EditableJ2eeApplicationObject editableJ2eeApplicationObject) throws ToolFailureException, IOException {
        PersistenceUnitViewer persistenceUnitViewer = this.ctx.getPerViewer();
        if (persistenceUnitViewer == null) {
            PersistenceUtils.addRootPersistenceJars(this.ctx.getApplicationContext().getAppClassLoader(), this.ctx.getApplicationContext().getApplicationId(), this.ctx.getApplicationDD());
            persistenceUnitViewer = new PersistenceUnitViewer.ResourceViewer(this.ctx.getApplicationContext().getAppClassLoader(), this.ctx.getApplicationContext().getApplicationId(), this.ctx.getConfigDir(), this.ctx.getPlanBean());
            persistenceUnitViewer.loadDescriptors();
        }
        Iterator iterator = persistenceUnitViewer.getDescriptorURIs();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (debug) {
                this.say("Adding uri " + string);
            }
            Descriptor descriptor = persistenceUnitViewer.getDescriptor(string);
            editableJ2eeApplicationObject.addRootBean(string, descriptor.getRootBean(), null);
        }
    }

    private void addDiagnosticDescriptor(EditableJ2eeApplicationObject editableJ2eeApplicationObject) {
        DescriptorBean descriptorBean;
        File file = null;
        DeploymentPlanBean deploymentPlanBean = this.ctx.getPlanBean();
        File file2 = this.ctx.getConfigDir();
        if (deploymentPlanBean != null) {
            descriptorBean = deploymentPlanBean.getModuleOverrides();
            for (int i = 0; i < ((ModuleOverrideBean[])descriptorBean).length; ++i) {
                if (descriptorBean[i].getModuleName().equals(this.ctx.getEar().getURI()) && descriptorBean[i].getModuleType().equals(editableJ2eeApplicationObject.getType().toString())) {
                    ModuleDescriptorBean[] moduleDescriptorBeanArray = descriptorBean[i].getModuleDescriptors();
                    for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                        if (!moduleDescriptorBeanArray[j].isExternal() || !moduleDescriptorBeanArray[j].getRootElement().equals("wldf-resource")) continue;
                        file = new File(file2, moduleDescriptorBeanArray[j].getUri());
                        if (file.isFile() && file.exists()) break;
                        file = null;
                    }
                }
                if (file != null) break;
            }
        }
        try {
            DescriptorBean descriptorBean2 = descriptorBean = file != null ? WLDFModule.getDescriptorBean(file, this.ctx.getConfigDir(), this.ctx.getPlanBean(), this.ctx.getEar().getURI(), "META-INF/weblogic-diagnostics.xml") : WLDFModule.getDescriptorBean(this.ctx.getVSource(), this.ctx.getConfigDir(), this.ctx.getPlanBean(), this.ctx.getEar().getURI(), "META-INF/weblogic-diagnostics.xml");
            if (descriptorBean != null) {
                editableJ2eeApplicationObject.addRootBean("META-INF/weblogic-diagnostics.xml", descriptorBean, null);
            } else {
                editableJ2eeApplicationObject.addRootBean("META-INF/weblogic-diagnostics.xml", new DescriptorManager().createDescriptorRoot(WLDFResourceBean.class).getRootBean(), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSupportedURI(ModuleType moduleType, String string) {
        Set set;
        if (moduleType != null && string != null && (set = (Set)supportedURIs.get(moduleType)) != null) {
            return set.contains(string);
        }
        return false;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("META-INF/application.xml");
        hashSet.add("META-INF/weblogic-application.xml");
        hashSet.add("META-INF/weblogic-extension.xml");
        hashSet.add("META-INF/persistence.xml");
        hashSet.add("META-INF/persistence-configuration.xml");
        supportedURIs.put(ModuleType.EAR, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("WEB-INF/web.xml");
        hashSet2.add("WEB-INF/weblogic.xml");
        hashSet2.add("WEB-INF/weblogic-extension.xml");
        hashSet2.add("META-INF/persistence.xml");
        hashSet2.add("META-INF/persistence-configuration.xml");
        hashSet2.add("WEB-INF/webservices.xml");
        hashSet2.add("WEB-INF/weblogic-webservices.xml");
        supportedURIs.put(ModuleType.WAR, hashSet2);
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add("META-INF/ejb-jar.xml");
        hashSet3.add("META-INF/weblogic-ejb-jar.xml");
        hashSet3.add("META-INF/persistence.xml");
        hashSet3.add("META-INF/persistence-configuration.xml");
        hashSet3.add("META-INF/webservices.xml");
        hashSet3.add("META-INF/weblogic-webservices.xml");
        supportedURIs.put(ModuleType.EJB, hashSet3);
    }

    public static class ApplicationResourceFinder
    implements ClassFinder {
        private ClassFinder delegate;
        private String prefix;

        public ApplicationResourceFinder(String string, ClassFinder classFinder) {
            this.prefix = string + "#";
            this.delegate = classFinder;
        }

        public Source getSource(String string) {
            return this.delegate.getSource(this.prefix + string);
        }

        public Enumeration getSources(String string) {
            return this.delegate.getSources(this.prefix + string);
        }

        public Source getClassSource(String string) {
            return this.delegate.getClassSource(string);
        }

        public String getClassPath() {
            return this.delegate.getClassPath();
        }

        public ClassFinder getManifestFinder() {
            return this.delegate.getManifestFinder();
        }

        public Enumeration entries() {
            return this.delegate.entries();
        }

        public void close() {
            this.delegate.close();
        }
    }
}

