/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.utils.compiler.ToolFailureException;

public final class CheckLibraryReferenceFlow
extends CompilerFlow {
    private final boolean isError;

    public CheckLibraryReferenceFlow(CompilerCtx compilerCtx) {
        this(compilerCtx, true);
    }

    public CheckLibraryReferenceFlow(CompilerCtx compilerCtx, boolean bl) {
        super(compilerCtx);
        this.isError = bl;
    }

    public void compile() throws ToolFailureException {
        BuildtimeApplicationContext buildtimeApplicationContext = (BuildtimeApplicationContext)this.ctx.getApplicationContext();
        try {
            LibraryLoggingUtils.verifyLibraryReferences(buildtimeApplicationContext.getLibraryManagerAggregate(), this.isError);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            if (this.isError) {
                throw new ToolFailureException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
            }
            loggableLibraryProcessingException.getLoggable().log();
        }
    }

    public void cleanup() {
    }
}

