/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.util.Arrays;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.compiler.ToolFailureException;

public final class CheckUnusedLibrariesFlow
extends CompilerFlow {
    public CheckUnusedLibrariesFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        Object[] objectArray = this.ctx.getApplicationContext().getLibraryManagerAggregate().getUnreferencedLibraries();
        if (objectArray.length == 0) {
            return;
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].toString());
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        J2EELogger.logAppcUnreferencedLibraries((String)stringBuffer.toString());
    }

    public void cleanup() {
    }
}

