/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.ClassLoaderUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.validation.EARValidator;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.compiler.jdt.JDTJavaCompilerFactory;

public final class CompileModuleFlow
extends CompilerFlow {
    private final BuildtimeApplicationContext libCtx;
    private EARModule[] modules = null;
    private EARValidator earValidator = null;
    private GenericClassLoader cl;

    public CompileModuleFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    public void compile() throws ToolFailureException {
        this.modules = this.ctx.getModules();
        this.earValidator = new EARValidator(this.ctx.getApplicationDD(), this.ctx.getWLApplicationDD());
        this.cl = this.getApplicationClassLoader();
        ClassLoaderUtils.initFilterPatterns(this.ctx.getWLApplicationDD() != null ? this.ctx.getWLApplicationDD().getPreferApplicationPackages() : null, this.ctx.getWLApplicationDD() != null ? this.ctx.getWLApplicationDD().getPreferApplicationResources() : null, this.cl);
        this.compileModules(this.cl);
        try {
            this.earValidator.validate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorsValidatingEarLoggable((String)errorCollectionException.toString()).getMessage(), (Throwable)errorCollectionException);
        }
    }

    private GenericClassLoader getApplicationClassLoader() {
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        multiClassFinder.addFinder(this.ctx.getEar().getClassFinder());
        for (int i = 0; i < this.modules.length; ++i) {
            multiClassFinder.addFinder(this.modules[i].getClassFinder());
        }
        multiClassFinder.addFinder(this.libCtx.getClassFinder());
        return AppcUtils.getClassLoaderForApplication((ClassFinder)multiClassFinder, this.ctx, this.ctx.getApplicationContext().getApplicationId());
    }

    private void compileModules(GenericClassLoader genericClassLoader) throws ToolFailureException {
        boolean bl = this.ctx.getOpts().hasOption("quiet");
        String string = this.ctx.getOpts().getOption("moduleUri");
        boolean bl2 = false;
        for (int i = 0; i < this.modules.length; ++i) {
            EARModule eARModule = this.modules[i];
            if (string != null && !string.equals(eARModule.getURI())) continue;
            bl2 = true;
            this.earValidator.addModuleValidationInfo(eARModule.getModuleValidationInfo());
            if (!(!this.ctx.isVerbose() && bl || eARModule.isLibrary())) {
                J2EELogger.logCompilingEarModule((String)eARModule.getURI());
            }
            if (debug && !eARModule.isLibrary()) {
                Debug.say((String)("Compiling: " + eARModule.getURI() + " from: " + eARModule.getOutputFileName()));
            }
            eARModule.compile(genericClassLoader, this.ctx);
        }
        if (!bl2) {
            throw new ToolFailureException(J2EELogger.logModuleUriDoesNotExistLoggable((String)string).getMessage());
        }
    }

    public void cleanup() {
        if (this.cl != null) {
            this.cl.close();
            JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)this.cl);
        }
    }
}

